/*
 * Decompiled with CFR 0.152.
 */
package com.daimajia.androidanimations.library;

import android.view.View;
import android.view.animation.Interpolator;
import com.nineoldandroids.animation.Animator;
import com.nineoldandroids.animation.AnimatorSet;
import com.nineoldandroids.view.ViewHelper;

public abstract class BaseViewAnimator {
    public static final long DURATION = 1000L;
    private AnimatorSet mAnimatorSet = new AnimatorSet();
    private long mDuration = 1000L;

    protected abstract void prepare(View var1);

    public void animate(View target) {
        this.reset(target);
        this.prepare(target);
        this.start();
    }

    public void reset(View target) {
        ViewHelper.setAlpha((View)target, (float)1.0f);
        ViewHelper.setScaleX((View)target, (float)1.0f);
        ViewHelper.setScaleY((View)target, (float)1.0f);
        ViewHelper.setTranslationX((View)target, (float)0.0f);
        ViewHelper.setTranslationY((View)target, (float)0.0f);
        ViewHelper.setRotation((View)target, (float)0.0f);
        ViewHelper.setRotationY((View)target, (float)0.0f);
        ViewHelper.setRotationX((View)target, (float)0.0f);
        ViewHelper.setPivotX((View)target, (float)((float)target.getMeasuredWidth() / 2.0f));
        ViewHelper.setPivotY((View)target, (float)((float)target.getMeasuredHeight() / 2.0f));
    }

    public void start() {
        this.mAnimatorSet.setDuration(this.mDuration);
        this.mAnimatorSet.start();
    }

    public BaseViewAnimator setDuration(long duration) {
        this.mDuration = duration;
        return this;
    }

    public BaseViewAnimator setStartDelay(long delay) {
        this.getAnimatorAgent().setStartDelay(delay);
        return this;
    }

    public long getStartDelay() {
        return this.mAnimatorSet.getStartDelay();
    }

    public BaseViewAnimator addAnimatorListener(Animator.AnimatorListener l) {
        this.mAnimatorSet.addListener(l);
        return this;
    }

    public void removeAnimatorListener(Animator.AnimatorListener l) {
        this.mAnimatorSet.removeListener(l);
    }

    public void removeAllListener() {
        this.mAnimatorSet.removeAllListeners();
    }

    public BaseViewAnimator setInterpolator(Interpolator interpolator) {
        this.mAnimatorSet.setInterpolator(interpolator);
        return this;
    }

    public long getDuration() {
        return this.mAnimatorSet.getDuration();
    }

    public AnimatorSet getAnimatorAgent() {
        return this.mAnimatorSet;
    }
}

