/*
 * Decompiled with CFR 0.152.
 */
package com.dailystudio.devbricksx.utils;

import android.content.Context;
import com.dailystudio.devbricksx.utils.FileUtils;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005J\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\b\u001a\u00020\u0005J\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fJ\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u000e\u001a\u00020\u0005\u00a8\u0006\u000f"}, d2={"Lcom/dailystudio/devbricksx/utils/StringUtils;", "", "()V", "linesFromAsset", "", "", "context", "Landroid/content/Context;", "file", "linesFromFile", "linesFromRaw", "resId", "", "linesFromString", "str", "devbricksx_release"})
public final class StringUtils {
    public static final StringUtils INSTANCE;

    @NotNull
    public final List<String> linesFromString(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        StringReader reader = new StringReader(str);
        List lines = TextStreamsKt.readLines((Reader)reader);
        reader.close();
        return lines;
    }

    @NotNull
    public final List<String> linesFromFile(@NotNull String file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = FileUtils.INSTANCE.fileToString(file);
        if (string == null) {
            string = "";
        }
        String content = string;
        return this.linesFromString(content);
    }

    @NotNull
    public final List<String> linesFromAsset(@NotNull Context context, @NotNull String file) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = FileUtils.INSTANCE.assetToString(context, file);
        if (string == null) {
            string = "";
        }
        String content = string;
        return this.linesFromString(content);
    }

    @NotNull
    public final List<String> linesFromRaw(@NotNull Context context, int resId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string = FileUtils.INSTANCE.rawToString(context, resId);
        if (string == null) {
            string = "";
        }
        String content = string;
        return this.linesFromString(content);
    }

    private StringUtils() {
    }

    static {
        StringUtils stringUtils;
        INSTANCE = stringUtils = new StringUtils();
    }
}

