/*
 * Decompiled with CFR 0.152.
 */
package com.dailystudio.devbricksx.utils;

import android.annotation.SuppressLint;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J7\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u00042\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\u001a\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\u000e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000f\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u0015"}, d2={"Lcom/dailystudio/devbricksx/utils/DocumentUriUtils;", "", "()V", "getDataColumn", "", "context", "Landroid/content/Context;", "uri", "Landroid/net/Uri;", "selection", "selectionArgs", "", "(Landroid/content/Context;Landroid/net/Uri;Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "getPath", "getPathCompat", "ctx", "getPathDeprecated", "isDownloadsDocument", "", "isExternalStorageDocument", "isMediaDocument", "devbricksx_release"})
public final class DocumentUriUtils {
    public static final DocumentUriUtils INSTANCE;

    private final String getPathDeprecated(Context ctx, Uri uri) {
        if (uri == null) {
            return null;
        }
        String[] projection = new String[]{"_data"};
        Cursor cursor = ctx.getContentResolver().query(uri, projection, null, null, null);
        if (cursor != null) {
            int columnIndex = cursor.getColumnIndexOrThrow("_data");
            cursor.moveToFirst();
            return cursor.getString(columnIndex);
        }
        return uri.getPath();
    }

    @Nullable
    public final String getPathCompat(@NotNull Context ctx, @NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return Build.VERSION.SDK_INT < 19 ? this.getPathDeprecated(ctx, uri) : this.getPath(ctx, uri);
    }

    @SuppressLint(value={"NewApi"})
    @Nullable
    public final String getPath(@NotNull Context context, @NotNull Uri uri) {
        boolean isKitKat;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        boolean bl = isKitKat = Build.VERSION.SDK_INT >= 19;
        if (isKitKat && DocumentsContract.isDocumentUri((Context)context, (Uri)uri)) {
            if (this.isExternalStorageDocument(uri)) {
                String docId;
                String string = docId = DocumentsContract.getDocumentId((Uri)uri);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"docId");
                CharSequence charSequence = string;
                String string2 = ":";
                int n = 0;
                string2 = new Regex(string2);
                n = 0;
                boolean bl2 = false;
                Collection $this$toTypedArray$iv = string2.split(charSequence, n);
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                String[] split = stringArray;
                String type = split[0];
                if (StringsKt.equals((String)"primary", (String)type, (boolean)true)) {
                    return Environment.getExternalStorageDirectory().toString() + "/" + split[1];
                }
            } else {
                if (this.isDownloadsDocument(uri)) {
                    String id2 = DocumentsContract.getDocumentId((Uri)uri);
                    Uri uri2 = Uri.parse((String)"content://downloads/public_downloads");
                    Long l = Long.valueOf(id2);
                    Intrinsics.checkNotNullExpressionValue((Object)l, (String)"java.lang.Long.valueOf(id)");
                    Uri uri3 = ContentUris.withAppendedId((Uri)uri2, (long)l);
                    Intrinsics.checkNotNullExpressionValue((Object)uri3, (String)"ContentUris.withAppended\u2026eOf(id)\n                )");
                    Uri contentUri = uri3;
                    return this.getDataColumn(context, contentUri, null, null);
                }
                if (this.isMediaDocument(uri)) {
                    Uri uri4;
                    String docId;
                    String string = docId = DocumentsContract.getDocumentId((Uri)uri);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"docId");
                    CharSequence type = string;
                    String $i$f$toTypedArray = ":";
                    int thisCollection$iv = 0;
                    $i$f$toTypedArray = new Regex($i$f$toTypedArray);
                    thisCollection$iv = 0;
                    boolean bl3 = false;
                    Collection $this$toTypedArray$iv = $i$f$toTypedArray.split(type, thisCollection$iv);
                    boolean $i$f$toTypedArray2 = false;
                    Object thisCollection$iv2 = $this$toTypedArray$iv;
                    String[] stringArray = thisCollection$iv2.toArray(new String[0]);
                    if (stringArray == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    String[] split = stringArray;
                    type = split[0];
                    switch (type) {
                        case "image": {
                            Uri uri5 = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                            uri4 = uri5;
                            Intrinsics.checkNotNullExpressionValue((Object)uri5, (String)"MediaStore.Images.Media.EXTERNAL_CONTENT_URI");
                            break;
                        }
                        case "video": {
                            Uri uri6 = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                            uri4 = uri6;
                            Intrinsics.checkNotNullExpressionValue((Object)uri6, (String)"MediaStore.Video.Media.EXTERNAL_CONTENT_URI");
                            break;
                        }
                        case "audio": {
                            Uri uri7 = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                            uri4 = uri7;
                            Intrinsics.checkNotNullExpressionValue((Object)uri7, (String)"MediaStore.Audio.Media.EXTERNAL_CONTENT_URI");
                            break;
                        }
                        default: {
                            Uri uri8 = MediaStore.Downloads.EXTERNAL_CONTENT_URI;
                            uri4 = uri8;
                            Intrinsics.checkNotNullExpressionValue((Object)uri8, (String)"MediaStore.Downloads.EXTERNAL_CONTENT_URI");
                        }
                    }
                    Uri contentUri = uri4;
                    String selection = "_id=?";
                    String[] selectionArgs = new String[]{split[1]};
                    return this.getDataColumn(context, contentUri, selection, selectionArgs);
                }
            }
        } else {
            if (StringsKt.equals((String)"content", (String)uri.getScheme(), (boolean)true)) {
                return this.getDataColumn(context, uri, null, null);
            }
            if (StringsKt.equals((String)"file", (String)uri.getScheme(), (boolean)true)) {
                return uri.getPath();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String getDataColumn(@NotNull Context context, @NotNull Uri uri, @Nullable String selection, @Nullable String[] selectionArgs) {
        Cursor cursor;
        block4: {
            String string;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            cursor = null;
            String column = "_data";
            String[] projection = new String[]{column};
            try {
                cursor = context.getContentResolver().query(uri, projection, selection, selectionArgs, null);
                if (cursor == null || !cursor.moveToFirst()) break block4;
                int column_index = cursor.getColumnIndexOrThrow(column);
                string = cursor.getString(column_index);
            }
            catch (Throwable throwable) {
                Cursor cursor2 = cursor;
                if (cursor2 != null) {
                    cursor2.close();
                }
                throw throwable;
            }
            cursor.close();
            return string;
        }
        Cursor cursor3 = cursor;
        if (cursor3 != null) {
            cursor3.close();
        }
        return null;
    }

    public final boolean isExternalStorageDocument(@NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return Intrinsics.areEqual((Object)"com.android.externalstorage.documents", (Object)uri.getAuthority());
    }

    public final boolean isDownloadsDocument(@NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return Intrinsics.areEqual((Object)"com.android.providers.downloads.documents", (Object)uri.getAuthority());
    }

    public final boolean isMediaDocument(@NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return Intrinsics.areEqual((Object)"com.android.providers.media.documents", (Object)uri.getAuthority());
    }

    private DocumentUriUtils() {
    }

    static {
        DocumentUriUtils documentUriUtils;
        INSTANCE = documentUriUtils = new DocumentUriUtils();
    }
}

