/*
 * Decompiled with CFR 0.152.
 */
package com.dailystudio.devbricksx.utils;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import androidx.annotation.ColorInt;
import androidx.core.graphics.drawable.DrawableCompat;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\u0005\u001a\u00020\u0004J\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\b\b\u0001\u0010\u0005\u001a\u00020\u0004\u00a8\u0006\u000e"}, d2={"Lcom/dailystudio/devbricksx/utils/ColorUtils;", "", "()V", "alphaColor", "", "color", "alpha", "", "getColorDrawable", "Landroid/graphics/drawable/Drawable;", "context", "Landroid/content/Context;", "tintDrawable", "drawable", "devbricksx_release"})
public final class ColorUtils {
    public static final ColorUtils INSTANCE;

    @NotNull
    public final Drawable getColorDrawable(@NotNull Context context, @ColorInt int color) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return (Drawable)new ColorDrawable(color);
    }

    @NotNull
    public final Drawable tintDrawable(@NotNull Drawable drawable, @ColorInt int color) {
        Intrinsics.checkNotNullParameter((Object)drawable, (String)"drawable");
        Drawable drawable2 = DrawableCompat.wrap((Drawable)drawable);
        boolean bl = false;
        boolean bl2 = false;
        Drawable it = drawable2;
        boolean bl3 = false;
        DrawableCompat.setTint((Drawable)it, (int)color);
        Drawable drawable3 = drawable2;
        Intrinsics.checkNotNullExpressionValue((Object)drawable3, (String)"DrawableCompat.wrap(draw\u2026Tint(it, color)\n        }");
        return drawable3;
    }

    public final int alphaColor(@ColorInt int color, float alpha) {
        int alpha2 = MathKt.roundToInt((float)((float)Color.alpha((int)color) * alpha));
        int r = Color.red((int)color);
        int g = Color.green((int)color);
        int b = Color.blue((int)color);
        return Color.argb((int)alpha2, (int)r, (int)g, (int)b);
    }

    private ColorUtils() {
    }

    static {
        ColorUtils colorUtils;
        INSTANCE = colorUtils = new ColorUtils();
    }
}

