/*
 * Decompiled with CFR 0.152.
 */
package com.dailystudio.devbricksx.utils;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import com.dailystudio.devbricksx.app.activity.ActivityLauncher;
import com.dailystudio.devbricksx.development.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u000e"}, d2={"Lcom/dailystudio/devbricksx/utils/AppUtils;", "", "()V", "downloadApplication", "", "context", "Landroid/content/Context;", "packageName", "", "getApplicationIcon", "Landroid/graphics/drawable/Drawable;", "isApplicationInstalled", "", "launchApplication", "devbricksx_release"})
public final class AppUtils {
    public static final AppUtils INSTANCE;

    public final boolean isApplicationInstalled(@NotNull Context context, @NotNull String packageName) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        try {
            context.getPackageManager().getPackageGids(packageName);
            bl = true;
        }
        catch (PackageManager.NameNotFoundException e) {
            bl = false;
        }
        return bl;
    }

    @Nullable
    public final Drawable getApplicationIcon(@NotNull Context context, @NotNull String packageName) {
        Drawable drawable;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        try {
            drawable = context.getPackageManager().getApplicationIcon(packageName);
        }
        catch (PackageManager.NameNotFoundException e) {
            drawable = null;
        }
        return drawable;
    }

    public final void launchApplication(@NotNull Context context, @NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intent intent = context.getPackageManager().getLaunchIntentForPackage(packageName);
        if (intent != null) {
            ActivityLauncher.Companion.launchActivity(context, intent);
        } else {
            Logger.INSTANCE.warn("entry point of application [" + packageName + "] does not found.", new Object[0]);
        }
    }

    public final void downloadApplication(@NotNull Context context, @NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intent intent = new Intent("android.intent.action.VIEW");
        boolean bl = false;
        boolean bl2 = false;
        Intent $this$apply = intent;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl6 = false;
        boolean bl7 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl8 = false;
        $this$buildString.append("https://play.google.com/store/apps/details?id=");
        $this$buildString.append(packageName);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        String link = string;
        $this$apply.setData(Uri.parse((String)link));
        $this$apply.setPackage("com.android.vending");
        Intent intent2 = intent;
        ActivityLauncher.Companion.launchActivity(context, intent2);
    }

    private AppUtils() {
    }

    static {
        AppUtils appUtils;
        INSTANCE = appUtils = new AppUtils();
    }
}

