/*
 * Decompiled with CFR 0.152.
 */
package com.dailystudio.devbricksx.ui;

import android.view.View;
import androidx.recyclerview.widget.RecyclerView;
import com.dailystudio.devbricksx.development.Logger;
import com.dailystudio.devbricksx.settings.OnSelectionChangedListener;
import com.dailystudio.devbricksx.ui.AbsRecyclerAdapter;
import com.dailystudio.devbricksx.ui.OnItemClickListener;
import com.dailystudio.devbricksx.ui.SelectableListItem;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014J\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0006\u0010\u001a\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\tJ\u0016\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J \u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0014\u0010\u001f\u001a\u00020\u00122\f\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000\fJ\u0014\u0010!\u001a\u00020\u00122\f\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000\u0010J\u000e\u0010\"\u001a\u00020\u00122\u0006\u0010#\u001a\u00020\tJ\u0016\u0010$\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010%\u001a\u00020\u0012R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/dailystudio/devbricksx/ui/ListDelegate;", "Item", "", "adapter", "Lcom/dailystudio/devbricksx/ui/AbsRecyclerAdapter;", "(Lcom/dailystudio/devbricksx/ui/AbsRecyclerAdapter;)V", "getAdapter", "()Lcom/dailystudio/devbricksx/ui/AbsRecyclerAdapter;", "inSelectionMode", "", "isSelectionEnabled", "itemClickListener", "Lcom/dailystudio/devbricksx/ui/OnItemClickListener;", "selectedItems", "", "selectionChangedListener", "Lcom/dailystudio/devbricksx/settings/OnSelectionChangedListener;", "clearSelection", "", "getSelection", "", "handleSelection", "holder", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "position", "", "isInSelectionMode", "onBindViewHolder", "performClick", "v", "Landroid/view/View;", "setOnItemClickListener", "l", "setOnSelectionChangedListener", "setSelectionEnabled", "enabled", "startSelection", "stopSelection", "devbricksx_release"})
public final class ListDelegate<Item> {
    private OnItemClickListener<Item> itemClickListener;
    private OnSelectionChangedListener<Item> selectionChangedListener;
    private boolean isSelectionEnabled;
    private boolean inSelectionMode;
    private final Set<Item> selectedItems;
    @NotNull
    private final AbsRecyclerAdapter<Item> adapter;

    public final void onBindViewHolder(@NotNull RecyclerView.ViewHolder holder, int position) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        holder.itemView.setOnClickListener(new View.OnClickListener(this, holder, position){
            final /* synthetic */ ListDelegate this$0;
            final /* synthetic */ RecyclerView.ViewHolder $holder;
            final /* synthetic */ int $position;

            public final void onClick(View v) {
                if (v == null) {
                    return;
                }
                if (this.this$0.isInSelectionMode()) {
                    ListDelegate.access$handleSelection(this.this$0, this.$holder, this.$position);
                } else {
                    ListDelegate.access$performClick(this.this$0, v, this.$holder, this.$position);
                }
            }
            {
                this.this$0 = listDelegate;
                this.$holder = viewHolder;
                this.$position = n;
            }
        });
        if (this.isSelectionEnabled()) {
            holder.itemView.setOnLongClickListener(new View.OnLongClickListener(this, holder, position){
                final /* synthetic */ ListDelegate this$0;
                final /* synthetic */ RecyclerView.ViewHolder $holder;
                final /* synthetic */ int $position;

                public final boolean onLongClick(View v) {
                    if (v == null) {
                        return false;
                    }
                    if (this.this$0.isInSelectionMode()) {
                        return false;
                    }
                    this.this$0.startSelection(this.$holder, this.$position);
                    return true;
                }
                {
                    this.this$0 = listDelegate;
                    this.$holder = viewHolder;
                    this.$position = n;
                }
            });
        }
    }

    public final void setOnItemClickListener(@NotNull OnItemClickListener<Item> l) {
        Intrinsics.checkNotNullParameter(l, (String)"l");
        this.itemClickListener = l;
    }

    public final void setOnSelectionChangedListener(@NotNull OnSelectionChangedListener<Item> l) {
        Intrinsics.checkNotNullParameter(l, (String)"l");
        this.selectionChangedListener = l;
    }

    private final void performClick(View v, RecyclerView.ViewHolder holder, int position) {
        block1: {
            int realPos = holder.getAdapterPosition() == -1 ? position : holder.getAdapterPosition();
            Item item = this.adapter.getListItem(realPos);
            Logger.INSTANCE.debug("[ItemClick]: get tag of item view[" + v + "]: pos [" + realPos + "], item [" + item + ']', new Object[0]);
            Item Item = item;
            if (Item == null) break block1;
            Item Item2 = Item;
            boolean bl = false;
            boolean bl2 = false;
            Item it = Item2;
            boolean bl3 = false;
            OnItemClickListener<Item> onItemClickListener = this.itemClickListener;
            if (onItemClickListener != null) {
                onItemClickListener.onItemClick(v, realPos, it, this.adapter.getListItemId(realPos));
            }
        }
    }

    public final void startSelection(@NotNull RecyclerView.ViewHolder holder, int position) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (this.isInSelectionMode()) {
            return;
        }
        Logger.INSTANCE.debug("start selection mode", new Object[0]);
        this.inSelectionMode = true;
        this.clearSelection();
        OnSelectionChangedListener<Item> onSelectionChangedListener = this.selectionChangedListener;
        if (onSelectionChangedListener != null) {
            onSelectionChangedListener.onSelectionStarted();
        }
        this.handleSelection(holder, position);
    }

    public final void stopSelection() {
        block1: {
            if (!this.isInSelectionMode()) {
                return;
            }
            Logger.INSTANCE.debug("stop selection mode", new Object[0]);
            this.inSelectionMode = false;
            this.clearSelection();
            this.adapter.notifyDataSetChanged();
            OnSelectionChangedListener<Item> onSelectionChangedListener = this.selectionChangedListener;
            if (onSelectionChangedListener == null) break block1;
            onSelectionChangedListener.onSelectionStopped();
        }
    }

    @NotNull
    public final List<Item> getSelection() {
        return CollectionsKt.toList((Iterable)this.selectedItems);
    }

    private final void clearSelection() {
        Iterable $this$forEach$iv = this.selectedItems;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object it = element$iv = iterator.next();
            boolean bl = false;
            if (!(it instanceof SelectableListItem)) continue;
            ((SelectableListItem)it).setItemSelected(false);
        }
        this.selectedItems.clear();
    }

    public final boolean isInSelectionMode() {
        return this.inSelectionMode;
    }

    private final void handleSelection(RecyclerView.ViewHolder holder, int position) {
        block4: {
            int realPos = holder.getAdapterPosition() == -1 ? position : holder.getAdapterPosition();
            Item item = this.adapter.getListItem(realPos);
            Logger.INSTANCE.debug("[Selection]: pos [" + position + "], item [" + item + ']', new Object[0]);
            if (item == null) {
                return;
            }
            boolean contains = this.selectedItems.contains(item);
            if (!contains) {
                this.selectedItems.add(item);
            } else {
                this.selectedItems.remove(item);
            }
            if (item instanceof SelectableListItem) {
                ((SelectableListItem)item).setItemSelected(!contains);
            }
            this.adapter.notifyItemChanged(position);
            OnSelectionChangedListener<Item> onSelectionChangedListener = this.selectionChangedListener;
            if (onSelectionChangedListener == null) break block4;
            onSelectionChangedListener.onSelectionChanged(CollectionsKt.toList((Iterable)this.selectedItems));
        }
    }

    public final void setSelectionEnabled(boolean enabled) {
        this.isSelectionEnabled = enabled;
        if (!enabled) {
            this.stopSelection();
        }
    }

    public final boolean isSelectionEnabled() {
        return this.isSelectionEnabled;
    }

    @NotNull
    public final AbsRecyclerAdapter<Item> getAdapter() {
        return this.adapter;
    }

    public ListDelegate(@NotNull AbsRecyclerAdapter<Item> adapter) {
        Intrinsics.checkNotNullParameter(adapter, (String)"adapter");
        this.adapter = adapter;
        boolean bl = false;
        this.selectedItems = new LinkedHashSet();
    }

    public static final /* synthetic */ void access$handleSelection(ListDelegate $this, RecyclerView.ViewHolder holder, int position) {
        $this.handleSelection(holder, position);
    }

    public static final /* synthetic */ void access$performClick(ListDelegate $this, View v, RecyclerView.ViewHolder holder, int position) {
        $this.performClick(v, holder, position);
    }
}

