/*
 * Decompiled with CFR 0.152.
 */
package com.dailystudio.devbricksx.settings;

import android.annotation.TargetApi;
import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import com.dailystudio.devbricksx.R;
import com.dailystudio.devbricksx.development.Logger;
import com.dailystudio.devbricksx.settings.AbsSetting;
import com.dailystudio.devbricksx.settings.AbsSettingHolder;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0003\u0018\u00002\u00020\u0001B%\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB)\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0007H\u0014J\u001b\u0010\u0014\u001a\u00020\u000e2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u0018\u001a\u00020\u000eH\u0002R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/dailystudio/devbricksx/settings/SettingsView;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "defStyleRes", "(Landroid/content/Context;Landroid/util/AttributeSet;II)V", "settingsContainer", "Landroid/view/ViewGroup;", "addSetting", "", "setting", "Lcom/dailystudio/devbricksx/settings/AbsSetting;", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "setSettings", "settings", "", "([Lcom/dailystudio/devbricksx/settings/AbsSetting;)V", "setupViews", "devbricksx_release"})
public final class SettingsView
extends FrameLayout {
    private ViewGroup settingsContainer;
    private HashMap _$_findViewCache;

    private final void setupViews() {
        this.settingsContainer = (ViewGroup)this.findViewById(R.id.settings_container);
    }

    public void setSettings(@NotNull AbsSetting[] settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        ViewGroup viewGroup = this.settingsContainer;
        if (viewGroup != null) {
            viewGroup.removeAllViews();
        }
        for (AbsSetting s : settings) {
            this.addSetting(s);
        }
    }

    public void addSetting(@NotNull AbsSetting setting) {
        Intrinsics.checkNotNullParameter((Object)setting, (String)"setting");
        Logger.INSTANCE.debug("add setting: " + setting, new Object[0]);
        ViewGroup viewGroup = this.settingsContainer;
        if (viewGroup == null) {
            return;
        }
        ViewGroup container = viewGroup;
        AbsSettingHolder settingHolder = setting.getHolder();
        View view = settingHolder.createView(setting.getContext(), setting);
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-1, -2);
        container.addView(view, (ViewGroup.LayoutParams)lp);
        setting.syncEnabled();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int heightMeasureSpec2 = heightMeasureSpec;
        int mode = View.MeasureSpec.getMode((int)heightMeasureSpec2);
        if (mode != 0x40000000) {
            int maxHeight = this.getResources().getDimensionPixelSize(R.dimen.settings_maximum_height);
            heightMeasureSpec2 = View.MeasureSpec.makeMeasureSpec((int)maxHeight, (int)Integer.MIN_VALUE);
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec2);
    }

    @JvmOverloads
    public SettingsView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.layout_settings_view, (ViewGroup)this);
        this.setupViews();
    }

    public /* synthetic */ SettingsView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public SettingsView(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public SettingsView(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    @TargetApi(value=21)
    public SettingsView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr, defStyleRes);
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.layout_settings_view, (ViewGroup)this);
        this.setupViews();
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }
}

