/*
 * Decompiled with CFR 0.152.
 */
package com.dailystudio.devbricksx.settings;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.CompoundButton;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.TextView;
import androidx.core.widget.TextViewCompat;
import com.dailystudio.devbricksx.R;
import com.dailystudio.devbricksx.development.Logger;
import com.dailystudio.devbricksx.settings.AbsSetting;
import com.dailystudio.devbricksx.settings.AbsSettingHolder;
import com.dailystudio.devbricksx.settings.RadioSetting;
import com.dailystudio.devbricksx.settings.RadioSettingItem;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u00042\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0002J\u0018\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0018\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0014R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/dailystudio/devbricksx/settings/RadioSettingHolder;", "Lcom/dailystudio/devbricksx/settings/AbsSettingHolder;", "()V", "mRadioGroup", "Landroid/widget/RadioGroup;", "bindRadios", "", "context", "Landroid/content/Context;", "radioGroup", "radioSetting", "Lcom/dailystudio/devbricksx/settings/RadioSetting;", "bindSetting", "settingView", "Landroid/view/View;", "setting", "Lcom/dailystudio/devbricksx/settings/AbsSetting;", "invalidate", "onCreateView", "layoutInflater", "Landroid/view/LayoutInflater;", "devbricksx_release"})
public class RadioSettingHolder
extends AbsSettingHolder {
    private RadioGroup mRadioGroup;

    @Override
    @NotNull
    protected View onCreateView(@NotNull Context context, @NotNull LayoutInflater layoutInflater, @NotNull AbsSetting setting) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)layoutInflater, (String)"layoutInflater");
        Intrinsics.checkNotNullParameter((Object)setting, (String)"setting");
        View view = layoutInflater.inflate(R.layout.layout_setting_radio, null);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"layoutInflater.inflate(R\u2026yout_setting_radio, null)");
        return view;
    }

    @Override
    public void invalidate(@NotNull Context context, @NotNull AbsSetting setting) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)setting, (String)"setting");
        RadioGroup radioGroup = this.mRadioGroup;
        if (radioGroup != null) {
            radioGroup.removeAllViews();
        }
        if (setting instanceof RadioSetting) {
            this.bindRadios(context, this.mRadioGroup, (RadioSetting)setting);
        }
    }

    @Override
    protected void bindSetting(@NotNull View settingView, @NotNull AbsSetting setting) {
        Intrinsics.checkNotNullParameter((Object)settingView, (String)"settingView");
        Intrinsics.checkNotNullParameter((Object)setting, (String)"setting");
        super.bindSetting(settingView, setting);
        if (!(setting instanceof RadioSetting)) {
            return;
        }
        this.mRadioGroup = (RadioGroup)settingView.findViewById(R.id.selection_group);
        this.bindRadios(setting.getContext(), this.mRadioGroup, (RadioSetting)setting);
    }

    /*
     * WARNING - void declaration
     */
    private final void bindRadios(Context context, RadioGroup radioGroup, RadioSetting<?> radioSetting) {
        if (radioSetting.getItemCount() <= 0) {
            return;
        }
        String selectedId = radioSetting.getSelectedId();
        int checkedId = -1;
        RadioSettingItem item = null;
        RadioButton rb = null;
        RadioButton[] rbs = new RadioButton[radioSetting.getItemCount()];
        int n = 0;
        int n2 = radioSetting.getItemCount();
        while (n < n2) {
            void i;
            item = (RadioSettingItem)radioSetting.getItem((int)i);
            rb = new RadioButton(context);
            rb.setText(item.getLabel());
            TextViewCompat.setTextAppearance((TextView)((TextView)rb), (int)R.style.SettingsText);
            rb.setTag((Object)item);
            RadioGroup radioGroup2 = radioGroup;
            if (radioGroup2 != null) {
                radioGroup2.addView((View)rb);
            }
            if (!TextUtils.isEmpty((CharSequence)selectedId) && Intrinsics.areEqual((Object)selectedId, (Object)item.getId())) {
                checkedId = rb.getId();
            }
            rbs[i] = rb;
            ++i;
        }
        Logger.INSTANCE.debug("checkedId = " + checkedId, new Object[0]);
        if (checkedId != -1) {
            RadioGroup radioGroup3 = radioGroup;
            if (radioGroup3 != null) {
                radioGroup3.check(checkedId);
            }
        }
        RadioButton[] radioButtonArray = rbs;
        int n3 = radioButtonArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            RadioButton rb2;
            RadioButton radioButton = rb2 = radioButtonArray[n2];
            if (radioButton == null) continue;
            radioButton.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(radioSetting){
                final /* synthetic */ RadioSetting $radioSetting;

                public final void onCheckedChanged(CompoundButton compoundButton, boolean isChecked) {
                    Object o;
                    Logger.INSTANCE.debug("radio " + compoundButton + ": checked = " + isChecked, new Object[0]);
                    if (isChecked && compoundButton != null && (o = compoundButton.getTag()) instanceof RadioSettingItem) {
                        this.$radioSetting.setSelected(((RadioSettingItem)o).getId());
                        this.$radioSetting.notifySettingChange();
                    }
                }
                {
                    this.$radioSetting = radioSetting;
                }
            });
        }
    }
}

