/*
 * Decompiled with CFR 0.152.
 */
package com.dailystudio.devbricksx.utils;

import android.graphics.Matrix;
import com.dailystudio.devbricksx.development.Logger;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JB\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\f\u00a8\u0006\u000e"}, d2={"Lcom/dailystudio/devbricksx/utils/MatrixUtils;", "", "()V", "getTransformationMatrix", "Landroid/graphics/Matrix;", "srcWidth", "", "srcHeight", "dstWidth", "dstHeight", "rotation", "maintainAspectRatio", "", "fitIn", "devbricksx_release"})
public final class MatrixUtils {
    public static final MatrixUtils INSTANCE;

    @NotNull
    public final Matrix getTransformationMatrix(int srcWidth, int srcHeight, int dstWidth, int dstHeight, int rotation, boolean maintainAspectRatio, boolean fitIn) {
        int n;
        boolean bl;
        int outWidth;
        int n2;
        boolean bl2;
        boolean srcInPortrait;
        Logger.INSTANCE.debug("srcWidth = " + srcWidth + ", srcHeight = " + srcHeight, new Object[0]);
        Logger.INSTANCE.debug("dstWidth = " + dstWidth + ", dstHeight = " + dstHeight, new Object[0]);
        Logger.INSTANCE.debug("rotation = " + rotation, new Object[0]);
        Matrix matrix = new Matrix();
        if (rotation != 0) {
            if (rotation % 90 != 0) {
                Logger.INSTANCE.warn("Rotation of %d % 90 != 0", rotation);
                return matrix;
            }
            matrix.postTranslate((float)(-srcWidth) / 2.0f, (float)(-srcHeight) / 2.0f);
            matrix.postRotate((float)rotation);
        }
        boolean bl3 = false;
        boolean srcTranspose = (Math.abs(rotation) + 90) % 180 == 0;
        int inWidth = srcTranspose ? srcHeight : srcWidth;
        int inHeight = srcTranspose ? srcWidth : srcHeight;
        Logger.INSTANCE.debug("inWidth = " + inWidth + ", inHeight = " + inHeight, new Object[0]);
        boolean bl4 = srcInPortrait = inWidth < inHeight;
        if (srcInPortrait) {
            bl2 = false;
            n2 = Math.min(dstWidth, dstHeight);
        } else {
            bl2 = false;
            n2 = outWidth = Math.max(dstWidth, dstHeight);
        }
        if (srcInPortrait) {
            bl = false;
            n = Math.max(dstWidth, dstHeight);
        } else {
            bl = false;
            n = Math.min(dstWidth, dstHeight);
        }
        int outHeight = n;
        Logger.INSTANCE.debug("outWidth = " + outWidth + ", outHeight = " + outHeight, new Object[0]);
        if (inWidth != outWidth || inHeight != outHeight) {
            float scaleFactor;
            float f;
            boolean bl5;
            float scaleFactorX = (float)outWidth / (float)inWidth;
            float scaleFactorY = (float)outHeight / (float)inHeight;
            Logger.INSTANCE.debug("scaleFactorX = " + scaleFactorX + ", scaleFactorY = " + scaleFactorY, new Object[0]);
            if (fitIn) {
                bl5 = false;
                f = Math.min(scaleFactorX, scaleFactorY);
            } else {
                bl5 = false;
                f = scaleFactor = Math.max(scaleFactorX, scaleFactorY);
            }
            if (maintainAspectRatio) {
                matrix.postScale(scaleFactor, scaleFactor);
            } else {
                matrix.postScale(scaleFactorX, scaleFactorY);
            }
            float scaledWidth = (float)inWidth * scaleFactor;
            float scaledHeight = (float)inHeight * scaleFactor;
            Logger.INSTANCE.debug("scaleWidth = " + scaledWidth + ", scaleHeight = " + scaledHeight, new Object[0]);
            if (rotation != 0) {
                matrix.postTranslate(scaledWidth / 2.0f, scaledHeight / 2.0f);
            }
            float translateX = ((float)outWidth - scaledWidth) / 2.0f;
            float translateY = ((float)outHeight - scaledHeight) / 2.0f;
            Logger.INSTANCE.debug("translateX = " + translateX + ", translateY = " + translateY, new Object[0]);
            matrix.postTranslate(translateX, translateY);
        } else if (rotation != 0) {
            matrix.postTranslate((float)outWidth / 2.0f, (float)outHeight / 2.0f);
        }
        return matrix;
    }

    public static /* synthetic */ Matrix getTransformationMatrix$default(MatrixUtils matrixUtils, int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2, int n6, Object object) {
        if ((n6 & 0x20) != 0) {
            bl = true;
        }
        if ((n6 & 0x40) != 0) {
            bl2 = false;
        }
        return matrixUtils.getTransformationMatrix(n, n2, n3, n4, n5, bl, bl2);
    }

    private MatrixUtils() {
    }

    static {
        MatrixUtils matrixUtils;
        INSTANCE = matrixUtils = new MatrixUtils();
    }
}

