/*
 * Decompiled with CFR 0.152.
 */
package com.dailystudio.devbricksx.utils;

import android.content.Context;
import com.dailystudio.devbricksx.development.Logger;
import com.dailystudio.devbricksx.utils.FileUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializer;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JQ\u0010\u0005\u001a\u0004\u0018\u0001H\u0006\"\u0004\b\u0000\u0010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00060\f2\u001e\b\u0002\u0010\r\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u0010JI\u0010\u0011\u001a\u0004\u0018\u0001H\u0006\"\u0004\b\u0000\u0010\u00062\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00060\f2\u001e\b\u0002\u0010\r\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u0012JQ\u0010\u0013\u001a\u0004\u0018\u0001H\u0006\"\u0004\b\u0000\u0010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00060\f2\u001e\b\u0002\u0010\r\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u0016JI\u0010\u0017\u001a\u0004\u0018\u0001H\u0006\"\u0004\b\u0000\u0010\u00062\u0006\u0010\u0018\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00060\f2\u001e\b\u0002\u0010\r\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/dailystudio/devbricksx/utils/JSONUtils;", "", "()V", "GSON", "Lcom/google/gson/Gson;", "fromAsset", "Object", "context", "Landroid/content/Context;", "file", "", "objectClass", "Ljava/lang/Class;", "adapters", "", "Lcom/google/gson/JsonDeserializer;", "(Landroid/content/Context;Ljava/lang/String;Ljava/lang/Class;Ljava/util/Map;)Ljava/lang/Object;", "fromFile", "(Ljava/lang/String;Ljava/lang/Class;Ljava/util/Map;)Ljava/lang/Object;", "fromRaw", "resId", "", "(Landroid/content/Context;ILjava/lang/Class;Ljava/util/Map;)Ljava/lang/Object;", "fromString", "jsonStr", "devbricksx_release"})
public final class JSONUtils {
    private static final Gson GSON;
    public static final JSONUtils INSTANCE;

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final <Object> Object fromString(@NotNull String jsonStr, @NotNull Class<Object> objectClass, @Nullable Map<Class<?>, ? extends JsonDeserializer<?>> adapters) {
        Object object;
        Gson gson;
        Intrinsics.checkNotNullParameter((Object)jsonStr, (String)"jsonStr");
        Intrinsics.checkNotNullParameter(objectClass, (String)"objectClass");
        Logger.INSTANCE.debug("json: " + jsonStr, new Object[0]);
        if (adapters == null) {
            gson = GSON;
        } else {
            GsonBuilder builder2 = new GsonBuilder();
            Object object2 = adapters;
            boolean bl = false;
            Iterator<Map.Entry<Class<?>, JsonDeserializer<?>>> iterator = object2.entrySet().iterator();
            while (iterator.hasNext()) {
                void k;
                Map.Entry<Class<?>, JsonDeserializer<?>> entry;
                Map.Entry<Class<?>, JsonDeserializer<?>> entry2 = entry = iterator.next();
                boolean bl2 = false;
                object2 = entry2.getKey();
                entry2 = entry;
                bl2 = false;
                JsonDeserializer<?> a = entry2.getValue();
                builder2.registerTypeAdapter((Type)k, a);
            }
            gson = builder2.create();
        }
        Gson gson2 = gson;
        try {
            object = gson2.fromJson(jsonStr, objectClass);
        }
        catch (Exception e) {
            Logger.INSTANCE.error("parse json object from [" + jsonStr + "] failed: " + e, new Object[0]);
            object = null;
        }
        return (Object)object;
    }

    public static /* synthetic */ Object fromString$default(JSONUtils jSONUtils, String string, Class clazz, Map map2, int n, Object object) {
        if ((n & 4) != 0) {
            map2 = null;
        }
        return jSONUtils.fromString(string, clazz, map2);
    }

    @Nullable
    public final <Object> Object fromFile(@NotNull String file, @NotNull Class<Object> objectClass, @Nullable Map<Class<?>, ? extends JsonDeserializer<?>> adapters) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(objectClass, (String)"objectClass");
        String string = FileUtils.INSTANCE.fileToString(file);
        if (string == null) {
            return null;
        }
        String json = string;
        if (StringsKt.isBlank((CharSequence)json)) {
            return null;
        }
        return this.fromString(json, objectClass, adapters);
    }

    public static /* synthetic */ Object fromFile$default(JSONUtils jSONUtils, String string, Class clazz, Map map2, int n, Object object) {
        if ((n & 4) != 0) {
            map2 = null;
        }
        return jSONUtils.fromFile(string, clazz, map2);
    }

    @Nullable
    public final <Object> Object fromAsset(@NotNull Context context, @NotNull String file, @NotNull Class<Object> objectClass, @Nullable Map<Class<?>, ? extends JsonDeserializer<?>> adapters) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(objectClass, (String)"objectClass");
        String string = FileUtils.INSTANCE.assetToString(context, file);
        if (string == null) {
            return null;
        }
        String json = string;
        if (StringsKt.isBlank((CharSequence)json)) {
            return null;
        }
        return this.fromString(json, objectClass, adapters);
    }

    public static /* synthetic */ Object fromAsset$default(JSONUtils jSONUtils, Context context, String string, Class clazz, Map map2, int n, Object object) {
        if ((n & 8) != 0) {
            map2 = null;
        }
        return jSONUtils.fromAsset(context, string, clazz, map2);
    }

    @Nullable
    public final <Object> Object fromRaw(@NotNull Context context, int resId, @NotNull Class<Object> objectClass, @Nullable Map<Class<?>, ? extends JsonDeserializer<?>> adapters) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(objectClass, (String)"objectClass");
        String string = FileUtils.INSTANCE.rawToString(context, resId);
        if (string == null) {
            return null;
        }
        String json = string;
        if (StringsKt.isBlank((CharSequence)json)) {
            return null;
        }
        return this.fromString(json, objectClass, adapters);
    }

    public static /* synthetic */ Object fromRaw$default(JSONUtils jSONUtils, Context context, int n, Class clazz, Map map2, int n2, Object object) {
        if ((n2 & 8) != 0) {
            map2 = null;
        }
        return jSONUtils.fromRaw(context, n, clazz, map2);
    }

    private JSONUtils() {
    }

    static {
        JSONUtils jSONUtils;
        INSTANCE = jSONUtils = new JSONUtils();
        GSON = new Gson();
    }
}

