/*
 * Decompiled with CFR 0.152.
 */
package com.dailystudio.devbricksx.utils;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.text.TextUtils;
import com.dailystudio.devbricksx.development.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mozilla.universalchardet.UniversalDetector;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004J\u000e\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004J\u000e\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\fJ\u000e\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004J\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\fJ\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\u0004J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0017\u001a\u00020\u00152\b\u0010\u0018\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\u0004J\u000e\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0004J\u000e\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0004J\u0016\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0004J\u000e\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0004J\u000e\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u0004J\u000e\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\fJ\u0016\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010 \u001a\u00020\nJ\u001e\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\nJ\u000e\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004J\u0016\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\nJ\u001e\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\nJ\u000e\u0010#\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\fJ\u000e\u0010#\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004J\u0010\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u0004H\u0002J\u0018\u0010&\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010'\u001a\u00020\n2\b\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010\b\u001a\u00020\fJ\u0018\u0010'\u001a\u00020\n2\b\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010\u001a\u001a\u00020\u0004J\u0018\u0010*\u001a\u00020+2\u0006\u0010\b\u001a\u00020\u00042\b\u0010,\u001a\u0004\u0018\u00010\u0004J \u0010*\u001a\u00020+2\u0006\u0010\b\u001a\u00020\u00042\b\u0010,\u001a\u0004\u0018\u00010\u00042\u0006\u0010-\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/dailystudio/devbricksx/utils/FileUtils;", "", "()V", "NO_MEDIA_TAG_FILE", "", "assetToString", "context", "Landroid/content/Context;", "file", "checkOrCreateDirectory", "", "directory", "Ljava/io/File;", "nomedia", "checkOrCreateNoMediaDirectory", "checkOrCreateNoMediaTagInDirectory", "dir", "detectFileEncoding", "rawId", "", "iStream", "Ljava/io/InputStream;", "fileToString", "fStream", "encoding", "getBaseName", "filename", "getFileExtension", "defExt", "getFileName", "isFileExisted", "md5Dir", "hiddenFiles", "verbose", "hiddenFies", "md5File", "md5HashOfString", "str", "rawToString", "saveToFile", "bytes", "", "stringToFile", "", "fileContent", "append", "devbricksx_release"})
public final class FileUtils {
    private static final String NO_MEDIA_TAG_FILE = ".nomedia";
    public static final FileUtils INSTANCE;

    public final boolean checkOrCreateNoMediaDirectory(@NotNull String directory) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        return this.checkOrCreateNoMediaDirectory(new File(directory));
    }

    public final boolean checkOrCreateNoMediaDirectory(@NotNull File directory) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        return this.checkOrCreateDirectory(directory, true);
    }

    public final boolean checkOrCreateDirectory(@NotNull String directory) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        return this.checkOrCreateDirectory(new File(directory));
    }

    public final boolean checkOrCreateDirectory(@NotNull File directory) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        return this.checkOrCreateDirectory(directory, false);
    }

    public final boolean checkOrCreateDirectory(@NotNull File directory, boolean nomedia) {
        boolean success;
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        if (directory.exists()) {
            if (directory.isDirectory()) {
                return true;
            }
            Logger.INSTANCE.warn("%s is NOT a directory", directory);
        }
        if (!(success = directory.mkdirs())) {
            return false;
        }
        return !nomedia ? success : this.checkOrCreateNoMediaTagInDirectory(directory);
    }

    public final boolean checkOrCreateNoMediaTagInDirectory(@NotNull String directory) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        return this.checkOrCreateNoMediaTagInDirectory(new File(directory));
    }

    public final boolean checkOrCreateNoMediaTagInDirectory(@NotNull File dir) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        File tagFile = new File(dir, NO_MEDIA_TAG_FILE);
        if (tagFile.exists()) {
            return true;
        }
        try {
            bl = tagFile.createNewFile();
        }
        catch (IOException e) {
            Logger.INSTANCE.warn("could not create tag[%s] in dir[%s]: %s", NO_MEDIA_TAG_FILE, dir.getAbsoluteFile(), e.toString());
            bl = false;
        }
        return bl;
    }

    public final boolean isFileExisted(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        return new File(filename).exists();
    }

    @Nullable
    public final String detectFileEncoding(@NotNull String file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.detectFileEncoding(new File(file));
    }

    @Nullable
    public final String detectFileEncoding(@NotNull Context context, int rawId) {
        InputStream inputStream;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (rawId <= 0) {
            Logger.INSTANCE.warn("invalid resource id: " + rawId, new Object[0]);
            return null;
        }
        Resources resources = context.getResources();
        if (resources == null) {
            return null;
        }
        Resources res = resources;
        try {
            inputStream = res.openRawResource(rawId);
        }
        catch (Resources.NotFoundException e) {
            Logger.INSTANCE.warn("failed to find raw file [" + rawId + "]: " + (Object)((Object)e), new Object[0]);
            return null;
        }
        InputStream inputStream2 = inputStream;
        Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"try {\n            res.op\u2026    return null\n        }");
        InputStream fStream = inputStream2;
        return this.detectFileEncoding(fStream);
    }

    @Nullable
    public final String detectFileEncoding(@NotNull Context context, @NotNull String file) {
        InputStream inputStream;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        AssetManager assetManager = context.getAssets();
        if (assetManager == null) {
            return null;
        }
        AssetManager assetManager2 = assetManager;
        try {
            InputStream inputStream2 = assetManager2.open(file);
            if (inputStream2 == null) {
                return null;
            }
            inputStream = inputStream2;
        }
        catch (IOException e) {
            Logger.INSTANCE.warn("failed to find asset file [" + file + "]: " + e, new Object[0]);
            return null;
        }
        InputStream inputStream3 = inputStream;
        Intrinsics.checkNotNullExpressionValue((Object)inputStream3, (String)"try {\n            assetM\u2026    return null\n        }");
        InputStream fStream = inputStream3;
        return this.detectFileEncoding(fStream);
    }

    @Nullable
    public final String detectFileEncoding(@NotNull File file) {
        FileInputStream fileInputStream;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            Logger.INSTANCE.warn("get encoding failure: " + e, new Object[0]);
            return null;
        }
        FileInputStream fs = fileInputStream;
        return this.detectFileEncoding(fs);
    }

    @Nullable
    public final String detectFileEncoding(@NotNull InputStream iStream) {
        Intrinsics.checkNotNullParameter((Object)iStream, (String)"iStream");
        byte[] buf = new byte[4096];
        UniversalDetector detector = new UniversalDetector(null);
        int nRead = 0;
        try {
            while (true) {
                int n = iStream.read(buf);
                boolean bl = false;
                boolean bl2 = false;
                int it = n;
                boolean bl3 = false;
                nRead = it;
                if (n > 0 && !detector.isDone()) {
                    detector.handleData(buf, 0, nRead);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            Logger.INSTANCE.warn("get encoding failure: %s", e.toString());
        }
        detector.dataEnd();
        String string = detector.getDetectedCharset();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"detector.detectedCharset");
        String encoding = string;
        detector.reset();
        try {
            iStream.close();
        }
        catch (IOException e) {
            Logger.INSTANCE.warn("close stream failure: %s", e.toString());
        }
        return encoding;
    }

    @Nullable
    public final String fileToString(@NotNull String file) {
        FileInputStream fileInputStream;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            Logger.INSTANCE.warn("get encoding failure: " + e, new Object[0]);
            return null;
        }
        FileInputStream fs = fileInputStream;
        return this.fileToString(fs, this.detectFileEncoding(file));
    }

    @Nullable
    public final String fileToString(@NotNull InputStream fStream, @Nullable String encoding) {
        InputStreamReader inputStreamReader;
        Intrinsics.checkNotNullParameter((Object)fStream, (String)"fStream");
        InputStreamReader reader = null;
        String string = encoding;
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            inputStreamReader = new InputStreamReader(fStream, it);
        } else {
            inputStreamReader = new InputStreamReader(fStream);
        }
        reader = inputStreamReader;
        StringWriter writer = new StringWriter();
        char[] buffer = new char[2048];
        int n = 0;
        while (true) {
            int n2 = reader.read(buffer);
            boolean bl = false;
            boolean bl4 = false;
            int it = n2;
            boolean bl5 = false;
            n = it;
            if (n2 == -1) break;
            writer.write(buffer, 0, n);
        }
        writer.flush();
        fStream.close();
        return writer.toString();
    }

    @Nullable
    public final String assetToString(@NotNull Context context, @NotNull String file) {
        InputStream inputStream;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        AssetManager assetManager = context.getAssets();
        if (assetManager == null) {
            return null;
        }
        AssetManager assetManager2 = assetManager;
        try {
            InputStream inputStream2 = assetManager2.open(file);
            if (inputStream2 == null) {
                return null;
            }
            inputStream = inputStream2;
        }
        catch (IOException e) {
            Logger.INSTANCE.warn("failed to find asset file [" + file + "]: " + e, new Object[0]);
            return null;
        }
        InputStream inputStream3 = inputStream;
        Intrinsics.checkNotNullExpressionValue((Object)inputStream3, (String)"try {\n            assetM\u2026    return null\n        }");
        InputStream fStream = inputStream3;
        return this.fileToString(fStream, this.detectFileEncoding(context, file));
    }

    @Nullable
    public final String rawToString(@NotNull Context context, int rawId) {
        InputStream inputStream;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (rawId <= 0) {
            Logger.INSTANCE.warn("invalid resource id: " + rawId, new Object[0]);
            return null;
        }
        Resources resources = context.getResources();
        if (resources == null) {
            return null;
        }
        Resources res = resources;
        try {
            inputStream = res.openRawResource(rawId);
        }
        catch (Resources.NotFoundException e) {
            Logger.INSTANCE.warn("failed to find raw file [" + rawId + "]: " + (Object)((Object)e), new Object[0]);
            return null;
        }
        InputStream inputStream2 = inputStream;
        Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"try {\n            res.op\u2026    return null\n        }");
        InputStream fStream = inputStream2;
        return this.fileToString(fStream, this.detectFileEncoding(context, rawId));
    }

    @NotNull
    public final String getBaseName(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        String string = new File(filename).getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"File(filename).name");
        return string;
    }

    @NotNull
    public final String getFileName(@NotNull String filename) {
        int i;
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        String baseName = this.getBaseName(filename);
        CharSequence charSequence = baseName;
        boolean bl = false;
        if (charSequence.length() > 0 && (i = StringsKt.lastIndexOf$default((CharSequence)baseName, (char)'.', (int)0, (boolean)false, (int)6, null)) > -1 && i < baseName.length() - 1) {
            String string = baseName;
            int n = 0;
            boolean bl2 = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n, i);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            return string3;
        }
        return baseName;
    }

    @NotNull
    public final String getFileExtension(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        return this.getFileExtension(filename, "");
    }

    @NotNull
    public final String getFileExtension(@NotNull String filename, @NotNull String defExt) {
        int i;
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Intrinsics.checkNotNullParameter((Object)defExt, (String)"defExt");
        CharSequence charSequence = filename;
        boolean bl = false;
        if (charSequence.length() > 0 && (i = StringsKt.lastIndexOf$default((CharSequence)filename, (char)'.', (int)0, (boolean)false, (int)6, null)) > -1 && i < filename.length() - 1) {
            String string = filename;
            int n = i + 1;
            boolean bl2 = false;
            String string2 = string.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
            return string2;
        }
        return defExt;
    }

    public final void stringToFile(@NotNull String file, @Nullable String fileContent) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.stringToFile(file, fileContent, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stringToFile(@NotNull String file, @Nullable String fileContent, boolean append) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (TextUtils.isEmpty((CharSequence)fileContent)) {
            return;
        }
        StringReader reader = new StringReader(fileContent);
        FileWriter outputStream = new FileWriter(file, append);
        try {
            char[] buffer = new char[2048];
            int n = 0;
            while (true) {
                int n2 = reader.read(buffer);
                boolean bl = false;
                boolean bl2 = false;
                int it = n2;
                boolean bl3 = false;
                n = it;
                if (n2 == -1) break;
                outputStream.write(buffer, 0, n);
            }
            outputStream.flush();
            outputStream.close();
            reader.close();
        }
        catch (IOException e) {
            Logger.INSTANCE.error("write string [" + fileContent + "] to file [" + file + "] failed: " + e, new Object[0]);
        }
        finally {
            outputStream.close();
            reader.close();
        }
    }

    public final boolean saveToFile(@Nullable byte[] bytes, @NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        return TextUtils.isEmpty((CharSequence)filename) ? false : this.saveToFile(bytes, new File(filename));
    }

    public final boolean saveToFile(@Nullable byte[] bytes, @NotNull File file) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (bytes == null) {
            return false;
        }
        try {
            FileOutputStream out = new FileOutputStream(file);
            out.write(bytes);
            out.flush();
            out.close();
            bl = true;
        }
        catch (IOException e) {
            Logger.INSTANCE.debug("save bytes to file [" + file + "] failure: " + e, new Object[0]);
            bl = false;
        }
        return bl;
    }

    @NotNull
    public final String md5Dir(@NotNull String dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        return this.md5Dir(dir, false);
    }

    @NotNull
    public final String md5Dir(@NotNull File dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        return this.md5Dir(dir, false);
    }

    @NotNull
    public final String md5Dir(@NotNull String dir, boolean hiddenFies) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        return this.md5Dir(dir, hiddenFies, false);
    }

    @NotNull
    public final String md5Dir(@NotNull File dir, boolean hiddenFiles) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        return this.md5Dir(dir, hiddenFiles, false);
    }

    @NotNull
    public final String md5Dir(@NotNull String dir, boolean hiddenFiles, boolean verbose) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        return this.md5Dir(new File(dir), hiddenFiles, verbose);
    }

    @NotNull
    public final String md5Dir(@NotNull File dir, boolean hiddenFiles, boolean verbose) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        String md5 = "";
        if (!dir.exists() || !dir.isDirectory()) {
            return md5;
        }
        Object[] objectArray = dir.listFiles();
        if (objectArray == null) {
            return md5;
        }
        Object[] files = objectArray;
        Arrays.sort(files);
        String childMd5 = null;
        for (Object file : files) {
            if (!hiddenFiles) {
                Object object = file;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"file");
                if (((File)object).isHidden()) continue;
            }
            Object object = file;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"file");
            String string = childMd5 = ((File)object).isDirectory() ? this.md5Dir((File)file, hiddenFiles) : this.md5File((File)file);
            if (verbose) {
                Logger.INSTANCE.debug("[%s] of (%s, %s)", childMd5, ((File)file).isDirectory() ? "D" : "F", ((File)file).getName());
            }
            md5 = md5 + childMd5;
        }
        return this.md5HashOfString(md5);
    }

    @NotNull
    public final String md5File(@NotNull String file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.md5File(new File(file));
    }

    @NotNull
    public final String md5File(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String md5 = "";
        if (!file.exists() || !file.isFile()) {
            return md5;
        }
        try {
            InputStream input = new FileInputStream(file);
            byte[] buffer = new byte[1024];
            MessageDigest md5Hash = MessageDigest.getInstance("MD5");
            int numRead = 0;
            while (numRead != -1) {
                numRead = input.read(buffer);
                if (numRead <= 0) continue;
                md5Hash.update(buffer, 0, numRead);
            }
            input.close();
            byte[] md5Bytes = md5Hash.digest();
            BigInteger bigInt = new BigInteger(1, md5Bytes);
            String output = bigInt.toString(16);
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "%32s";
            Object[] objectArray = new Object[]{output};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
            md5 = StringsKt.replace$default((String)string2, (char)' ', (char)'0', (boolean)false, (int)4, null);
        }
        catch (Exception e) {
            Logger.INSTANCE.error("md5 calculation failed on file[%s]: %s", file, e.toString());
        }
        return md5;
    }

    private final String md5HashOfString(String str) {
        if (TextUtils.isEmpty((CharSequence)str)) {
            return str;
        }
        MessageDigest md5Hash = null;
        String md5 = "";
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            Intrinsics.checkNotNullExpressionValue((Object)messageDigest, (String)"MessageDigest.getInstance(\"MD5\")");
            md5Hash = messageDigest;
            md5Hash.reset();
            String string = str;
            Charset charset = Charset.forName("UTF8");
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"Charset.forName(\"UTF8\")");
            Charset charset2 = charset;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string2.getBytes(charset2);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            md5Hash.update(byArray);
            byte[] md5Bytes = md5Hash.digest();
            BigInteger bigInt = new BigInteger(1, md5Bytes);
            String output = bigInt.toString(16);
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string3 = "%32s";
            Object[] objectArray = new Object[]{output};
            boolean bl2 = false;
            String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.String.format(format, *args)");
            md5 = StringsKt.replace$default((String)string4, (char)' ', (char)'0', (boolean)false, (int)4, null);
        }
        catch (Exception e) {
            Logger.INSTANCE.error("md5 hash failed on string[%s]: %s", str, e.toString());
        }
        return md5;
    }

    private FileUtils() {
    }

    static {
        FileUtils fileUtils;
        INSTANCE = fileUtils = new FileUtils();
    }
}

