/*
 * Decompiled with CFR 0.152.
 */
package com.dailystudio.devbricksx.utils;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u000f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0010\u001a\u00020\u0004J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0004J\u000e\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004J\u000e\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004J\u000e\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004J\u000e\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004J\u000e\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0004J\u000e\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0004J\u000e\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0004J\u000e\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0004J\u000e\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004J\u000e\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004J\u000e\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004J\u000e\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004J\u000e\u0010 \u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004J\u0006\u0010!\u001a\u00020\u0004J\u000e\u0010\"\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0004J\u000e\u0010#\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0004J\u000e\u0010$\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0004J\u000e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0004J\u000e\u0010(\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0004J\u000e\u0010)\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0004J\u000e\u0010*\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0004J\u001e\u0010+\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00042\u0006\u0010,\u001a\u00020\u00042\u0006\u0010-\u001a\u00020\u0004J\u0016\u0010.\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010/\u001a\u00020\u0004J\u0010\u00100\u001a\u0004\u0018\u00010\u00062\u0006\u0010'\u001a\u00020\u0004J \u00100\u001a\u0004\u0018\u00010\u00062\u0006\u0010'\u001a\u00020\u00042\u0006\u00101\u001a\u00020&2\u0006\u00102\u001a\u00020&J\u0010\u00103\u001a\u0004\u0018\u00010\u00062\u0006\u0010'\u001a\u00020\u0004J\u0010\u00104\u001a\u0004\u0018\u00010\u00062\u0006\u0010'\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/dailystudio/devbricksx/utils/CalendarUtils;", "", "()V", "DAY_IN_MILLIS", "", "FORMAT_TEPML_DATETIME", "", "FORMAT_TEPML_TIME", "HOUR_IN_MILLIS", "MINUTE_IN_MILLIS", "SECOND_IN_MILLIS", "WEEK_IN_MILLIS", "YEAR_IN_MILLIS", "sCalendar", "Ljava/util/Calendar;", "durationToReadableString", "duration", "getDay", "", "mills", "getEndOfDay", "getEndOfMonth", "getEndOfWeek", "getEndOfYear", "getHour", "getMinute", "getMonth", "getSecond", "getStartOfDay", "getStartOfMonth", "getStartOfWeek", "getStartOfYear", "getTimeOfDay", "getTimezoneOffset", "getWeek", "getWeekDay", "getYear", "isCurrentDay", "", "time", "isCurrentMonth", "isCurrentWeek", "isCurrentYear", "isInRange", "start", "end", "setTimeOfDate", "targetDate", "timeToReadableString", "hasDate", "hasTime", "timeToReadableStringWithoutDate", "timeToReadableStringWithoutTime", "devbricksx_release"})
public final class CalendarUtils {
    @NotNull
    public static final String FORMAT_TEPML_TIME = "HH:mm:ss";
    @NotNull
    public static final String FORMAT_TEPML_DATETIME = "yyyy-MM-dd HH:mm:ss:SSS";
    public static final long SECOND_IN_MILLIS = 1000L;
    public static final long MINUTE_IN_MILLIS = 60000L;
    public static final long HOUR_IN_MILLIS = 3600000L;
    public static final long DAY_IN_MILLIS = 86400000L;
    public static final long WEEK_IN_MILLIS = 604800000L;
    public static final long YEAR_IN_MILLIS = 31449600000L;
    private static Calendar sCalendar;
    public static final CalendarUtils INSTANCE;

    public final synchronized long getTimeOfDay(long mills) {
        sCalendar.setTimeInMillis(mills);
        sCalendar.set(1, 2013);
        sCalendar.set(2, 14);
        sCalendar.set(5, 8);
        return sCalendar.getTimeInMillis();
    }

    public final synchronized long setTimeOfDate(long mills, long targetDate) {
        sCalendar.setTimeInMillis(targetDate);
        int year = sCalendar.get(1);
        int month = sCalendar.get(2);
        int day = sCalendar.get(5);
        sCalendar.setTimeInMillis(mills);
        sCalendar.set(1, year);
        sCalendar.set(2, month);
        sCalendar.set(5, day);
        return sCalendar.getTimeInMillis();
    }

    public final synchronized long getStartOfDay(long mills) {
        sCalendar.setTimeInMillis(mills);
        sCalendar.set(11, 0);
        sCalendar.set(12, 0);
        sCalendar.set(13, 0);
        sCalendar.set(14, 0);
        return sCalendar.getTimeInMillis();
    }

    public final synchronized long getEndOfDay(long mills) {
        sCalendar.setTimeInMillis(mills);
        sCalendar.set(11, 23);
        sCalendar.set(12, 59);
        sCalendar.set(13, 59);
        sCalendar.set(14, 999);
        return sCalendar.getTimeInMillis();
    }

    public final synchronized long getStartOfWeek(long mills) {
        sCalendar.setFirstDayOfWeek(2);
        sCalendar.setTimeInMillis(mills);
        sCalendar.set(7, 2);
        sCalendar.set(11, 0);
        sCalendar.set(12, 0);
        sCalendar.set(13, 0);
        sCalendar.set(14, 0);
        return sCalendar.getTimeInMillis();
    }

    public final synchronized long getEndOfWeek(long mills) {
        long startMillis = this.getStartOfWeek(mills);
        sCalendar.setTimeInMillis(startMillis);
        sCalendar.add(7, 6);
        sCalendar.set(11, 23);
        sCalendar.set(12, 59);
        sCalendar.set(13, 59);
        sCalendar.set(14, 999);
        return sCalendar.getTimeInMillis();
    }

    public final synchronized long getStartOfMonth(long mills) {
        sCalendar.setTimeInMillis(mills);
        sCalendar.set(5, 1);
        sCalendar.set(11, 0);
        sCalendar.set(12, 0);
        sCalendar.set(13, 0);
        sCalendar.set(14, 0);
        return sCalendar.getTimeInMillis();
    }

    public final synchronized long getEndOfMonth(long mills) {
        sCalendar.setTimeInMillis(mills);
        sCalendar.set(5, 1);
        sCalendar.add(2, 1);
        sCalendar.add(5, -1);
        sCalendar.set(11, 23);
        sCalendar.set(12, 59);
        sCalendar.set(13, 59);
        sCalendar.set(14, 999);
        return sCalendar.getTimeInMillis();
    }

    public final synchronized long getStartOfYear(long mills) {
        sCalendar.setTimeInMillis(mills);
        sCalendar.set(2, 0);
        sCalendar.set(5, 1);
        sCalendar.set(11, 0);
        sCalendar.set(12, 0);
        sCalendar.set(13, 0);
        sCalendar.set(14, 0);
        return sCalendar.getTimeInMillis();
    }

    public final synchronized long getEndOfYear(long mills) {
        sCalendar.setTimeInMillis(mills);
        sCalendar.set(2, 11);
        sCalendar.set(5, 31);
        sCalendar.set(11, 23);
        sCalendar.set(12, 59);
        sCalendar.set(13, 59);
        sCalendar.set(14, 999);
        return sCalendar.getTimeInMillis();
    }

    public final synchronized int getYear(long mills) {
        sCalendar.setTimeInMillis(mills);
        return sCalendar.get(1);
    }

    public final synchronized int getMonth(long mills) {
        sCalendar.setTimeInMillis(mills);
        return sCalendar.get(2);
    }

    public final synchronized int getWeek(long mills) {
        sCalendar.setFirstDayOfWeek(2);
        sCalendar.setMinimalDaysInFirstWeek(4);
        sCalendar.setTimeInMillis(mills);
        return sCalendar.get(3);
    }

    public final synchronized int getDay(long mills) {
        sCalendar.setTimeInMillis(mills);
        return sCalendar.get(5);
    }

    public final synchronized int getWeekDay(long mills) {
        sCalendar.setTimeInMillis(mills);
        int day = sCalendar.get(7);
        day = day == 1 ? 7 : day - 1;
        return day;
    }

    public final synchronized int getHour(long mills) {
        sCalendar.setTimeInMillis(mills);
        return sCalendar.get(11);
    }

    public final synchronized int getMinute(long mills) {
        sCalendar.setTimeInMillis(mills);
        return sCalendar.get(12);
    }

    public final synchronized int getSecond(long mills) {
        sCalendar.setTimeInMillis(mills);
        return sCalendar.get(13);
    }

    public final boolean isCurrentDay(long time) {
        long now = System.currentTimeMillis();
        return this.getStartOfDay(time) == this.getStartOfDay(now);
    }

    public final boolean isCurrentWeek(long time) {
        long now = System.currentTimeMillis();
        return this.getStartOfWeek(time) == this.getStartOfWeek(now);
    }

    public final boolean isCurrentMonth(long time) {
        long now = System.currentTimeMillis();
        return this.getStartOfMonth(time) == this.getStartOfMonth(now);
    }

    public final boolean isCurrentYear(long time) {
        long now = System.currentTimeMillis();
        return this.getStartOfYear(time) == this.getStartOfYear(now);
    }

    public final boolean isInRange(long time, long start2, long end) {
        long l = time;
        return start2 <= l && end >= l;
    }

    public final long getTimezoneOffset() {
        TimeZone tz = TimeZone.getDefault();
        Date now = new Date();
        int offsetFromUtc = tz.getOffset(now.getTime());
        return offsetFromUtc;
    }

    @Nullable
    public final String durationToReadableString(long duration) {
        String hourLabel = "h";
        String minLabel = "'";
        String secLabel = "\"";
        long sec = duration / 1000L;
        long min = duration / 60000L;
        long hour = duration / 3600000L;
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "%d%s %02d%s %02d%s %03d";
        Object[] objectArray = new Object[]{hour, hourLabel, min % (long)60, minLabel, sec % (long)60, secLabel, duration % (long)1000};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        return string2;
    }

    @Nullable
    public final String timeToReadableString(long time, boolean hasDate, boolean hasTime) {
        String format;
        StringBuilder builder2 = new StringBuilder();
        if (hasDate) {
            builder2.append("yyyy/MM/dd ");
        }
        if (hasTime) {
            builder2.append("hh:mm:ss:SSS aa");
        }
        String string = builder2.toString();
        if (string == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString() ?: return null");
        String $this$trim$iv = format = string;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        format = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
        SimpleDateFormat formater = new SimpleDateFormat(format);
        return formater.format(time);
    }

    @Nullable
    public final String timeToReadableString(long time) {
        return this.timeToReadableString(time, true, true);
    }

    @Nullable
    public final String timeToReadableStringWithoutTime(long time) {
        return this.timeToReadableString(time, true, false);
    }

    @Nullable
    public final String timeToReadableStringWithoutDate(long time) {
        return this.timeToReadableString(time, false, true);
    }

    private CalendarUtils() {
    }

    static {
        CalendarUtils calendarUtils;
        INSTANCE = calendarUtils = new CalendarUtils();
        Calendar calendar = Calendar.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)calendar, (String)"Calendar.getInstance()");
        sCalendar = calendar;
        sCalendar.setFirstDayOfWeek(2);
    }
}

