/*
 * Decompiled with CFR 0.152.
 */
package com.dailystudio.devbricksx.ui;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.PorterDuff;
import android.util.AttributeSet;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import com.dailystudio.devbricksx.development.Logger;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u00012\u00020\u0002B%\b\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB)\b\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H&J\b\u0010\u0016\u001a\u00020\u0013H\u0002J\u000e\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\bJ\b\u0010\u0019\u001a\u00020\u0013H\u0002J\b\u0010\u001a\u001a\u00020\u0013H\u0002J(\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\bH\u0016J\u0010\u0010!\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\"\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/dailystudio/devbricksx/ui/AbsSurfaceView;", "Landroid/view/SurfaceView;", "Landroid/view/SurfaceHolder$Callback;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "defStyleRes", "(Landroid/content/Context;Landroid/util/AttributeSet;II)V", "drawingActive", "", "drawingService", "Ljava/util/concurrent/ExecutorService;", "framesPerSecond", "surfaceReady", "drawingCanvas", "", "canvas", "Landroid/graphics/Canvas;", "renderFrames", "setFramesPerSecond", "fps", "startDrawThread", "stopDrawThread", "surfaceChanged", "holder", "Landroid/view/SurfaceHolder;", "format", "width", "height", "surfaceCreated", "surfaceDestroyed", "devbricksx_release"})
public abstract class AbsSurfaceView
extends SurfaceView
implements SurfaceHolder.Callback {
    private int framesPerSecond;
    private ExecutorService drawingService;
    private boolean surfaceReady;
    private boolean drawingActive;
    private HashMap _$_findViewCache;

    public void surfaceCreated(@NotNull SurfaceHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        this.stopDrawThread();
        this.surfaceReady = true;
        this.startDrawThread();
    }

    public void surfaceDestroyed(@NotNull SurfaceHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        this.stopDrawThread();
        Surface surface = holder.getSurface();
        if (surface != null) {
            surface.release();
        }
        this.surfaceReady = false;
    }

    public void surfaceChanged(@NotNull SurfaceHolder holder, int format, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
    }

    /*
     * WARNING - void declaration
     */
    private final synchronized void startDrawThread() {
        if (this.surfaceReady) {
            void $this$apply;
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            boolean bl = false;
            boolean bl2 = false;
            ExecutorService executorService2 = executorService;
            AbsSurfaceView absSurfaceView = this;
            boolean bl3 = false;
            this.drawingActive = true;
            $this$apply.execute(new Runnable(this){
                final /* synthetic */ AbsSurfaceView this$0;
                {
                    this.this$0 = absSurfaceView;
                }

                public final void run() {
                    AbsSurfaceView.access$renderFrames(this.this$0);
                }
            });
            Unit unit = Unit.INSTANCE;
            absSurfaceView.drawingService = executorService;
        }
    }

    private final synchronized void stopDrawThread() {
        if (this.drawingService == null) {
            Logger.INSTANCE.debug("drawing service is null, needn't to stop", new Object[0]);
            return;
        }
        this.drawingActive = false;
        ExecutorService executorService = this.drawingService;
        if (executorService != null) {
            ExecutorService executorService2 = executorService;
            boolean bl = false;
            boolean bl2 = false;
            ExecutorService it = executorService2;
            boolean bl3 = false;
            try {
                Logger.INSTANCE.debug("shutting down drawing service ...", new Object[0]);
                it.shutdown();
            }
            catch (Exception e) {
                Logger.INSTANCE.warn("Could not shut down drawing service", new Object[0]);
            }
        }
        this.drawingService = null;
    }

    public final void setFramesPerSecond(int fps) {
        this.framesPerSecond = fps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void renderFrames() {
        Canvas canvas = null;
        while (true) {
            boolean bl;
            Unit unit;
            Boolean bl2 = this.drawingActive;
            boolean bl3 = false;
            boolean bl4 = false;
            synchronized (bl2) {
                boolean bl5 = false;
                if (!this.drawingActive) {
                    return;
                }
                unit = Unit.INSTANCE;
            }
            long startTime = System.currentTimeMillis();
            try {
                canvas = this.getHolder().lockCanvas(null);
                if (canvas == null) {
                    Logger.INSTANCE.debug("surface is not ready, skip and try it later", new Object[0]);
                }
                SurfaceHolder surfaceHolder = this.getHolder();
                Intrinsics.checkNotNullExpressionValue((Object)surfaceHolder, (String)"holder");
                unit = surfaceHolder;
                bl = false;
                boolean bl6 = false;
                synchronized (unit) {
                    Unit unit2;
                    boolean bl7 = false;
                    if (canvas != null) {
                        Canvas canvas2;
                        boolean bl8 = false;
                        boolean bl9 = false;
                        Canvas it = canvas2;
                        boolean bl10 = false;
                        canvas.drawColor(0, PorterDuff.Mode.CLEAR);
                        this.drawingCanvas(it);
                        unit2 = Unit.INSTANCE;
                    } else {
                        unit2 = null;
                    }
                    Unit unit3 = unit2;
                }
            }
            finally {
                Canvas canvas3 = canvas;
                if (canvas3 != null) {
                    unit = canvas3;
                    bl = false;
                    boolean bl11 = false;
                    Unit it = unit;
                    boolean bl12 = false;
                    this.getHolder().unlockCanvasAndPost(canvas);
                }
            }
            int frameTime = 1000 / this.framesPerSecond;
            long endTime = System.currentTimeMillis();
            long drawTime = endTime - startTime;
            long sleepTime = (long)frameTime - drawTime;
            if (sleepTime <= 0L) continue;
            try {
                Thread.sleep((long)frameTime - drawTime);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public abstract void drawingCanvas(@NotNull Canvas var1);

    @JvmOverloads
    public AbsSurfaceView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.framesPerSecond = 60;
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
        this.getHolder().setFormat(1);
        this.setZOrderOnTop(true);
    }

    public /* synthetic */ AbsSurfaceView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public AbsSurfaceView(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public AbsSurfaceView(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    @TargetApi(value=21)
    public AbsSurfaceView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr, defStyleRes);
        this.framesPerSecond = 60;
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
        this.getHolder().setFormat(1);
        this.setZOrderOnTop(true);
    }

    public static final /* synthetic */ void access$renderFrames(AbsSurfaceView $this) {
        $this.renderFrames();
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }
}

