/*
 * Decompiled with CFR 0.152.
 */
package com.dailystudio.devbricksx.settings;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.SeekBar;
import android.widget.TextView;
import com.dailystudio.devbricksx.R;
import com.dailystudio.devbricksx.development.Logger;
import com.dailystudio.devbricksx.settings.AbsSetting;
import com.dailystudio.devbricksx.settings.AbsSettingHolder;
import com.dailystudio.devbricksx.settings.SeekBarSetting;
import java.text.NumberFormat;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\f\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0014J\"\u0010\u000f\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/dailystudio/devbricksx/settings/SeekBarSettingHolder;", "Lcom/dailystudio/devbricksx/settings/AbsSettingHolder;", "()V", "bindSetting", "", "settingView", "Landroid/view/View;", "setting", "Lcom/dailystudio/devbricksx/settings/AbsSetting;", "invalidate", "context", "Landroid/content/Context;", "onCreateView", "layoutInflater", "Landroid/view/LayoutInflater;", "syncProgressWithSetting", "seekBar", "Landroid/widget/SeekBar;", "seekBarSetting", "Lcom/dailystudio/devbricksx/settings/SeekBarSetting;", "devbricksx_release"})
public class SeekBarSettingHolder
extends AbsSettingHolder {
    @Override
    @NotNull
    protected View onCreateView(@NotNull Context context, @NotNull LayoutInflater layoutInflater, @NotNull AbsSetting setting) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)layoutInflater, (String)"layoutInflater");
        Intrinsics.checkNotNullParameter((Object)setting, (String)"setting");
        View view = layoutInflater.inflate(R.layout.layout_setting_seek_bar, null);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"layoutInflater.inflate(\n\u2026t_setting_seek_bar, null)");
        return view;
    }

    @Override
    public void invalidate(@NotNull Context context, @NotNull AbsSetting setting) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)setting, (String)"setting");
        View view = this.getView();
        if (!(setting instanceof SeekBarSetting)) {
            return;
        }
        SeekBar seekBarView = (SeekBar)view.findViewById(R.id.setting_seek_bar);
        this.syncProgressWithSetting(context, seekBarView, (SeekBarSetting)setting);
    }

    private final void syncProgressWithSetting(Context context, SeekBar seekBar, SeekBarSetting seekBarSetting) {
        block1: {
            float progress = seekBarSetting.getProgress(context);
            float step = seekBarSetting.getStep(context);
            float min = seekBarSetting.getMinValue(context);
            float max = seekBarSetting.getMaxValue(context);
            Logger.INSTANCE.debug("prg = %f, [min: %f, max: %f, step: %f", Float.valueOf(progress), Float.valueOf(min), Float.valueOf(max), Float.valueOf(step));
            SeekBar seekBar2 = seekBar;
            if (seekBar2 != null) {
                seekBar2.setProgress(MathKt.roundToInt((float)((progress - min) / step)));
            }
            SeekBar seekBar3 = seekBar;
            if (seekBar3 == null) break block1;
            seekBar3.setMax(MathKt.roundToInt((float)((max - min) / step)));
        }
    }

    @Override
    protected void bindSetting(@NotNull View settingView, @NotNull AbsSetting setting) {
        SeekBar seekBarView;
        Intrinsics.checkNotNullParameter((Object)settingView, (String)"settingView");
        Intrinsics.checkNotNullParameter((Object)setting, (String)"setting");
        super.bindSetting(settingView, setting);
        if (!(setting instanceof SeekBarSetting)) {
            return;
        }
        View view = settingView.findViewById(R.id.setting_seek_value);
        if (view == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.widget.TextView");
        }
        TextView seekValView = (TextView)view;
        if (seekValView != null) {
            float prg = ((SeekBarSetting)setting).getProgress(setting.getContext());
            String prgStr = NumberFormat.getInstance().format(prg);
            seekValView.setText((CharSequence)prgStr);
        }
        if ((seekBarView = (SeekBar)settingView.findViewById(R.id.setting_seek_bar)) != null) {
            Context context = setting.getContext();
            this.syncProgressWithSetting(context, seekBarView, (SeekBarSetting)setting);
            seekBarView.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(setting, context, seekValView){
                final /* synthetic */ AbsSetting $setting;
                final /* synthetic */ Context $context;
                final /* synthetic */ TextView $seekValView;

                public void onProgressChanged(@NotNull SeekBar seekBar, int progress, boolean fromUser) {
                    Intrinsics.checkNotNullParameter((Object)seekBar, (String)"seekBar");
                    float prg = ((SeekBarSetting)this.$setting).getMinValue(this.$context) + (float)progress * ((SeekBarSetting)this.$setting).getStep(this.$context);
                    if (this.$seekValView != null) {
                        this.$seekValView.setText((CharSequence)NumberFormat.getInstance().format(prg));
                    }
                    ((SeekBarSetting)this.$setting).setProgress(this.$context, prg);
                    this.$setting.notifySettingChange();
                }

                public void onStartTrackingTouch(@NotNull SeekBar seekBar) {
                    Intrinsics.checkNotNullParameter((Object)seekBar, (String)"seekBar");
                }

                public void onStopTrackingTouch(@NotNull SeekBar seekBar) {
                    Intrinsics.checkNotNullParameter((Object)seekBar, (String)"seekBar");
                }
                {
                    this.$setting = $captured_local_variable$0;
                    this.$context = $captured_local_variable$1;
                    this.$seekValView = $captured_local_variable$2;
                }
            });
        }
    }
}

