/*
 * Decompiled with CFR 0.152.
 */
package com.dailystudio.devbricksx.settings;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.dailystudio.devbricksx.R;
import com.dailystudio.devbricksx.development.Logger;
import com.dailystudio.devbricksx.settings.AbsSetting;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0014J\u0016\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\r\u001a\u00020\u0004J\u0018\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tH&J \u0010\u000f\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\tH$R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/dailystudio/devbricksx/settings/AbsSettingHolder;", "", "()V", "mView", "Landroid/view/View;", "bindSetting", "", "settingView", "setting", "Lcom/dailystudio/devbricksx/settings/AbsSetting;", "createView", "context", "Landroid/content/Context;", "getView", "invalidate", "onCreateView", "layoutInflater", "Landroid/view/LayoutInflater;", "devbricksx_release"})
public abstract class AbsSettingHolder {
    private View mView;

    @NotNull
    public final View createView(@NotNull Context context, @NotNull AbsSetting setting) {
        LayoutInflater layoutInflater;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)setting, (String)"setting");
        LayoutInflater layoutInflater2 = layoutInflater = LayoutInflater.from((Context)context);
        Intrinsics.checkNotNullExpressionValue((Object)layoutInflater2, (String)"layoutInflater");
        this.mView = this.onCreateView(context, layoutInflater2, setting);
        StringBuilder stringBuilder = new StringBuilder().append("view created: ");
        View view = this.mView;
        if (view == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mView");
        }
        Logger.INSTANCE.debug(stringBuilder.append(view).toString(), new Object[0]);
        View view2 = this.mView;
        if (view2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mView");
        }
        this.bindSetting(view2, setting);
        View view3 = this.mView;
        if (view3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mView");
        }
        view3.setVisibility(setting.getEnabled() ? 0 : 8);
        View view4 = this.mView;
        if (view4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mView");
        }
        return view4;
    }

    @NotNull
    public final View getView() {
        View view = this.mView;
        if (view == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mView");
        }
        return view;
    }

    protected void bindSetting(@NotNull View settingView, @NotNull AbsSetting setting) {
        block1: {
            TextView labelView;
            ImageView iconView;
            Intrinsics.checkNotNullParameter((Object)settingView, (String)"settingView");
            Intrinsics.checkNotNullParameter((Object)setting, (String)"setting");
            Logger.INSTANCE.debug("binding setting [" + setting + "] to view [" + settingView + ']', new Object[0]);
            ImageView imageView = iconView = (ImageView)settingView.findViewById(R.id.setting_icon);
            if (imageView != null) {
                imageView.setImageDrawable(setting.getIcon());
            }
            TextView textView = labelView = (TextView)settingView.findViewById(R.id.setting_label);
            if (textView == null) break block1;
            textView.setText(setting.getLabel());
        }
    }

    public abstract void invalidate(@NotNull Context var1, @NotNull AbsSetting var2);

    @NotNull
    protected abstract View onCreateView(@NotNull Context var1, @NotNull LayoutInflater var2, @NotNull AbsSetting var3);
}

