/*
 * Decompiled with CFR 0.152.
 */
package com.dailystudio.devbricksx.preference;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import androidx.lifecycle.MutableLiveData;
import com.dailystudio.devbricksx.development.Logger;
import com.dailystudio.devbricksx.preference.PrefsChange;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\f\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\rJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004J\u001e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0015J\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004J\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0017J\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004J\u001e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0019J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u001c\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0004H\u0004J\u001e\u0010 \u001a\u00020\u001e2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010!\u001a\u00020\rJ\u001e\u0010\"\u001a\u00020\u001e2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u0015J\u001e\u0010$\u001a\u00020\u001e2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u0017J\u001e\u0010&\u001a\u00020\u001e2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\u0019J \u0010(\u001a\u00020\u001e2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\b\u0010)\u001a\u0004\u0018\u00010\u0004R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006*"}, d2={"Lcom/dailystudio/devbricksx/preference/AbsPrefs;", "", "()V", "prefName", "", "getPrefName", "()Ljava/lang/String;", "prefsChange", "Landroidx/lifecycle/MutableLiveData;", "Lcom/dailystudio/devbricksx/preference/PrefsChange;", "getPrefsChange", "()Landroidx/lifecycle/MutableLiveData;", "getBooleanPrefValue", "", "context", "Landroid/content/Context;", "pref", "defVal", "getEditor", "Landroid/content/SharedPreferences$Editor;", "getFloatPrefValue", "", "getIntegerPrefValue", "", "getLongPrefValue", "", "getSharedPreferences", "Landroid/content/SharedPreferences;", "getStringPrefValue", "notifyPrefChanged", "", "key", "setBooleanPrefValue", "bValue", "setFloatPrefValue", "fValue", "setIntegerPrefValue", "iValue", "setLongPrefValue", "lValue", "setStringPrefValue", "sValue", "devbricksx_release"})
public abstract class AbsPrefs {
    @NotNull
    private final MutableLiveData<PrefsChange> prefsChange = new MutableLiveData();

    @NotNull
    public final MutableLiveData<PrefsChange> getPrefsChange() {
        return this.prefsChange;
    }

    private final SharedPreferences getSharedPreferences(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(this.getPrefName(), 0);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"context.getSharedPrefere\u2026me, Context.MODE_PRIVATE)");
        return sharedPreferences;
    }

    private final SharedPreferences.Editor getEditor(Context context) {
        SharedPreferences sharedPref = this.getSharedPreferences(context);
        SharedPreferences.Editor editor = sharedPref.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"sharedPref.edit()");
        return editor;
    }

    public final void setStringPrefValue(@NotNull Context context, @NotNull String pref, @Nullable String sValue) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)pref, (String)"pref");
        SharedPreferences.Editor editor = this.getEditor(context);
        editor.putString(pref, sValue);
        editor.commit();
        this.notifyPrefChanged(pref);
    }

    public final void setBooleanPrefValue(@NotNull Context context, @NotNull String pref, boolean bValue) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)pref, (String)"pref");
        SharedPreferences.Editor editor = this.getEditor(context);
        editor.putBoolean(pref, bValue);
        editor.commit();
        this.notifyPrefChanged(pref);
    }

    public final void setLongPrefValue(@NotNull Context context, @NotNull String pref, long lValue) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)pref, (String)"pref");
        SharedPreferences.Editor editor = this.getEditor(context);
        editor.putLong(pref, lValue);
        editor.commit();
        this.notifyPrefChanged(pref);
    }

    public final void setIntegerPrefValue(@NotNull Context context, @NotNull String pref, int iValue) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)pref, (String)"pref");
        SharedPreferences.Editor editor = this.getEditor(context);
        editor.putInt(pref, iValue);
        editor.commit();
        this.notifyPrefChanged(pref);
    }

    public final void setFloatPrefValue(@NotNull Context context, @NotNull String pref, float fValue) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)pref, (String)"pref");
        SharedPreferences.Editor editor = this.getEditor(context);
        editor.putFloat(pref, fValue);
        editor.commit();
        this.notifyPrefChanged(pref);
    }

    @Nullable
    public final String getStringPrefValue(@NotNull Context context, @NotNull String pref) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)pref, (String)"pref");
        SharedPreferences sharedPref = this.getSharedPreferences(context);
        return sharedPref.getString(pref, null);
    }

    public final boolean getBooleanPrefValue(@NotNull Context context, @NotNull String pref) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)pref, (String)"pref");
        return this.getBooleanPrefValue(context, pref, false);
    }

    public final boolean getBooleanPrefValue(@NotNull Context context, @NotNull String pref, boolean defVal) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)pref, (String)"pref");
        SharedPreferences sharedPref = this.getSharedPreferences(context);
        return sharedPref.getBoolean(pref, defVal);
    }

    public final long getLongPrefValue(@NotNull Context context, @NotNull String pref) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)pref, (String)"pref");
        return this.getLongPrefValue(context, pref, 0L);
    }

    public final long getLongPrefValue(@NotNull Context context, @NotNull String pref, long defVal) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)pref, (String)"pref");
        SharedPreferences sharedPref = this.getSharedPreferences(context);
        return sharedPref.getLong(pref, defVal);
    }

    public final int getIntegerPrefValue(@NotNull Context context, @NotNull String pref) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)pref, (String)"pref");
        return this.getIntegerPrefValue(context, pref, 0);
    }

    public final int getIntegerPrefValue(@NotNull Context context, @NotNull String pref, int defVal) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)pref, (String)"pref");
        SharedPreferences sharedPreferences = this.getSharedPreferences(context);
        if (sharedPreferences == null) {
            return defVal;
        }
        SharedPreferences sharedPref = sharedPreferences;
        return sharedPref.getInt(pref, defVal);
    }

    public final float getFloatPrefValue(@NotNull Context context, @NotNull String pref) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)pref, (String)"pref");
        return this.getFloatPrefValue(context, pref, 0.0f);
    }

    public final float getFloatPrefValue(@NotNull Context context, @NotNull String pref, float defVal) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)pref, (String)"pref");
        SharedPreferences sharedPref = this.getSharedPreferences(context);
        return sharedPref.getFloat(pref, defVal);
    }

    protected final void notifyPrefChanged(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (TextUtils.isEmpty((CharSequence)key)) {
            return;
        }
        Logger.INSTANCE.debug("preference changed: [" + key + ']', new Object[0]);
        this.prefsChange.postValue((Object)new PrefsChange(this, key));
    }

    @NotNull
    protected abstract String getPrefName();
}

