/*
 * Decompiled with CFR 0.152.
 */
package com.dailystudio.devbricksx.inmemory;

import androidx.lifecycle.LiveData;
import com.dailystudio.devbricksx.development.Logger;
import com.dailystudio.devbricksx.inmemory.InMemoryObject;
import com.dailystudio.devbricksx.inmemory.InMemoryObjectManager;
import com.dailystudio.devbricksx.inmemory.InMemoryObjectObserver;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00040\u00032\u00020\u0005B\u0017\u0012\u0010\u0010\u0006\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\nH\u0014R\u0018\u0010\u0006\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/dailystudio/devbricksx/inmemory/InMemoryObjectsLiveData;", "Object", "Lcom/dailystudio/devbricksx/inmemory/InMemoryObject;", "Landroidx/lifecycle/LiveData;", "", "Lcom/dailystudio/devbricksx/inmemory/InMemoryObjectObserver;", "manager", "Lcom/dailystudio/devbricksx/inmemory/InMemoryObjectManager;", "(Lcom/dailystudio/devbricksx/inmemory/InMemoryObjectManager;)V", "onActive", "", "onChanged", "onInactive", "devbricksx_release"})
public final class InMemoryObjectsLiveData<Object extends InMemoryObject<?>>
extends LiveData<List<? extends Object>>
implements InMemoryObjectObserver {
    private final InMemoryObjectManager<?, Object> manager;

    protected void onActive() {
        super.onActive();
        Logger.INSTANCE.debug("livedata: " + this + ", current value: " + (List)this.getValue(), new Object[0]);
        if (this.getValue() == null) {
            List<Object> initValue = this.manager.toList();
            Logger.INSTANCE.debug("post value at initialization: " + initValue, new Object[0]);
            this.postValue(initValue);
        }
        this.manager.addObserver(this);
    }

    protected void onInactive() {
        super.onInactive();
        this.manager.removeObserver(this);
    }

    @Override
    public void onChanged() {
        List<Object> data = this.manager.toList();
        this.postValue(data);
    }

    public InMemoryObjectsLiveData(@NotNull InMemoryObjectManager<?, Object> manager) {
        Intrinsics.checkNotNullParameter(manager, (String)"manager");
        this.manager = manager;
    }
}

