/*
 * Decompiled with CFR 0.152.
 */
package com.dailystudio.devbricksx.database;

import android.database.Cursor;
import androidx.lifecycle.LiveData;
import androidx.paging.DataSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.paging.LimitOffsetDataSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.dailystudio.devbricksx.database.DateConverter;
import com.dailystudio.devbricksx.database.RecordDao;
import com.dailystudio.devbricksx.database._Record;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlinx.coroutines.flow.Flow;

public final class RecordDao_Impl
extends RecordDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<_Record> __insertionAdapterOf_Record;
    private final DateConverter __dateConverter = new DateConverter();
    private final EntityDeletionOrUpdateAdapter<_Record> __deletionAdapterOf_Record;
    private final EntityDeletionOrUpdateAdapter<_Record> __updateAdapterOf_Record;

    public RecordDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOf_Record = new EntityInsertionAdapter<_Record>(__db){

            public String createQuery() {
                return "INSERT OR IGNORE INTO `record` (`created`,`last_modified`,`id`) VALUES (?,?,nullif(?, 0))";
            }

            public void bind(SupportSQLiteStatement stmt, _Record value) {
                Long _tmp = RecordDao_Impl.this.__dateConverter.dateToTimestamp(value.created);
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindLong(1, _tmp.longValue());
                }
                Long _tmp_1 = RecordDao_Impl.this.__dateConverter.dateToTimestamp(value.lastModified);
                if (_tmp_1 == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindLong(2, _tmp_1.longValue());
                }
                stmt.bindLong(3, (long)value.id);
            }
        };
        this.__deletionAdapterOf_Record = new EntityDeletionOrUpdateAdapter<_Record>(__db){

            public String createQuery() {
                return "DELETE FROM `record` WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, _Record value) {
                stmt.bindLong(1, (long)value.id);
            }
        };
        this.__updateAdapterOf_Record = new EntityDeletionOrUpdateAdapter<_Record>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `record` SET `created` = ?,`last_modified` = ?,`id` = ? WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, _Record value) {
                Long _tmp = RecordDao_Impl.this.__dateConverter.dateToTimestamp(value.created);
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindLong(1, _tmp.longValue());
                }
                Long _tmp_1 = RecordDao_Impl.this.__dateConverter.dateToTimestamp(value.lastModified);
                if (_tmp_1 == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindLong(2, _tmp_1.longValue());
                }
                stmt.bindLong(3, (long)value.id);
                stmt.bindLong(4, (long)value.id);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long _insert(_Record companion) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            long _result = this.__insertionAdapterOf_Record.insertAndReturnId((Object)companion);
            this.__db.setTransactionSuccessful();
            Long l = _result;
            return l;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Long> _insert(List<_Record> companions) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            List _result = this.__insertionAdapterOf_Record.insertAndReturnIdsList(companions);
            this.__db.setTransactionSuccessful();
            List list = _result;
            return list;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void _delete(_Record companion) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOf_Record.handle((Object)companion);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void _update(_Record companion) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOf_Record.handle((Object)companion);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void _update(List<_Record> companion) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOf_Record.handleMultiple(companion);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void _insertOrUpdate(_Record companion) {
        this.__db.beginTransaction();
        try {
            RecordDao_Impl.super._insertOrUpdate(companion);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void _insertOrUpdate(List<_Record> companions) {
        this.__db.beginTransaction();
        try {
            RecordDao_Impl.super._insertOrUpdate(companions);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public _Record _getOne(int id2) {
        String _sql = "SELECT * FROM `record` where id = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM `record` where id = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, (long)id2);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            _Record _result;
            int _cursorIndexOfCreated = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"created");
            int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_modified");
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            if (_cursor.moveToFirst()) {
                _result = new _Record();
                Long _tmp = _cursor.isNull(_cursorIndexOfCreated) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreated));
                _result.created = this.__dateConverter.fromTimestamp(_tmp);
                Long _tmp_1 = _cursor.isNull(_cursorIndexOfLastModified) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfLastModified));
                _result.lastModified = this.__dateConverter.fromTimestamp(_tmp_1);
                _result.id = _cursor.getInt(_cursorIndexOfId);
            } else {
                _result = null;
            }
            _Record _Record2 = _result;
            return _Record2;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public LiveData<_Record> _getOneLive(int id2) {
        String _sql = "SELECT * FROM `record` where id = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM `record` where id = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, (long)id2);
        return this.__db.getInvalidationTracker().createLiveData(new String[]{"record"}, false, (Callable)new Callable<_Record>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public _Record call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)RecordDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    _Record _result;
                    int _cursorIndexOfCreated = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"created");
                    int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_modified");
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    if (_cursor.moveToFirst()) {
                        _result = new _Record();
                        Long _tmp = _cursor.isNull(_cursorIndexOfCreated) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreated));
                        _result.created = RecordDao_Impl.this.__dateConverter.fromTimestamp(_tmp);
                        Long _tmp_1 = _cursor.isNull(_cursorIndexOfLastModified) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfLastModified));
                        _result.lastModified = RecordDao_Impl.this.__dateConverter.fromTimestamp(_tmp_1);
                        _result.id = _cursor.getInt(_cursorIndexOfId);
                    } else {
                        _result = null;
                    }
                    _Record _Record2 = _result;
                    return _Record2;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<_Record> _getAll() {
        String _sql = "SELECT * FROM `record`";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM `record`", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfCreated = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"created");
            int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_modified");
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            ArrayList<_Record> _result = new ArrayList<_Record>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                _Record _item = new _Record();
                Long _tmp = _cursor.isNull(_cursorIndexOfCreated) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreated));
                _item.created = this.__dateConverter.fromTimestamp(_tmp);
                Long _tmp_1 = _cursor.isNull(_cursorIndexOfLastModified) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfLastModified));
                _item.lastModified = this.__dateConverter.fromTimestamp(_tmp_1);
                _item.id = _cursor.getInt(_cursorIndexOfId);
                _result.add(_item);
            }
            ArrayList<_Record> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public LiveData<List<_Record>> _getAllLive() {
        String _sql = "SELECT * FROM `record`";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM `record`", (int)0);
        return this.__db.getInvalidationTracker().createLiveData(new String[]{"record"}, false, (Callable)new Callable<List<_Record>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<_Record> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)RecordDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfCreated = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"created");
                    int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_modified");
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    ArrayList<_Record> _result = new ArrayList<_Record>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        _Record _item = new _Record();
                        Long _tmp = _cursor.isNull(_cursorIndexOfCreated) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreated));
                        _item.created = RecordDao_Impl.this.__dateConverter.fromTimestamp(_tmp);
                        Long _tmp_1 = _cursor.isNull(_cursorIndexOfLastModified) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfLastModified));
                        _item.lastModified = RecordDao_Impl.this.__dateConverter.fromTimestamp(_tmp_1);
                        _item.id = _cursor.getInt(_cursorIndexOfId);
                        _result.add(_item);
                    }
                    ArrayList<_Record> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public DataSource.Factory<Integer, _Record> _getAllDataSource() {
        String _sql = "SELECT * FROM `record`";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM `record`", (int)0);
        return new DataSource.Factory<Integer, _Record>(){

            public LimitOffsetDataSource<_Record> create() {
                return new LimitOffsetDataSource<_Record>(RecordDao_Impl.this.__db, _statement, false, new String[]{"record"}){

                    protected List<_Record> convertRows(Cursor cursor) {
                        int _cursorIndexOfCreated = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"created");
                        int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"last_modified");
                        int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"id");
                        ArrayList<_Record> _res = new ArrayList<_Record>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            _Record _item = new _Record();
                            Long _tmp = cursor.isNull(_cursorIndexOfCreated) ? null : Long.valueOf(cursor.getLong(_cursorIndexOfCreated));
                            _item.created = RecordDao_Impl.this.__dateConverter.fromTimestamp(_tmp);
                            Long _tmp_1 = cursor.isNull(_cursorIndexOfLastModified) ? null : Long.valueOf(cursor.getLong(_cursorIndexOfLastModified));
                            _item.lastModified = RecordDao_Impl.this.__dateConverter.fromTimestamp(_tmp_1);
                            _item.id = cursor.getInt(_cursorIndexOfId);
                            _res.add(_item);
                        }
                        return _res;
                    }
                };
            }
        };
    }

    @Override
    public Flow<List<_Record>> _getAllFlow() {
        String _sql = "SELECT * FROM `record`";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM `record`", (int)0);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"record"}, (Callable)new Callable<List<_Record>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<_Record> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)RecordDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfCreated = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"created");
                    int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_modified");
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    ArrayList<_Record> _result = new ArrayList<_Record>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        _Record _item = new _Record();
                        Long _tmp = _cursor.isNull(_cursorIndexOfCreated) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreated));
                        _item.created = RecordDao_Impl.this.__dateConverter.fromTimestamp(_tmp);
                        Long _tmp_1 = _cursor.isNull(_cursorIndexOfLastModified) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfLastModified));
                        _item.lastModified = RecordDao_Impl.this.__dateConverter.fromTimestamp(_tmp_1);
                        _item.id = _cursor.getInt(_cursorIndexOfId);
                        _result.add(_item);
                    }
                    ArrayList<_Record> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

