/*
 * Decompiled with CFR 0.152.
 */
package com.dailystudio.devbricksx.utils;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import androidx.core.content.res.ResourcesCompat;
import com.dailystudio.devbricksx.development.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004J\u0018\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004\u00a8\u0006\n"}, d2={"Lcom/dailystudio/devbricksx/utils/ResourcesCompatUtils;", "", "()V", "getColor", "", "context", "Landroid/content/Context;", "resId", "getDrawable", "Landroid/graphics/drawable/Drawable;", "devbricksx_release"})
public final class ResourcesCompatUtils {
    public static final ResourcesCompatUtils INSTANCE;

    @Nullable
    public final Drawable getDrawable(@NotNull Context context, int resId) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (resId <= 0) {
            Logger.INSTANCE.error("invalid resource id: " + resId, new Object[0]);
            return null;
        }
        return ResourcesCompat.getDrawable((Resources)context.getResources(), (int)resId, (Resources.Theme)context.getTheme());
    }

    public final int getColor(@NotNull Context context, int resId) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (resId <= 0) {
            Logger.INSTANCE.error("invalid resource id: " + resId, new Object[0]);
            return 0;
        }
        return ResourcesCompat.getColor((Resources)context.getResources(), (int)resId, (Resources.Theme)context.getTheme());
    }

    private ResourcesCompatUtils() {
    }

    static {
        ResourcesCompatUtils resourcesCompatUtils;
        INSTANCE = resourcesCompatUtils = new ResourcesCompatUtils();
    }
}

