/*
 * Decompiled with CFR 0.152.
 */
package com.dailystudio.devbricksx.repository;

import androidx.lifecycle.LiveData;
import androidx.paging.LivePagedListBuilder;
import androidx.paging.PagedList;
import com.dailystudio.devbricksx.inmemory.InMemoryObject;
import com.dailystudio.devbricksx.inmemory.InMemoryObjectManager;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u0016\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u0002*\u000e\b\u0001\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00010\u00042\u00020\u0005B!\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0016J\u0015\u0010\u0017\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0018\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0019J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00010\rJ\u0013\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0016J\u0014\u0010\u001b\u001a\u00020\u00142\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00010\rJ\u0013\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0016J\u0014\u0010\u001d\u001a\u00020\u00142\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00010\rJ\u0013\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0016J\u0014\u0010\u001e\u001a\u00020\u00142\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00010\rR\u001d\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00110\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/dailystudio/devbricksx/repository/ObjectRepository;", "Key", "", "Object", "Lcom/dailystudio/devbricksx/inmemory/InMemoryObject;", "", "manager", "Lcom/dailystudio/devbricksx/inmemory/InMemoryObjectManager;", "pageSize", "", "(Lcom/dailystudio/devbricksx/inmemory/InMemoryObjectManager;I)V", "allObjectsLive", "Landroidx/lifecycle/LiveData;", "", "getAllObjectsLive", "()Landroidx/lifecycle/LiveData;", "allObjectsPaged", "Landroidx/paging/PagedList;", "getAllObjectsPaged", "delete", "", "object", "(Lcom/dailystudio/devbricksx/inmemory/InMemoryObject;)V", "get", "key", "(Ljava/lang/Comparable;)Lcom/dailystudio/devbricksx/inmemory/InMemoryObject;", "getAllObjects", "insert", "objects", "insertOrUpdate", "update", "devbricksx_release"})
public class ObjectRepository<Key extends Comparable<? super Key>, Object extends InMemoryObject<Key>> {
    @NotNull
    private final LiveData<List<Object>> allObjectsLive;
    @NotNull
    private final LiveData<PagedList<Object>> allObjectsPaged;
    private final InMemoryObjectManager<Key, Object> manager;
    private final int pageSize;

    @NotNull
    public final LiveData<List<Object>> getAllObjectsLive() {
        return this.allObjectsLive;
    }

    @NotNull
    public final LiveData<PagedList<Object>> getAllObjectsPaged() {
        return this.allObjectsPaged;
    }

    @Nullable
    public final Object get(@NotNull Key key) {
        Intrinsics.checkParameterIsNotNull(key, (String)"key");
        return this.manager.get(key);
    }

    @NotNull
    public final List<Object> getAllObjects() {
        return this.manager.toList();
    }

    public final void insert(@NotNull Object object) {
        Intrinsics.checkParameterIsNotNull(object, (String)"object");
        this.manager.add(object);
    }

    public final void insert(@NotNull List<? extends Object> objects) {
        Intrinsics.checkParameterIsNotNull(objects, (String)"objects");
        this.manager.addAll(objects);
    }

    public final void update(@NotNull Object object) {
        Intrinsics.checkParameterIsNotNull(object, (String)"object");
        this.insert(object);
    }

    public final void update(@NotNull List<? extends Object> objects) {
        Intrinsics.checkParameterIsNotNull(objects, (String)"objects");
        this.insert(objects);
    }

    public final void insertOrUpdate(@NotNull Object object) {
        Intrinsics.checkParameterIsNotNull(object, (String)"object");
        this.insert(object);
    }

    public final void insertOrUpdate(@NotNull List<? extends Object> objects) {
        Intrinsics.checkParameterIsNotNull(objects, (String)"objects");
        this.insert(objects);
    }

    public final void delete(@NotNull Object object) {
        Intrinsics.checkParameterIsNotNull(object, (String)"object");
        this.manager.remove(object);
    }

    public ObjectRepository(@NotNull InMemoryObjectManager<Key, Object> manager, int pageSize) {
        Intrinsics.checkParameterIsNotNull(manager, (String)"manager");
        this.manager = manager;
        this.pageSize = pageSize;
        this.allObjectsLive = this.manager.toLiveData();
        LiveData liveData = new LivePagedListBuilder(this.manager.toDataSource(), this.pageSize).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)liveData, (String)"LivePagedListBuilder(man\u2026urce(), pageSize).build()");
        this.allObjectsPaged = liveData;
    }
}

