/*
 * Decompiled with CFR 0.152.
 */
package com.dailystudio.devbricksx.utils;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.ImageFormat;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.graphics.YuvImage;
import android.media.Image;
import android.os.Build;
import android.text.TextUtils;
import android.util.Base64;
import android.view.View;
import com.dailystudio.devbricksx.development.Logger;
import com.dailystudio.devbricksx.utils.CalendarUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u000eJ\u000e\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u000eJ\u0016\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0004J\u0018\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u000e2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019J\u0016\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u000eJ\u001f\u0010\u001a\u001a\u00020\u000e2\u0012\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u001e\"\u00020\u000e\u00a2\u0006\u0002\u0010\u001fJ\u001e\u0010\u001a\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u000eJ'\u0010\u001a\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020!2\u0012\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u001e\"\u00020\u000e\u00a2\u0006\u0002\u0010\"J\u0016\u0010#\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020\u000eJ\u0018\u0010&\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u000eJ.\u0010'\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u00042\u0006\u0010*\u001a\u00020\u00042\u0006\u0010+\u001a\u00020\u0004J\u0018\u0010,\u001a\u00020\u000e2\u0006\u0010-\u001a\u00020\u000e2\b\u0010.\u001a\u0004\u0018\u00010/J\u000e\u00100\u001a\u00020\u000e2\u0006\u0010-\u001a\u00020\u000eJ(\u00101\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010 \u001a\u0002022\u0006\u0010*\u001a\u00020\u00042\u0006\u0010+\u001a\u00020\u0004H\u0002J*\u00103\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u00104\u001a\u0002052\b\b\u0002\u00106\u001a\u00020\u00042\b\b\u0002\u00107\u001a\u00020\u0004J\"\u00108\u001a\u0004\u0018\u00010\u000e2\b\u00109\u001a\u0004\u0018\u00010:2\u0006\u0010;\u001a\u00020\u00042\u0006\u0010<\u001a\u00020\u0004J\u001e\u0010=\u001a\u00020\u00042\u0006\u0010>\u001a\u00020\u00102\u0006\u0010?\u001a\u00020\u00042\u0006\u0010@\u001a\u00020\u0004J&\u0010=\u001a\u00020\u00042\u0006\u0010>\u001a\u00020\u00102\u0006\u0010?\u001a\u00020\u00042\u0006\u0010@\u001a\u00020\u00042\u0006\u0010A\u001a\u00020\u0004J&\u0010B\u001a\u00020\u000e2\u0006\u0010C\u001a\u00020\u000e2\u0006\u0010D\u001a\u00020\u00042\u0006\u0010E\u001a\u00020\u00042\u0006\u0010F\u001a\u00020\u0004J\u001f\u0010G\u001a\u00020\t2\u0012\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u001e\"\u00020\u000e\u00a2\u0006\u0002\u0010HJ\u001a\u0010I\u001a\u0004\u0018\u00010J2\u0006\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020\u0004H\u0002J\u0016\u0010N\u001a\u00020\u000e2\u0006\u0010O\u001a\u00020\u000e2\u0006\u0010P\u001a\u00020\u0004J\u0010\u0010Q\u001a\u00020!2\u0006\u0010K\u001a\u00020LH\u0002J\u0018\u0010R\u001a\u0004\u0018\u00010\u000e2\u0006\u0010S\u001a\u00020T2\u0006\u0010U\u001a\u00020\u0010J\u000e\u0010V\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000eJ\u001e\u0010V\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010P\u001a\u00020\u00042\u0006\u0010W\u001a\u00020\u0004J&\u0010X\u001a\u00020\u000e2\u0006\u0010C\u001a\u00020\u000e2\u0006\u0010Y\u001a\u00020\u00042\u0006\u0010Z\u001a\u00020\u00042\u0006\u0010[\u001a\u00020!J \u0010\\\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010*\u001a\u0002022\u0006\u0010+\u001a\u000202H\u0002J\u0016\u0010]\u001a\u00020\u000e2\u0006\u0010O\u001a\u00020\u000e2\u0006\u0010^\u001a\u00020\u0004J\u0016\u0010_\u001a\u00020!2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010`\u001a\u00020aJ\u001e\u0010_\u001a\u00020!2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010`\u001a\u00020a2\u0006\u0010b\u001a\u00020\u0004J\u0016\u0010_\u001a\u00020!2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010c\u001a\u00020\u0010J\u001e\u0010_\u001a\u00020!2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010c\u001a\u00020\u00102\u0006\u0010b\u001a\u00020\u0004J\u001e\u0010d\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010?\u001a\u00020\u00042\u0006\u0010@\u001a\u00020\u0004J\u001e\u0010e\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010?\u001a\u00020\u00042\u0006\u0010@\u001a\u00020\u0004J\n\u0010f\u001a\u00020\u000e*\u00020LR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006g"}, d2={"Lcom/dailystudio/devbricksx/utils/ImageUtils;", "", "()V", "COLOR_FormatI420", "", "COLOR_FormatNV21", "DEFAULT_INTENSITY", "DEFAULT_RADIUS", "sIntensityCount", "", "sSumB", "sSumG", "sSumR", "bitmapFromBase64String", "Landroid/graphics/Bitmap;", "base64String", "", "bitmapToBase64String", "bitmap", "calculateBrightness", "calculateBrightnessEstimate", "pixelSpacing", "clipBitmapByPath", "src", "path", "Landroid/graphics/Path;", "compositeBitmaps", "bitmap1", "bitmap2", "bitmaps", "", "([Landroid/graphics/Bitmap;)Landroid/graphics/Bitmap;", "scale", "", "(Z[Landroid/graphics/Bitmap;)Landroid/graphics/Bitmap;", "compositeDrawableWithMask", "rgbBitmap", "alphaBitmap", "concatBitmap", "createClippedBitmap", "x", "y", "width", "height", "createColorFilteredBitmap", "origBitmap", "cm", "Landroid/graphics/ColorMatrix;", "createGrayScaledBitmap", "createScaledBitmap", "", "createTransformedBitmap", "matrix", "Landroid/graphics/Matrix;", "dstWidth", "dstHeight", "createViewSnapshot", "view", "Landroid/view/View;", "desireWidth", "desireHeight", "estimateSampleSize", "filePath", "destWidth", "destHeight", "orientation", "extendBitmap", "origin", "destW", "destH", "backgroundColor", "findMaxDimension", "([Landroid/graphics/Bitmap;)[I", "getDataFromImage", "", "image", "Landroid/media/Image;", "colorFormat", "getRoundBitmap", "source", "radius", "isImageFormatSupported", "loadAssetBitmap", "context", "Landroid/content/Context;", "assetFile", "oilPaintBitmap", "intensity", "paddingBitmap", "padding", "paddingBackground", "expand", "resizePath", "rotateBitmap", "degrees", "saveBitmap", "file", "Ljava/io/File;", "quailty", "filename", "scaleBitmap", "scaleBitmapRatioLocked", "toBitmap", "devbricksx_release"})
public final class ImageUtils {
    private static final int DEFAULT_RADIUS = 15;
    private static final int DEFAULT_INTENSITY = 10;
    private static final int[] sIntensityCount;
    private static final int[] sSumR;
    private static final int[] sSumG;
    private static final int[] sSumB;
    private static final int COLOR_FormatI420 = 1;
    private static final int COLOR_FormatNV21 = 2;
    public static final ImageUtils INSTANCE;

    public final int estimateSampleSize(@NotNull String filePath, int destWidth, int destHeight) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        return this.estimateSampleSize(filePath, destWidth, destHeight, 0);
    }

    public final int estimateSampleSize(@NotNull String filePath, int destWidth, int destHeight, int orientation) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        if (destWidth <= 0 || destHeight <= 0) {
            return 0;
        }
        int sw = 0;
        int sh = 0;
        BitmapFactory.Options opts = new BitmapFactory.Options();
        opts.inJustDecodeBounds = true;
        try {
            BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)opts);
        }
        catch (OutOfMemoryError e) {
            Logger.INSTANCE.debug("decode bound failure: %s", e.toString());
            sw = 0;
            sh = 0;
        }
        sw = opts.outWidth;
        sh = opts.outHeight;
        if (orientation == 90 || orientation == 270) {
            sw = opts.outHeight;
            sh = opts.outWidth;
        }
        int n = sw / destWidth;
        int n2 = sh / destHeight;
        boolean bl = false;
        return Math.min(n, n2);
    }

    @NotNull
    public final Bitmap rotateBitmap(@NotNull Bitmap source, int degrees) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Bitmap source2 = source;
        if (degrees != 0) {
            Matrix m = new Matrix();
            m.setRotate((float)degrees, (float)source2.getWidth() / (float)2, (float)source2.getHeight() / (float)2);
            try {
                Bitmap rBitmap = Bitmap.createBitmap((Bitmap)source2, (int)0, (int)0, (int)source2.getWidth(), (int)source2.getHeight(), (Matrix)m, (boolean)true);
                if (Intrinsics.areEqual((Object)source2, (Object)rBitmap) ^ true) {
                    source2.recycle();
                    Bitmap bitmap = rBitmap;
                    Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"rBitmap");
                    source2 = bitmap;
                }
            }
            catch (OutOfMemoryError ex) {
                Logger.INSTANCE.debug("rotate bitmap failure: %s", ex.toString());
            }
        }
        return source2;
    }

    @NotNull
    public final Bitmap scaleBitmapRatioLocked(@NotNull Bitmap bitmap, int destWidth, int destHeight) {
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        boolean bl = false;
        int destMin = Math.min(destWidth, destHeight);
        if (destMin <= 0) {
            Logger.INSTANCE.warn("incorrect dest dimen: [%d, %d]", destWidth, destHeight);
            return bitmap;
        }
        int w = bitmap.getWidth();
        int h = bitmap.getHeight();
        int tw = 0;
        int th = 0;
        if (w > h) {
            tw = destMin;
            th = tw * h / w;
        } else if (w < h) {
            th = destMin;
            tw = th * w / h;
        } else {
            tw = th = destMin;
        }
        return this.scaleBitmap(bitmap, tw, th);
    }

    @NotNull
    public final Bitmap scaleBitmap(@NotNull Bitmap bitmap, int destWidth, int destHeight) {
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        if (destWidth <= 0 || destHeight <= 0) {
            return bitmap;
        }
        Bitmap newBitmap = bitmap;
        int oWidth = bitmap.getWidth();
        int oHeight = bitmap.getHeight();
        if (oWidth > destWidth) {
            if (oHeight > destHeight) {
                float scaleWidth = (float)destWidth / (float)oWidth;
                float scaleHeight = (float)destHeight / (float)oHeight;
                if (scaleWidth > scaleHeight) {
                    Bitmap tempBitmap = this.createScaledBitmap(bitmap, scaleWidth, oWidth, oHeight);
                    if (tempBitmap != null) {
                        newBitmap = this.createClippedBitmap(tempBitmap, 0, (tempBitmap.getHeight() - destHeight) / 2, destWidth, destHeight);
                    }
                } else {
                    Bitmap tempBitmap = this.createScaledBitmap(bitmap, scaleHeight, oWidth, oHeight);
                    if (tempBitmap != null) {
                        newBitmap = this.createClippedBitmap(tempBitmap, (tempBitmap.getWidth() - destWidth) / 2, 0, destWidth, destHeight);
                    }
                }
            } else {
                newBitmap = this.createClippedBitmap(bitmap, (bitmap.getWidth() - destWidth) / 2, 0, destWidth, oHeight);
            }
        } else if (oWidth <= destWidth) {
            if (oHeight > destHeight) {
                newBitmap = this.createClippedBitmap(bitmap, 0, (bitmap.getHeight() - destHeight) / 2, oWidth, destHeight);
            } else {
                Bitmap bitmap2 = Bitmap.createBitmap((int)destWidth, (int)destHeight, (Bitmap.Config)bitmap.getConfig());
                Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"Bitmap.createBitmap(dest\u2026estHeight, bitmap.config)");
                newBitmap = bitmap2;
                Canvas c = new Canvas(newBitmap);
                Paint p = new Paint(1);
                c.drawBitmap(bitmap, new Rect(0, 0, bitmap.getWidth(), bitmap.getHeight()), new Rect(0, 0, destWidth, destHeight), p);
            }
        }
        return newBitmap;
    }

    @NotNull
    public final Bitmap createTransformedBitmap(@NotNull Bitmap bitmap, @NotNull Matrix matrix, int dstWidth, int dstHeight) {
        Bitmap bitmap2;
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        Intrinsics.checkParameterIsNotNull((Object)matrix, (String)"matrix");
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        RectF rect = new RectF(0.0f, 0.0f, (float)width, (float)height);
        Logger.INSTANCE.debug("original rect: " + rect, new Object[0]);
        matrix.mapRect(rect);
        Logger.INSTANCE.debug("mapped rect: " + rect, new Object[0]);
        if (dstWidth != 0 && dstHeight != 0) {
            bitmap2 = Bitmap.createBitmap((int)dstWidth, (int)dstHeight, (Bitmap.Config)bitmap.getConfig());
        } else {
            float f;
            float widthCropped;
            float f2;
            if (rect.left < 0.0f) {
                float f3 = rect.left;
                boolean bl = false;
                f2 = Math.abs(f3) * (float)2;
            } else {
                f2 = widthCropped = 0.0f;
            }
            if (rect.top < 0.0f) {
                float f4 = rect.top;
                boolean bl = false;
                f = Math.abs(f4) * (float)2;
            } else {
                f = 0.0f;
            }
            float heightCropped = f;
            bitmap2 = Bitmap.createBitmap((int)MathKt.roundToInt((float)(rect.width() - widthCropped)), (int)MathKt.roundToInt((float)(rect.height() - heightCropped)), (Bitmap.Config)bitmap.getConfig());
        }
        Bitmap transformed = bitmap2;
        Canvas canvas = new Canvas(transformed);
        canvas.drawBitmap(bitmap, matrix, new Paint());
        Bitmap bitmap3 = transformed;
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap3, (String)"transformed");
        return bitmap3;
    }

    public static /* synthetic */ Bitmap createTransformedBitmap$default(ImageUtils imageUtils, Bitmap bitmap, Matrix matrix, int n, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            n2 = 0;
        }
        return imageUtils.createTransformedBitmap(bitmap, matrix, n, n2);
    }

    private final Bitmap createScaledBitmap(Bitmap bitmap, float scale, int width, int height) {
        Matrix matrix = new Matrix();
        matrix.postScale(scale, scale);
        Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"Bitmap.createBitmap(bitm\u2026            matrix, true)");
        return bitmap2;
    }

    @NotNull
    public final Bitmap createClippedBitmap(@NotNull Bitmap bitmap, int x, int y, int width, int height) {
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)x, (int)y, (int)width, (int)height);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"Bitmap.createBitmap(bitmap, x, y, width, height)");
        return bitmap2;
    }

    public final boolean saveBitmap(@NotNull Bitmap bitmap, @NotNull String filename) {
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        Intrinsics.checkParameterIsNotNull((Object)filename, (String)"filename");
        return this.saveBitmap(bitmap, filename, 100);
    }

    public final boolean saveBitmap(@NotNull Bitmap bitmap, @NotNull String filename, int quailty) {
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        Intrinsics.checkParameterIsNotNull((Object)filename, (String)"filename");
        File file = new File(filename);
        return this.saveBitmap(bitmap, file, quailty);
    }

    public final boolean saveBitmap(@NotNull Bitmap bitmap, @NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return this.saveBitmap(bitmap, file, 100);
    }

    public final boolean saveBitmap(@NotNull Bitmap bitmap, @NotNull File file, int quailty) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        boolean success = false;
        try {
            FileOutputStream out = new FileOutputStream(file);
            Bitmap.CompressFormat format = quailty >= 100 ? Bitmap.CompressFormat.PNG : Bitmap.CompressFormat.JPEG;
            Logger.INSTANCE.debug("save bitmap: %s, [quality: %d, format: %s]", file, quailty, format);
            boolean ret = bitmap.compress(format, quailty, (OutputStream)out);
            out.flush();
            out.close();
            bl = ret;
        }
        catch (IOException e) {
            Logger.INSTANCE.debug("save bitmap failure: %s", e.toString());
            bl = false;
        }
        success = bl;
        return success;
    }

    @NotNull
    public final Bitmap createColorFilteredBitmap(@NotNull Bitmap origBitmap, @Nullable ColorMatrix cm) {
        Intrinsics.checkParameterIsNotNull((Object)origBitmap, (String)"origBitmap");
        if (cm == null) {
            return origBitmap;
        }
        int width = origBitmap.getWidth();
        int height = origBitmap.getHeight();
        if (width <= 0 || height <= 0) {
            return origBitmap;
        }
        Bitmap filteredBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas c = new Canvas(filteredBitmap);
        ColorMatrixColorFilter f = new ColorMatrixColorFilter(cm);
        Paint paint = new Paint();
        paint.setColorFilter((ColorFilter)f);
        c.drawBitmap(origBitmap, 0.0f, 0.0f, paint);
        Bitmap bitmap = filteredBitmap;
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"filteredBitmap");
        return bitmap;
    }

    @NotNull
    public final Bitmap createGrayScaledBitmap(@NotNull Bitmap origBitmap) {
        Intrinsics.checkParameterIsNotNull((Object)origBitmap, (String)"origBitmap");
        ColorMatrix cm = new ColorMatrix();
        cm.setSaturation(0.0f);
        return this.createColorFilteredBitmap(origBitmap, cm);
    }

    @Nullable
    public final Bitmap createViewSnapshot(@Nullable View view, int desireWidth, int desireHeight) {
        Bitmap bitmap;
        if (view == null) {
            return null;
        }
        int widthMeasureSpec = desireWidth <= 0 ? View.MeasureSpec.makeMeasureSpec((int)desireWidth, (int)0) : View.MeasureSpec.makeMeasureSpec((int)desireWidth, (int)0x40000000);
        int heightMeasureSpec = desireHeight <= 0 ? View.MeasureSpec.makeMeasureSpec((int)desireHeight, (int)0) : View.MeasureSpec.makeMeasureSpec((int)desireHeight, (int)0x40000000);
        view.measure(widthMeasureSpec, heightMeasureSpec);
        Logger.INSTANCE.debug("MEASURED: [%d, %d]", view.getMeasuredWidth(), view.getMeasuredHeight());
        view.layout(0, 0, view.getMeasuredWidth(), view.getMeasuredHeight());
        Bitmap.Config config = Bitmap.Config.ARGB_8888;
        Bitmap bitmap2 = null;
        try {
            bitmap = Bitmap.createBitmap((int)desireWidth, (int)desireHeight, (Bitmap.Config)config);
        }
        catch (OutOfMemoryError e) {
            Logger.INSTANCE.warn("create cache bitmap failure: %s", e.toString());
            bitmap = null;
        }
        bitmap2 = bitmap;
        if (bitmap2 == null) {
            return null;
        }
        Canvas canvas = new Canvas(bitmap2);
        view.draw(canvas);
        return bitmap2;
    }

    @NotNull
    public final String bitmapToBase64String(@NotNull Bitmap bitmap) {
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] bytes = null;
        String base64str = "";
        try {
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)baos);
            bytes = baos.toByteArray();
            String string = Base64.encodeToString((byte[])bytes, (int)0);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Base64.encodeToString(bytes, Base64.DEFAULT)");
            base64str = string;
        }
        catch (OutOfMemoryError e) {
            Logger.INSTANCE.debug("convert bitmap failure : %s", e.toString());
        }
        return base64str;
    }

    @Nullable
    public final Bitmap bitmapFromBase64String(@NotNull String base64String) {
        Intrinsics.checkParameterIsNotNull((Object)base64String, (String)"base64String");
        if (TextUtils.isEmpty((CharSequence)base64String)) {
            return null;
        }
        Bitmap bitmap = null;
        try {
            byte[] bytes = Base64.decode((String)base64String, (int)0);
            if (bytes != null) {
                byte[] byArray = bytes;
                boolean bl = false;
                byte[] byArray2 = byArray;
                boolean bl2 = false;
                if (!(byArray2.length == 0)) {
                    bitmap = BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length);
                }
            }
        }
        catch (OutOfMemoryError e) {
            Logger.INSTANCE.warn("decode bitmap from Base64 string failure: %s", e.toString());
            bitmap = null;
        }
        return bitmap;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Bitmap compositeDrawableWithMask(@NotNull Bitmap rgbBitmap, @NotNull Bitmap alphaBitmap) {
        Intrinsics.checkParameterIsNotNull((Object)rgbBitmap, (String)"rgbBitmap");
        Intrinsics.checkParameterIsNotNull((Object)alphaBitmap, (String)"alphaBitmap");
        int rgbW = rgbBitmap.getWidth();
        int rgbH = rgbBitmap.getHeight();
        int alphaW = alphaBitmap.getWidth();
        int alphaH = alphaBitmap.getHeight();
        if (rgbW != alphaW || rgbH != alphaH) {
            Logger.INSTANCE.warn("mismatch bitmaps, rgb[%-3dx%-3d], alpha[%-3dx%-3d]", rgbW, rgbH, alphaW, alphaH);
            return rgbBitmap;
        }
        Bitmap destBitmap = Bitmap.createBitmap((int)rgbW, (int)rgbH, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        int[] pixels = new int[rgbW];
        int[] alpha = new int[rgbW];
        int n = 0;
        int n2 = rgbH;
        while (n < n2) {
            void y;
            rgbBitmap.getPixels(pixels, 0, rgbW, 0, (int)y, rgbW, 1);
            alphaBitmap.getPixels(alpha, 0, rgbW, 0, (int)y, rgbW, 1);
            int n3 = 0;
            int n4 = rgbW;
            while (n3 < n4) {
                void x;
                pixels[x] = pixels[x] & 0xFFFFFF | alpha[x] << 8 & 0xFF000000;
                ++x;
            }
            destBitmap.setPixels(pixels, 0, rgbW, 0, (int)y, rgbW, 1);
            ++y;
        }
        Bitmap bitmap = destBitmap;
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"destBitmap");
        return bitmap;
    }

    @NotNull
    public final Bitmap compositeBitmaps(@NotNull Bitmap bitmap1, @NotNull Bitmap bitmap2) {
        Intrinsics.checkParameterIsNotNull((Object)bitmap1, (String)"bitmap1");
        Intrinsics.checkParameterIsNotNull((Object)bitmap2, (String)"bitmap2");
        return this.compositeBitmaps(false, bitmap1, bitmap2);
    }

    @NotNull
    public final Bitmap compositeBitmaps(boolean scale, @NotNull Bitmap bitmap1, @NotNull Bitmap bitmap2) {
        Intrinsics.checkParameterIsNotNull((Object)bitmap1, (String)"bitmap1");
        Intrinsics.checkParameterIsNotNull((Object)bitmap2, (String)"bitmap2");
        return this.compositeBitmaps(scale, new Bitmap[]{bitmap1, bitmap2});
    }

    @NotNull
    public final Bitmap compositeBitmaps(Bitmap ... bitmaps) {
        Intrinsics.checkParameterIsNotNull((Object)bitmaps, (String)"bitmaps");
        return this.compositeBitmaps(false, Arrays.copyOf(bitmaps, bitmaps.length));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Bitmap compositeBitmaps(boolean scale, Bitmap ... bitmaps) {
        Bitmap bitmap;
        int[] dimension;
        Intrinsics.checkParameterIsNotNull((Object)bitmaps, (String)"bitmaps");
        int N = bitmaps.length;
        if (N == 1) {
            return bitmaps[0];
        }
        int bw = bitmaps[0].getWidth();
        int bh = bitmaps[0].getHeight();
        Bitmap.Config config = bitmaps[0].getConfig();
        if (!scale && (dimension = this.findMaxDimension(Arrays.copyOf(bitmaps, bitmaps.length))) != null) {
            bw = dimension[0];
            bh = dimension[1];
        }
        Bitmap finalBitmap = null;
        try {
            bitmap = Bitmap.createBitmap((int)bw, (int)bh, (Bitmap.Config)config);
        }
        catch (OutOfMemoryError e) {
            Logger.INSTANCE.warn("could not create composite bitmap: %s", e.toString());
            bitmap = null;
        }
        finalBitmap = bitmap;
        if (finalBitmap == null) {
            return bitmaps[0];
        }
        Canvas canvas = new Canvas(finalBitmap);
        Bitmap currbmp = null;
        Rect src = new Rect();
        Rect dst = new Rect();
        int xoff = 0;
        int yoff = 0;
        int n = 0;
        int n2 = N;
        while (n < n2) {
            void i;
            currbmp = bitmaps[i];
            if (currbmp != null) {
                xoff = 0;
                yoff = 0;
                if (currbmp.getWidth() != bw || currbmp.getHeight() != bh) {
                    if (scale) {
                        currbmp = this.scaleBitmap(currbmp, bw, bh);
                    } else {
                        xoff = (bw - currbmp.getWidth()) / 2;
                        yoff = (bh - currbmp.getHeight()) / 2;
                    }
                }
                if (currbmp != null) {
                    Bitmap bitmap2;
                    boolean bl = false;
                    boolean bl2 = false;
                    Bitmap it = bitmap2;
                    boolean bl3 = false;
                    src.set(0, 0, it.getWidth(), it.getHeight());
                    dst.set(xoff, yoff, xoff + it.getWidth(), yoff + it.getHeight());
                    canvas.drawBitmap(it, src, dst, null);
                }
            }
            ++i;
        }
        return finalBitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Bitmap loadAssetBitmap(@NotNull Context context, @NotNull String assetFile) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)assetFile, (String)"assetFile");
        AssetManager assetManager = context.getAssets();
        if (assetManager == null) {
            return null;
        }
        AssetManager assetManager2 = assetManager;
        if (TextUtils.isEmpty((CharSequence)assetFile)) {
            return null;
        }
        InputStream istream = null;
        Bitmap bitmap = null;
        try {
            istream = assetManager2.open(assetFile);
            if (istream != null) {
                bitmap = BitmapFactory.decodeStream((InputStream)istream);
            }
        }
        catch (OutOfMemoryError e) {
            Logger.INSTANCE.warn("could not decode asset bitmap: %s", assetFile, e.toString());
            bitmap = null;
        }
        catch (IOException e) {
            Logger.INSTANCE.warn("could not decode asset bitmap: %s", assetFile, e.toString());
            bitmap = null;
        }
        finally {
            try {
                InputStream inputStream = istream;
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {}
        }
        return bitmap;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final int[] findMaxDimension(Bitmap ... bitmaps) {
        Intrinsics.checkParameterIsNotNull((Object)bitmaps, (String)"bitmaps");
        int[] dimension = new int[]{0, 0};
        int N = bitmaps.length;
        if (N == 1) {
            ImageUtils imageUtils = this;
            boolean bl = false;
            boolean bl2 = false;
            ImageUtils $this$run = imageUtils;
            boolean bl3 = false;
            dimension[0] = bitmaps[0].getWidth();
            dimension[1] = bitmaps[0].getHeight();
            return dimension;
        }
        Bitmap bitmap = null;
        int n = 0;
        int n2 = N;
        while (n < n2) {
            void i;
            bitmap = bitmaps[i];
            if (bitmap.getWidth() > dimension[0]) {
                dimension[0] = bitmap.getWidth();
            }
            if (bitmap.getHeight() > dimension[1]) {
                dimension[1] = bitmap.getHeight();
            }
            ++i;
        }
        return dimension;
    }

    @NotNull
    public final Bitmap getRoundBitmap(@NotNull Bitmap source, int radius) {
        Bitmap scaledBitmap;
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Bitmap bitmap = scaledBitmap = source.getWidth() != radius || source.getHeight() != radius ? this.scaleBitmap(source, radius * 2, radius * 2) : source;
        if (bitmap == null) {
            Intrinsics.throwNpe();
        }
        Bitmap output = Bitmap.createBitmap((int)bitmap.getWidth(), (int)scaledBitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        Rect rect = new Rect(0, 0, scaledBitmap.getWidth(), scaledBitmap.getHeight());
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setFilterBitmap(true);
        paint.setDither(true);
        canvas.drawARGB(0, 0, 0, 0);
        canvas.drawCircle((float)scaledBitmap.getWidth() / (float)2, (float)scaledBitmap.getHeight() / (float)2, (float)scaledBitmap.getWidth() / (float)2, paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(scaledBitmap, rect, rect, paint);
        Bitmap bitmap2 = output;
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"output");
        return bitmap2;
    }

    public final int calculateBrightnessEstimate(@NotNull Bitmap bitmap, int pixelSpacing) {
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        if (width <= 0 || height <= 0) {
            return 0;
        }
        int r = 0;
        int g = 0;
        int b = 0;
        int n = 0;
        int[] pixels = new int[width * height];
        bitmap.getPixels(pixels, 0, width, 0, 0, width, height);
        int color = 0;
        for (int i = 0; i < pixels.length; i += pixelSpacing) {
            color = pixels[i];
            r += Color.red((int)color);
            g += Color.green((int)color);
            b += Color.blue((int)color);
            ++n;
        }
        return (r + b + g) / (n * 3);
    }

    public final int calculateBrightness(@NotNull Bitmap bitmap) {
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        return this.calculateBrightnessEstimate(bitmap, 1);
    }

    @NotNull
    public final Bitmap paddingBitmap(@NotNull Bitmap origin, int padding, int paddingBackground, boolean expand) {
        Intrinsics.checkParameterIsNotNull((Object)origin, (String)"origin");
        if (padding <= 0) {
            return origin;
        }
        int w = origin.getWidth();
        int h = origin.getHeight();
        int destW = w;
        int destH = h;
        if (expand) {
            destW += padding * 2;
            destH += padding * 2;
        }
        Bitmap newOne = Bitmap.createBitmap((int)destW, (int)destH, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(newOne);
        Paint paint = new Paint(1);
        canvas.drawColor(paddingBackground);
        canvas.drawBitmap(origin, new Rect(0, 0, w, h), new Rect(padding, padding, destW - padding, destH - padding), paint);
        Bitmap bitmap = newOne;
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"newOne");
        return bitmap;
    }

    @NotNull
    public final Bitmap extendBitmap(@NotNull Bitmap origin, int destW, int destH, int backgroundColor) {
        Intrinsics.checkParameterIsNotNull((Object)origin, (String)"origin");
        if (destW <= 0 || destH <= 0) {
            return origin;
        }
        int w = origin.getWidth();
        int h = origin.getHeight();
        if (destW < w || destH < h) {
            return origin;
        }
        Logger.INSTANCE.debug("origin = %d x %d, dest = %d x %d", w, h, destW, destH);
        Bitmap newOne = Bitmap.createBitmap((int)destW, (int)destH, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(newOne);
        Paint paint = new Paint(1);
        canvas.drawColor(backgroundColor);
        int xOffset = MathKt.roundToInt((double)((double)(destW - w) / 2.0));
        int yOffset = MathKt.roundToInt((double)((double)(destH - h) / 2.0));
        Logger.INSTANCE.debug("xOffset = %d, yOffset = %d", xOffset, yOffset);
        canvas.drawBitmap(origin, (float)xOffset, (float)yOffset, paint);
        Bitmap bitmap = newOne;
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"newOne");
        return bitmap;
    }

    @NotNull
    public final Bitmap oilPaintBitmap(@NotNull Bitmap bitmap) {
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        return this.oilPaintBitmap(bitmap, 15, 10);
    }

    @NotNull
    public final Bitmap oilPaintBitmap(@NotNull Bitmap bitmap, int radius, int intensity) {
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        Logger.INSTANCE.debug("oil paint: [%d x %d], radius = %d, intensity = %d", width, height, radius, intensity);
        if (width <= 0 || height <= 0 || radius <= 0 || intensity <= 0) {
            Logger.INSTANCE.error("invalid parameters.", new Object[0]);
            return bitmap;
        }
        long start2 = System.currentTimeMillis();
        int[] pixels = new int[width * height];
        bitmap.getPixels(pixels, 0, bitmap.getWidth(), 0, 0, bitmap.getWidth(), bitmap.getHeight());
        int[] nArray = pixels;
        int n = pixels.length;
        boolean bl = false;
        int[] nArray2 = Arrays.copyOf(nArray, n);
        Intrinsics.checkExpressionValueIsNotNull((Object)nArray2, (String)"java.util.Arrays.copyOf(this, newSize)");
        int[] output = nArray2;
        int cX = 0;
        int mX = 0;
        int mY = 0;
        int color = 0;
        int r = 0;
        int g = 0;
        int b = 0;
        int i = 0;
        int max = 0;
        int maxIndex = 0;
        int mI = 0;
        for (int cY = radius; cY < height - radius; ++cY) {
            for (cX = radius; cX < width - radius; ++cX) {
                Arrays.fill(sIntensityCount, 0);
                Arrays.fill(sSumR, 0);
                Arrays.fill(sSumG, 0);
                Arrays.fill(sSumB, 0);
                for (mY = -radius; mY <= radius; ++mY) {
                    for (mX = -radius; mX <= radius; ++mX) {
                        color = pixels[cX + mX + (cY + mY) * width];
                        r = color >> 16 & 0xFF;
                        g = color >> 8 & 0xFF;
                        b = color & 0xFF;
                        i = (int)((double)(r + g + b) / 3.0 * (double)intensity / (double)255);
                        if (i > 255) {
                            i = 255;
                        }
                        int n2 = i;
                        int n3 = sIntensityCount[n2];
                        sIntensityCount[n2] = n3 + 1;
                        ImageUtils.sSumR[i] = sSumR[i] + r;
                        ImageUtils.sSumG[i] = sSumG[i] + g;
                        ImageUtils.sSumB[i] = sSumB[i] + b;
                    }
                }
                max = 0;
                maxIndex = 0;
                for (mI = 0; mI < 256; ++mI) {
                    if (sIntensityCount[mI] <= max) continue;
                    max = sIntensityCount[mI];
                    maxIndex = mI;
                }
                r = sSumR[maxIndex] / max;
                g = sSumG[maxIndex] / max;
                b = sSumB[maxIndex] / max;
                output[cX + cY * width] = 0xFF000000 | r << 16 | g << 8 | b;
            }
        }
        Bitmap dest = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        dest.setPixels(output, 0, bitmap.getWidth(), 0, 0, bitmap.getWidth(), bitmap.getHeight());
        long end = System.currentTimeMillis();
        Logger.INSTANCE.debug("oil paint: [%d x %d], r = %d, i = %d, accomplished in %d millis [%s]", width, height, radius, intensity, end - start2, CalendarUtils.INSTANCE.durationToReadableString(end - start2));
        Bitmap bitmap2 = dest;
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"dest");
        return bitmap2;
    }

    @Nullable
    public final Bitmap concatBitmap(@NotNull Bitmap bitmap1, @NotNull Bitmap bitmap2) {
        boolean bl;
        boolean landscape2;
        Intrinsics.checkParameterIsNotNull((Object)bitmap1, (String)"bitmap1");
        Intrinsics.checkParameterIsNotNull((Object)bitmap2, (String)"bitmap2");
        Bitmap bitmap12 = bitmap1;
        Bitmap bitmap22 = bitmap2;
        int w1 = bitmap12.getWidth();
        int h1 = bitmap12.getHeight();
        int w2 = bitmap22.getWidth();
        int h2 = bitmap22.getHeight();
        Logger.INSTANCE.debug("concat bitmap1: [%d x %d]", w1, h1);
        Logger.INSTANCE.debug("concat bitmap2: [%d x %d]", w2, h2);
        boolean landscape1 = w1 > h1;
        boolean bl2 = landscape2 = w2 > h2;
        if (landscape1 != landscape2) {
            Logger.INSTANCE.error("two images has different orientation, bitmap1 is %s and bitmap2 is %s", landscape1 ? "Landscape" : "Portrait", landscape2 ? "Landscape" : "Portrait");
            return null;
        }
        int w = 0;
        int h = 0;
        if (landscape1) {
            bl = false;
            w = Math.min(w1, w2);
            if (w1 != w) {
                bitmap12 = this.scaleBitmapRatioLocked(bitmap12, w, w);
            }
            if (w2 != w) {
                bitmap22 = this.scaleBitmapRatioLocked(bitmap22, w, w);
            }
            h = bitmap12.getHeight() + bitmap22.getHeight();
        } else {
            bl = false;
            h = Math.min(h1, h2);
            if (h1 != h) {
                bitmap12 = this.scaleBitmapRatioLocked(bitmap12, h, h);
            }
            if (h2 != h) {
                bitmap22 = this.scaleBitmapRatioLocked(bitmap22, h, h);
            }
            w = bitmap12.getWidth() + bitmap22.getWidth();
        }
        Logger.INSTANCE.debug("concat bitmap: dimen = [%d x %d]", w, h);
        Bitmap newBitmap = null;
        try {
            newBitmap = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)bitmap12.getConfig());
            Canvas c = new Canvas(newBitmap);
            Paint p = new Paint(1);
            if (landscape1) {
                c.drawBitmap(bitmap12, new Rect(0, 0, w, bitmap12.getHeight()), new Rect(0, 0, w, bitmap12.getHeight()), p);
                c.drawBitmap(bitmap22, new Rect(0, 0, w, bitmap22.getHeight()), new Rect(0, bitmap12.getHeight(), w, h), p);
            } else {
                c.drawBitmap(bitmap12, new Rect(0, 0, bitmap12.getWidth(), h), new Rect(0, 0, bitmap12.getWidth(), h), p);
                c.drawBitmap(bitmap22, new Rect(0, 0, bitmap22.getWidth(), h), new Rect(bitmap12.getWidth(), 0, w, h), p);
            }
        }
        catch (OutOfMemoryError e) {
            Logger.INSTANCE.error("concat bitmaps failed: %s", e.toString());
        }
        return newBitmap;
    }

    @NotNull
    public final Bitmap clipBitmapByPath(@NotNull Bitmap src, @Nullable Path path) {
        Intrinsics.checkParameterIsNotNull((Object)src, (String)"src");
        if (path == null) {
            return src;
        }
        Path resized = this.resizePath(path, src.getWidth(), src.getHeight());
        Bitmap output = Bitmap.createBitmap((int)src.getWidth(), (int)src.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        Paint paint = new Paint(1);
        canvas.drawPath(resized, paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(src, 0.0f, 0.0f, paint);
        Bitmap bitmap = output;
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"output");
        return bitmap;
    }

    private final Path resizePath(Path path, float width, float height) {
        RectF bounds = new RectF(0.0f, 0.0f, width, height);
        Path resizedPath = new Path(path);
        RectF src = new RectF();
        resizedPath.computeBounds(src, true);
        Matrix resizeMatrix = new Matrix();
        resizeMatrix.setRectToRect(src, bounds, Matrix.ScaleToFit.CENTER);
        resizedPath.transform(resizeMatrix);
        return resizedPath;
    }

    @NotNull
    public final Bitmap toBitmap(@NotNull Image $this$toBitmap) {
        Intrinsics.checkParameterIsNotNull((Object)$this$toBitmap, (String)"$this$toBitmap");
        byte[] nv21 = this.getDataFromImage($this$toBitmap, 2);
        YuvImage yuvImage = new YuvImage(nv21, 17, $this$toBitmap.getWidth(), $this$toBitmap.getHeight(), null);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        yuvImage.compressToJpeg(new Rect(0, 0, yuvImage.getWidth(), yuvImage.getHeight()), 50, (OutputStream)out);
        byte[] imageBytes = out.toByteArray();
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])imageBytes, (int)0, (int)imageBytes.length);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"BitmapFactory.decodeByte\u2026ytes, 0, imageBytes.size)");
        return bitmap;
    }

    private final boolean isImageFormatSupported(Image image) {
        switch (image.getFormat()) {
            case 17: 
            case 35: 
            case 842094169: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final byte[] getDataFromImage(Image image, int colorFormat) {
        Rect rect;
        if (colorFormat != 1 && colorFormat != 2) {
            Logger.INSTANCE.error("supported color format: I420 or NV21", new Object[0]);
            return null;
        }
        if (!this.isImageFormatSupported(image)) {
            Logger.INSTANCE.error("can't convert Image to byte array, format " + image.getFormat(), new Object[0]);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            rect = image.getCropRect();
        } else {
            Logger.INSTANCE.warn("crop rect is only supported on 21, using fallback solution", new Object[0]);
            rect = new Rect(0, 0, image.getWidth(), image.getHeight());
        }
        Rect crop = rect;
        int format = image.getFormat();
        int width = crop.width();
        int height = crop.height();
        Image.Plane[] planes = image.getPlanes();
        byte[] data = new byte[width * height * ImageFormat.getBitsPerPixel((int)format) / 8];
        Image.Plane plane = planes[0];
        Intrinsics.checkExpressionValueIsNotNull((Object)plane, (String)"planes[0]");
        byte[] rowData = new byte[plane.getRowStride()];
        int channelOffset = 0;
        int outputStride = 1;
        int n = 0;
        Intrinsics.checkExpressionValueIsNotNull((Object)planes, (String)"planes");
        int n2 = planes.length;
        while (n < n2) {
            ByteBuffer buffer;
            void i;
            switch (i) {
                case 0: {
                    channelOffset = 0;
                    outputStride = 1;
                    break;
                }
                case 1: {
                    if (colorFormat == 1) {
                        channelOffset = width * height;
                        outputStride = 1;
                        break;
                    }
                    if (colorFormat != 2) break;
                    channelOffset = width * height + 1;
                    outputStride = 2;
                    break;
                }
                case 2: {
                    if (colorFormat == 1) {
                        channelOffset = (int)((double)(width * height) * 1.25);
                        outputStride = 1;
                        break;
                    }
                    if (colorFormat != 2) break;
                    channelOffset = width * height;
                    outputStride = 2;
                    break;
                }
            }
            Image.Plane plane2 = planes[i];
            Intrinsics.checkExpressionValueIsNotNull((Object)plane2, (String)"planes[i]");
            Intrinsics.checkExpressionValueIsNotNull((Object)plane2.getBuffer(), (String)"planes[i].buffer");
            Image.Plane plane3 = planes[i];
            Intrinsics.checkExpressionValueIsNotNull((Object)plane3, (String)"planes[i]");
            int rowStride = plane3.getRowStride();
            Image.Plane plane4 = planes[i];
            Intrinsics.checkExpressionValueIsNotNull((Object)plane4, (String)"planes[i]");
            int pixelStride = plane4.getPixelStride();
            int shift = i == false ? 0 : 1;
            int w = width >> shift;
            int h = height >> shift;
            buffer.position(rowStride * (crop.top >> shift) + pixelStride * (crop.left >> shift));
            int n3 = 0;
            int n4 = h;
            while (n3 < n4) {
                void row;
                int length = 0;
                if (pixelStride == 1 && outputStride == 1) {
                    length = w;
                    buffer.get(data, channelOffset, length);
                    channelOffset += length;
                } else {
                    length = (w - 1) * pixelStride + 1;
                    buffer.get(rowData, 0, length);
                    int n5 = 0;
                    int n6 = w;
                    while (n5 < n6) {
                        void col;
                        data[channelOffset] = rowData[col * pixelStride];
                        channelOffset += outputStride;
                        ++col;
                    }
                }
                if (row < h - 1) {
                    buffer.position(buffer.position() + rowStride - length);
                }
                ++row;
            }
            buffer.rewind();
            ++i;
        }
        return data;
    }

    private ImageUtils() {
    }

    static {
        ImageUtils imageUtils;
        INSTANCE = imageUtils = new ImageUtils();
        sIntensityCount = new int[256];
        sSumR = new int[256];
        sSumG = new int[256];
        sSumB = new int[256];
    }
}

