/*
 * Decompiled with CFR 0.152.
 */
package com.dailystudio.devbricksx.utils;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import com.dailystudio.devbricksx.development.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mozilla.universalchardet.UniversalDetector;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004J\u0018\u0010\b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004J\u0010\u0010\b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\u000bJ\u0010\u0010\b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\u0004J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000f\u001a\u00020\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\u0004J\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u0012"}, d2={"Lcom/dailystudio/devbricksx/utils/FileUtils;", "", "()V", "assetToString", "", "context", "Landroid/content/Context;", "file", "detectFileEncoding", "rawId", "", "Ljava/io/File;", "iStream", "Ljava/io/InputStream;", "fileToString", "fStream", "encoding", "rawToString", "devbricksx_release"})
public final class FileUtils {
    public static final FileUtils INSTANCE;

    @Nullable
    public final String detectFileEncoding(@NotNull String file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return this.detectFileEncoding(new File(file));
    }

    @Nullable
    public final String detectFileEncoding(@NotNull Context context, int rawId) {
        InputStream inputStream;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (rawId <= 0) {
            Logger.INSTANCE.warn("invalid resource id: " + rawId, new Object[0]);
            return null;
        }
        Resources resources = context.getResources();
        if (resources == null) {
            return null;
        }
        Resources res = resources;
        try {
            inputStream = res.openRawResource(rawId);
        }
        catch (Resources.NotFoundException e) {
            Logger.INSTANCE.warn("failed to find raw file [" + rawId + "]: " + (Object)((Object)e), new Object[0]);
            return null;
        }
        InputStream inputStream2 = inputStream;
        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream2, (String)"try {\n            res.op\u2026    return null\n        }");
        InputStream fStream = inputStream2;
        return this.detectFileEncoding(fStream);
    }

    @Nullable
    public final String detectFileEncoding(@NotNull Context context, @NotNull String file) {
        InputStream inputStream;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        AssetManager assetManager = context.getAssets();
        if (assetManager == null) {
            return null;
        }
        AssetManager assetManager2 = assetManager;
        try {
            InputStream inputStream2 = assetManager2.open(file);
            if (inputStream2 == null) {
                return null;
            }
            inputStream = inputStream2;
        }
        catch (IOException e) {
            Logger.INSTANCE.warn("failed to find asset file [" + file + "]: " + e, new Object[0]);
            return null;
        }
        InputStream inputStream3 = inputStream;
        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream3, (String)"try {\n            assetM\u2026    return null\n        }");
        InputStream fStream = inputStream3;
        return this.detectFileEncoding(fStream);
    }

    @Nullable
    public final String detectFileEncoding(@NotNull File file) {
        FileInputStream fileInputStream;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            Logger.INSTANCE.warn("get encoding failure: " + e, new Object[0]);
            return null;
        }
        FileInputStream fs = fileInputStream;
        return this.detectFileEncoding(fs);
    }

    @Nullable
    public final String detectFileEncoding(@NotNull InputStream iStream) {
        Intrinsics.checkParameterIsNotNull((Object)iStream, (String)"iStream");
        byte[] buf = new byte[4096];
        UniversalDetector detector = new UniversalDetector(null);
        Ref.IntRef nRead = new Ref.IntRef();
        try {
            while (true) {
                int n = iStream.read(buf);
                boolean bl = false;
                boolean bl2 = false;
                int it = n;
                boolean bl3 = false;
                nRead.element = it;
                if (n > 0 && !detector.isDone()) {
                    detector.handleData(buf, 0, nRead.element);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            Logger.INSTANCE.warn("get encoding failure: %s", e.toString());
        }
        detector.dataEnd();
        String string = detector.getDetectedCharset();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"detector.detectedCharset");
        String encoding = string;
        detector.reset();
        try {
            iStream.close();
        }
        catch (IOException e) {
            Logger.INSTANCE.warn("close stream failure: %s", e.toString());
        }
        return encoding;
    }

    @Nullable
    public final String fileToString(@NotNull String file) {
        FileInputStream fileInputStream;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            Logger.INSTANCE.warn("get encoding failure: " + e, new Object[0]);
            return null;
        }
        FileInputStream fs = fileInputStream;
        return this.fileToString(fs, this.detectFileEncoding(file));
    }

    @Nullable
    public final String fileToString(@NotNull InputStream fStream, @Nullable String encoding) {
        InputStreamReader inputStreamReader;
        Intrinsics.checkParameterIsNotNull((Object)fStream, (String)"fStream");
        InputStreamReader reader = null;
        String string = encoding;
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            inputStreamReader = new InputStreamReader(fStream, it);
        } else {
            inputStreamReader = new InputStreamReader(fStream);
        }
        reader = inputStreamReader;
        StringWriter writer = new StringWriter();
        char[] buffer = new char[2048];
        int n = 0;
        while (true) {
            int n2 = reader.read(buffer);
            boolean bl = false;
            boolean bl4 = false;
            int it = n2;
            boolean bl5 = false;
            n = it;
            if (n2 == -1) break;
            writer.write(buffer, 0, n);
        }
        writer.flush();
        fStream.close();
        return writer.toString();
    }

    @Nullable
    public final String assetToString(@NotNull Context context, @NotNull String file) {
        InputStream inputStream;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        AssetManager assetManager = context.getAssets();
        if (assetManager == null) {
            return null;
        }
        AssetManager assetManager2 = assetManager;
        try {
            InputStream inputStream2 = assetManager2.open(file);
            if (inputStream2 == null) {
                return null;
            }
            inputStream = inputStream2;
        }
        catch (IOException e) {
            Logger.INSTANCE.warn("failed to find asset file [" + file + "]: " + e, new Object[0]);
            return null;
        }
        InputStream inputStream3 = inputStream;
        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream3, (String)"try {\n            assetM\u2026    return null\n        }");
        InputStream fStream = inputStream3;
        return this.fileToString(fStream, this.detectFileEncoding(context, file));
    }

    @Nullable
    public final String rawToString(@NotNull Context context, int rawId) {
        InputStream inputStream;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (rawId <= 0) {
            Logger.INSTANCE.warn("invalid resource id: " + rawId, new Object[0]);
            return null;
        }
        Resources resources = context.getResources();
        if (resources == null) {
            return null;
        }
        Resources res = resources;
        try {
            inputStream = res.openRawResource(rawId);
        }
        catch (Resources.NotFoundException e) {
            Logger.INSTANCE.warn("failed to find raw file [" + rawId + "]: " + (Object)((Object)e), new Object[0]);
            return null;
        }
        InputStream inputStream2 = inputStream;
        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream2, (String)"try {\n            res.op\u2026    return null\n        }");
        InputStream fStream = inputStream2;
        return this.fileToString(fStream, this.detectFileEncoding(context, rawId));
    }

    private FileUtils() {
    }

    static {
        FileUtils fileUtils;
        INSTANCE = fileUtils = new FileUtils();
    }
}

