/*
 * Decompiled with CFR 0.152.
 */
package com.dailystudio.devbricksx.repository;

import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.paging.LivePagedListBuilder;
import androidx.paging.PagedList;
import com.dailystudio.devbricksx.inmemory.InMemoryObject;
import com.dailystudio.devbricksx.inmemory.InMemoryObjectManager;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0016\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u0002*\u000e\b\u0001\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00010\u00042\u00020\u0005B!\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0018J\u0013\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0018J\u0014\u0010\u0019\u001a\u00020\u00162\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00010\rJ\u0013\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0018J\u0014\u0010\u001b\u001a\u00020\u00162\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00010\rJ\u0013\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0018J\u0014\u0010\u001c\u001a\u00020\u00162\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00010\rR\u001d\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00110\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR \u0010\u0013\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00070\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/dailystudio/devbricksx/repository/ObjectRepository;", "Key", "", "Object", "Lcom/dailystudio/devbricksx/inmemory/InMemoryObject;", "", "manager", "Lcom/dailystudio/devbricksx/inmemory/InMemoryObjectManager;", "pageSize", "", "(Lcom/dailystudio/devbricksx/inmemory/InMemoryObjectManager;I)V", "allObjects", "Landroidx/lifecycle/LiveData;", "", "getAllObjects", "()Landroidx/lifecycle/LiveData;", "allObjectsPaged", "Landroidx/paging/PagedList;", "getAllObjectsPaged", "liveDataOfObjects", "Landroidx/lifecycle/MutableLiveData;", "delete", "", "object", "(Lcom/dailystudio/devbricksx/inmemory/InMemoryObject;)V", "insert", "objects", "insertOrUpdate", "update", "devbricksx_release"})
public class ObjectRepository<Key extends Comparable<? super Key>, Object extends InMemoryObject<Key>> {
    private final MutableLiveData<InMemoryObjectManager<Key, Object>> liveDataOfObjects;
    @NotNull
    private final LiveData<List<Object>> allObjects;
    @NotNull
    private final LiveData<PagedList<Object>> allObjectsPaged;
    private final InMemoryObjectManager<Key, Object> manager;
    private final int pageSize;

    @NotNull
    public final LiveData<List<Object>> getAllObjects() {
        return this.allObjects;
    }

    @NotNull
    public final LiveData<PagedList<Object>> getAllObjectsPaged() {
        return this.allObjectsPaged;
    }

    public final void insert(@NotNull Object object) {
        Intrinsics.checkParameterIsNotNull(object, (String)"object");
        this.manager.add(object);
    }

    public final void insert(@NotNull List<? extends Object> objects) {
        Intrinsics.checkParameterIsNotNull(objects, (String)"objects");
        this.manager.addAll(objects);
    }

    public final void update(@NotNull Object object) {
        Intrinsics.checkParameterIsNotNull(object, (String)"object");
        this.insert(object);
    }

    public final void update(@NotNull List<? extends Object> objects) {
        Intrinsics.checkParameterIsNotNull(objects, (String)"objects");
        this.insert(objects);
    }

    public final void insertOrUpdate(@NotNull Object object) {
        Intrinsics.checkParameterIsNotNull(object, (String)"object");
        this.insert(object);
    }

    public final void insertOrUpdate(@NotNull List<? extends Object> objects) {
        Intrinsics.checkParameterIsNotNull(objects, (String)"objects");
        this.insert(objects);
    }

    public final void delete(@NotNull Object object) {
        Intrinsics.checkParameterIsNotNull(object, (String)"object");
        this.manager.remove(object);
    }

    public ObjectRepository(@NotNull InMemoryObjectManager<Key, Object> manager, int pageSize) {
        Intrinsics.checkParameterIsNotNull(manager, (String)"manager");
        this.manager = manager;
        this.pageSize = pageSize;
        this.liveDataOfObjects = new MutableLiveData(this.manager);
        this.allObjects = this.manager.toLiveData();
        LiveData liveData = new LivePagedListBuilder(this.manager.toDataSource(), this.pageSize).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)liveData, (String)"LivePagedListBuilder(man\u2026urce(), pageSize).build()");
        this.allObjectsPaged = liveData;
    }
}

