/*
 * Decompiled with CFR 0.152.
 */
package com.dailystudio.devbricksx.database;

import androidx.lifecycle.LiveData;
import androidx.lifecycle.Transformations;
import androidx.paging.DataSource;
import androidx.paging.LivePagedListBuilder;
import androidx.paging.PagedList;
import androidx.room.Dao;
import androidx.room.Delete;
import androidx.room.Insert;
import androidx.room.Query;
import androidx.room.Transaction;
import androidx.room.Update;
import com.dailystudio.devbricksx.database.Record;
import com.dailystudio.devbricksx.database._Record;
import java.util.ArrayList;
import java.util.List;

@Dao
public abstract class RecordDao {
    @Query(value="SELECT * FROM `record`")
    public abstract List<_Record> _getAll();

    @Query(value="SELECT * FROM `record`")
    public abstract LiveData<List<_Record>> _getAllLive();

    @Query(value="SELECT * FROM `record`")
    public abstract DataSource.Factory<Integer, _Record> _getAllDataSource();

    @Insert(onConflict=5)
    public abstract Long _insert(_Record var1);

    @Insert(onConflict=5)
    public abstract List<Long> _insert(List<_Record> var1);

    @Update
    public abstract void _update(_Record var1);

    @Update
    public abstract void _update(List<_Record> var1);

    @Transaction
    public void _insertOrUpdate(_Record companion) {
        long id2 = this._insert(companion);
        if (id2 == -1L) {
            this._update(companion);
        }
    }

    @Transaction
    public void _insertOrUpdate(List<_Record> companions) {
        int i;
        List<Long> insertResults = this._insert(companions);
        if (insertResults == null) {
            return;
        }
        ArrayList<_Record> updateList = new ArrayList<_Record>();
        for (i = 0; i < insertResults.size(); ++i) {
            if (insertResults.get(i) != -1L) continue;
            updateList.add(companions.get(i));
        }
        if (updateList.size() > 0) {
            for (i = 0; i < updateList.size(); ++i) {
                this._update((_Record)updateList.get(i));
            }
        }
    }

    @Delete
    public abstract void _delete(_Record var1);

    public List<Record> getAll() {
        List<_Record> companions = this._getAll();
        if (companions == null) {
            return null;
        }
        ArrayList<Record> objects = new ArrayList<Record>();
        for (int i = 0; i < companions.size(); ++i) {
            objects.add(companions.get(i).toObject());
        }
        return objects;
    }

    public LiveData<List<Record>> getAllLive() {
        LiveData<List<_Record>> liveCompanions = this._getAllLive();
        if (liveCompanions == null) {
            return null;
        }
        LiveData liveObjects = Transformations.map(liveCompanions, _Record.mapCompanionsToObjects);
        return liveObjects;
    }

    public LiveData<PagedList<Record>> getAllLivePaged() {
        DataSource.Factory<Integer, _Record> companionsFactory = this._getAllDataSource();
        if (companionsFactory == null) {
            return null;
        }
        DataSource.Factory objectsFactory = companionsFactory.map(_Record.mapCompanionToObject);
        LiveData liveData = new LivePagedListBuilder(objectsFactory, 10).build();
        return liveData;
    }

    public Long insert(Record object) {
        if (object == null) {
            return -1L;
        }
        _Record companion = _Record.fromObject(object);
        return this._insert(companion);
    }

    public List<Long> insert(List<Record> objects) {
        if (objects == null) {
            return null;
        }
        ArrayList<_Record> companions = new ArrayList<_Record>();
        for (int i = 0; i < objects.size(); ++i) {
            companions.add(_Record.fromObject(objects.get(i)));
        }
        return this._insert(companions);
    }

    public void update(Record object) {
        if (object == null) {
            return;
        }
        _Record companion = _Record.fromObject(object);
        this._update(companion);
    }

    public void update(List<Record> objects) {
        if (objects == null) {
            return;
        }
        ArrayList<_Record> companions = new ArrayList<_Record>();
        for (int i = 0; i < objects.size(); ++i) {
            companions.add(_Record.fromObject(objects.get(i)));
        }
        this._update(companions);
    }

    public void insertOrUpdate(Record object) {
        if (object == null) {
            return;
        }
        _Record companion = _Record.fromObject(object);
        this._insertOrUpdate(companion);
    }

    public void insertOrUpdate(List<Record> objects) {
        if (objects == null) {
            return;
        }
        ArrayList<_Record> companions = new ArrayList<_Record>();
        for (int i = 0; i < objects.size(); ++i) {
            companions.add(_Record.fromObject(objects.get(i)));
        }
        this._insertOrUpdate(companions);
    }

    public void delete(Record object) {
        if (object == null) {
            return;
        }
        _Record companion = _Record.fromObject(object);
        this._delete(companion);
    }
}

