/*
 * Decompiled with CFR 0.152.
 */
package com.dailystudio.devbricksx.camera;

import android.content.Context;
import android.hardware.display.DisplayManager;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.camera.core.Camera;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.CameraInfoUnavailableException;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.ImageAnalysis;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.Preview;
import androidx.camera.core.UseCase;
import androidx.camera.lifecycle.ProcessCameraProvider;
import androidx.camera.view.PreviewView;
import androidx.core.content.ContextCompat;
import androidx.lifecycle.LifecycleOwner;
import com.dailystudio.devbricksx.camera.CameraFragment;
import com.dailystudio.devbricksx.camera.R;
import com.dailystudio.devbricksx.development.Logger;
import com.dailystudio.devbricksx.fragment.AbsPermissionsFragment;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0081\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0006*\u0001\f\b\u0016\u0018\u0000 E2\u00020\u0001:\u0001EB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020\nH\u0002J\u001e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020\nH\u0014J\b\u0010$\u001a\u00020\nH\u0014J\b\u0010%\u001a\u00020\nH\u0014J\b\u0010&\u001a\u00020\nH\u0016J\b\u0010'\u001a\u00020\nH\u0014J\u0013\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)H\u0016\u00a2\u0006\u0002\u0010+J\b\u0010,\u001a\u00020-H\u0002J\b\u0010.\u001a\u00020-H\u0002J&\u0010/\u001a\u0004\u0018\u0001002\u0006\u00101\u001a\u0002022\b\u00103\u001a\u0004\u0018\u0001042\b\u00105\u001a\u0004\u0018\u000106H\u0016J\b\u00107\u001a\u000208H\u0016J\b\u00109\u001a\u000208H\u0016J\u0010\u0010:\u001a\u0002082\u0006\u0010;\u001a\u00020-H\u0016J\u001a\u0010<\u001a\u0002082\u0006\u0010=\u001a\u0002002\b\u00105\u001a\u0004\u0018\u000106H\u0016J\u0016\u0010>\u001a\u0002082\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u001d0@H\u0014J\b\u0010A\u001a\u000208H\u0002J\b\u0010B\u001a\u000208H\u0002J\b\u0010C\u001a\u000208H\u0002J\u001e\u0010D\u001a\u0002082\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0@2\u0006\u0010#\u001a\u00020\nH\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u001b\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0014\u001a\u00020\nX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lcom/dailystudio/devbricksx/camera/CameraFragment;", "Lcom/dailystudio/devbricksx/fragment/AbsPermissionsFragment;", "()V", "camera", "Landroidx/camera/core/Camera;", "cameraProvider", "Landroidx/camera/lifecycle/ProcessCameraProvider;", "cameraSelectorView", "Landroid/widget/ImageView;", "displayId", "", "displayListener", "com/dailystudio/devbricksx/camera/CameraFragment$displayListener$1", "Lcom/dailystudio/devbricksx/camera/CameraFragment$displayListener$1;", "displayManager", "Landroid/hardware/display/DisplayManager;", "getDisplayManager", "()Landroid/hardware/display/DisplayManager;", "displayManager$delegate", "Lkotlin/Lazy;", "lensFacing", "getLensFacing", "()I", "setLensFacing", "(I)V", "previewView", "Landroidx/camera/view/PreviewView;", "useCases", "", "Landroidx/camera/core/UseCase;", "aspectRatio", "width", "height", "buildUseCases", "screenAspectRatio", "rotation", "getCameraSelectorResId", "getLayoutResId", "getPermissionsPromptViewId", "getPreviewResId", "getRequiredPermissions", "", "", "()[Ljava/lang/String;", "hasBackCamera", "", "hasFrontCamera", "onCreateView", "Landroid/view/View;", "inflater", "Landroid/view/LayoutInflater;", "container", "Landroid/view/ViewGroup;", "savedInstanceState", "Landroid/os/Bundle;", "onDestroy", "", "onPermissionsDenied", "onPermissionsGranted", "newlyGranted", "onViewCreated", "view", "postConfigurationOfUseCases", "boundCases", "", "setupCamera", "setupUseCases", "updateCameraSelector", "updateUseCasesRotation", "Companion", "devbricksx-camera_release"})
public class CameraFragment
extends AbsPermissionsFragment {
    private Camera camera;
    private ProcessCameraProvider cameraProvider;
    private PreviewView previewView;
    private ImageView cameraSelectorView;
    private int displayId = -1;
    private int lensFacing = 1;
    private final List<UseCase> useCases;
    private final displayListener.1 displayListener;
    private final Lazy displayManager$delegate;
    @NotNull
    private static final String[] PERMISSIONS_REQUIRED;
    private static final double RATIO_4_3_VALUE = 1.3333333333333333;
    private static final double RATIO_16_9_VALUE = 1.7777777777777777;
    public static final Companion Companion;
    private HashMap _$_findViewCache;

    protected final int getLensFacing() {
        return this.lensFacing;
    }

    protected final void setLensFacing(int n) {
        this.lensFacing = n;
    }

    private final DisplayManager getDisplayManager() {
        Lazy lazy = this.displayManager$delegate;
        CameraFragment cameraFragment = this;
        Object var3_3 = null;
        boolean bl = false;
        return (DisplayManager)lazy.getValue();
    }

    @Nullable
    public View onCreateView(@NotNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkParameterIsNotNull((Object)inflater, (String)"inflater");
        return inflater.inflate(this.getLayoutResId(), container, false);
    }

    public void onViewCreated(@NotNull View view, @Nullable Bundle savedInstanceState) {
        block1: {
            PreviewView it;
            boolean bl;
            boolean bl2;
            PreviewView previewView;
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
            super.onViewCreated(view, savedInstanceState);
            this.getDisplayManager().registerDisplayListener((DisplayManager.DisplayListener)this.displayListener, null);
            PreviewView previewView2 = this.previewView = (PreviewView)view.findViewById(this.getPreviewResId());
            if (previewView2 != null) {
                previewView = previewView2;
                bl2 = false;
                bl = false;
                it = previewView;
                boolean bl3 = false;
                it.post(new Runnable(it, this){
                    final /* synthetic */ PreviewView $it;
                    final /* synthetic */ CameraFragment this$0;
                    {
                        this.$it = previewView;
                        this.this$0 = cameraFragment;
                    }

                    public final void run() {
                        Display display = this.$it.getDisplay();
                        Intrinsics.checkExpressionValueIsNotNull((Object)display, (String)"it.display");
                        CameraFragment.access$setDisplayId$p(this.this$0, display.getDisplayId());
                    }
                });
            }
            ImageView imageView = this.cameraSelectorView = (ImageView)view.findViewById(this.getCameraSelectorResId());
            if (imageView == null) break block1;
            previewView = imageView;
            bl2 = false;
            bl = false;
            it = previewView;
            boolean bl4 = false;
            it.setEnabled(false);
            it.setOnClickListener(new View.OnClickListener(this){
                final /* synthetic */ CameraFragment this$0;
                {
                    this.this$0 = cameraFragment;
                }

                public final void onClick(View it) {
                    this.this$0.setLensFacing(this.this$0.getLensFacing() == 0 ? 1 : 0);
                    Logger.INSTANCE.debug("current lens facing: " + this.this$0.getLensFacing(), new Object[0]);
                    CameraFragment.access$setupUseCases(this.this$0);
                }
            });
        }
    }

    public void onDestroy() {
        super.onDestroy();
        this.getDisplayManager().unregisterDisplayListener((DisplayManager.DisplayListener)this.displayListener);
    }

    private final void setupCamera() {
        Context context = this.getContext();
        if (context == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context ?: return");
        Context context2 = context;
        ListenableFuture listenableFuture = ProcessCameraProvider.getInstance((Context)context2);
        Intrinsics.checkExpressionValueIsNotNull((Object)listenableFuture, (String)"ProcessCameraProvider.getInstance(context)");
        ListenableFuture cameraProviderFuture = listenableFuture;
        cameraProviderFuture.addListener(new Runnable(this, cameraProviderFuture){
            final /* synthetic */ CameraFragment this$0;
            final /* synthetic */ ListenableFuture $cameraProviderFuture;

            public final void run() {
                int n;
                CameraFragment.access$setCameraProvider$p(this.this$0, (ProcessCameraProvider)this.$cameraProviderFuture.get());
                if (CameraFragment.access$hasBackCamera(this.this$0)) {
                    n = 1;
                } else if (CameraFragment.access$hasFrontCamera(this.this$0)) {
                    n = 0;
                } else {
                    throw (Throwable)new IllegalStateException("Back and front camera are unavailable");
                }
                this.this$0.setLensFacing(n);
                CameraFragment.access$updateCameraSelector(this.this$0);
                CameraFragment.access$setupUseCases(this.this$0);
            }
            {
                this.this$0 = cameraFragment;
                this.$cameraProviderFuture = listenableFuture;
            }
        }, ContextCompat.getMainExecutor((Context)context2));
    }

    private final void setupUseCases() {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        boolean bl = false;
        boolean bl2 = false;
        DisplayMetrics it = displayMetrics;
        boolean bl3 = false;
        PreviewView previewView = this.previewView;
        if (previewView != null && (previewView = previewView.getDisplay()) != null) {
            previewView.getRealMetrics(it);
        }
        DisplayMetrics metrics = displayMetrics;
        int screenAspectRatio = this.aspectRatio(metrics.widthPixels, metrics.heightPixels);
        PreviewView previewView2 = this.previewView;
        int rotation = previewView2 != null && (previewView2 = previewView2.getDisplay()) != null ? previewView2.getRotation() : 0;
        CameraSelector cameraSelector = new CameraSelector.Builder().requireLensFacing(this.lensFacing).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)cameraSelector, (String)"CameraSelector.Builder()\u2026acing(lensFacing).build()");
        CameraSelector cameraSelector2 = cameraSelector;
        try {
            ProcessCameraProvider processCameraProvider = this.cameraProvider;
            if (processCameraProvider != null) {
                processCameraProvider.unbindAll();
            }
            List<UseCase> cases = this.buildUseCases(screenAspectRatio, rotation);
            for (UseCase useCase : cases) {
                ProcessCameraProvider processCameraProvider2 = this.cameraProvider;
                this.camera = processCameraProvider2 != null ? processCameraProvider2.bindToLifecycle((LifecycleOwner)this, cameraSelector2, new UseCase[]{useCase}) : null;
            }
            this.postConfigurationOfUseCases(cases);
        }
        catch (Exception exc) {
            Logger.INSTANCE.error("Use case binding failed", new Object[]{exc});
        }
    }

    public void onPermissionsGranted(boolean newlyGranted) {
        this.setupCamera();
    }

    public void onPermissionsDenied() {
    }

    public int getPermissionsPromptViewId() {
        return R.id.permission_prompt;
    }

    @NotNull
    public String[] getRequiredPermissions() {
        return PERMISSIONS_REQUIRED;
    }

    @NotNull
    protected List<UseCase> buildUseCases(int screenAspectRatio, int rotation) {
        Preview preview = new Preview.Builder().setTargetAspectRatio(screenAspectRatio).setTargetRotation(rotation).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)preview, (String)"Preview.Builder()\n      \u2026\n                .build()");
        Preview preview2 = preview;
        return CollectionsKt.mutableListOf((Object[])new UseCase[]{(UseCase)preview2});
    }

    protected void postConfigurationOfUseCases(@NotNull List<? extends UseCase> boundCases) {
        Intrinsics.checkParameterIsNotNull(boundCases, (String)"boundCases");
        for (UseCase useCase : boundCases) {
            PreviewView previewView;
            PreviewView previewView2;
            UseCase useCase2 = useCase;
            if (!(useCase2 instanceof Preview)) continue;
            View view = this.getView();
            PreviewView previewView3 = previewView2 = view != null ? (PreviewView)view.findViewById(this.getPreviewResId()) : null;
            if (previewView2 == null) continue;
            boolean bl = false;
            boolean bl2 = false;
            PreviewView it = previewView;
            boolean bl3 = false;
            Camera camera = this.camera;
            ((Preview)useCase).setSurfaceProvider(it.createSurfaceProvider((CameraInfo)(camera != null ? camera.getCameraInfo() : null)));
        }
    }

    private final void updateCameraSelector() {
        block6: {
            ImageView imageView = this.cameraSelectorView;
            if (imageView == null) break block6;
            ImageView imageView2 = imageView;
            boolean bl = false;
            boolean bl2 = false;
            ImageView it = imageView2;
            boolean bl3 = false;
            try {
                it.setEnabled(this.hasBackCamera() && this.hasFrontCamera());
                switch (this.lensFacing) {
                    case 1: {
                        it.setImageResource(R.drawable.ic_front_camera);
                        break;
                    }
                    case 0: {
                        it.setImageResource(R.drawable.ic_back_camera);
                    }
                }
            }
            catch (CameraInfoUnavailableException exception) {
                it.setEnabled(false);
            }
        }
    }

    private final void updateUseCasesRotation(List<? extends UseCase> useCases, int rotation) {
        for (UseCase useCase : useCases) {
            UseCase useCase2 = useCase;
            if (useCase2 instanceof ImageAnalysis) {
                ((ImageAnalysis)useCase).setTargetRotation(rotation);
                continue;
            }
            if (!(useCase2 instanceof ImageCapture)) continue;
            ((ImageCapture)useCase).setTargetRotation(rotation);
        }
    }

    protected int getLayoutResId() {
        return R.layout.fragment_camera;
    }

    protected int getPreviewResId() {
        return R.id.camera_preview;
    }

    protected int getCameraSelectorResId() {
        return R.id.camera_len_selector;
    }

    private final boolean hasBackCamera() {
        ProcessCameraProvider processCameraProvider = this.cameraProvider;
        return processCameraProvider != null ? processCameraProvider.hasCamera(CameraSelector.DEFAULT_BACK_CAMERA) : false;
    }

    private final boolean hasFrontCamera() {
        ProcessCameraProvider processCameraProvider = this.cameraProvider;
        return processCameraProvider != null ? processCameraProvider.hasCamera(CameraSelector.DEFAULT_FRONT_CAMERA) : false;
    }

    private final int aspectRatio(int width, int height) {
        boolean bl = false;
        double d = Math.max(width, height);
        bl = false;
        int n = Math.min(width, height);
        double previewRatio = d / (double)n;
        double d2 = previewRatio - 1.3333333333333333;
        boolean bl2 = false;
        double d3 = Math.abs(d2);
        d2 = previewRatio - 1.7777777777777777;
        d = d3;
        bl2 = false;
        double d4 = Math.abs(d2);
        if (d <= d4) {
            return 0;
        }
        return 1;
    }

    public CameraFragment() {
        List list;
        CameraFragment cameraFragment = this;
        boolean bl = false;
        cameraFragment.useCases = list = (List)new ArrayList();
        this.displayListener = new DisplayManager.DisplayListener(this){
            final /* synthetic */ CameraFragment this$0;

            public void onDisplayAdded(int displayId) {
            }

            public void onDisplayRemoved(int displayId) {
            }

            public void onDisplayChanged(int displayId) {
                block1: {
                    View view = this.this$0.getView();
                    if (view == null) break block1;
                    View view2 = view;
                    boolean bl = false;
                    boolean bl2 = false;
                    View view3 = view2;
                    boolean bl3 = false;
                    if (displayId == CameraFragment.access$getDisplayId$p(this.this$0)) {
                        StringBuilder stringBuilder = new StringBuilder().append("Rotation changed: ");
                        View view4 = view3;
                        Intrinsics.checkExpressionValueIsNotNull((Object)view4, (String)"view");
                        Display display = view4.getDisplay();
                        Intrinsics.checkExpressionValueIsNotNull((Object)display, (String)"view.display");
                        Logger.INSTANCE.debug(stringBuilder.append(display.getRotation()).toString(), new Object[0]);
                        List list = CameraFragment.access$getUseCases$p(this.this$0);
                        Display display2 = view3.getDisplay();
                        Intrinsics.checkExpressionValueIsNotNull((Object)display2, (String)"view.display");
                        CameraFragment.access$updateUseCasesRotation(this.this$0, list, display2.getRotation());
                    }
                }
            }
            {
                this.this$0 = $outer;
            }
        };
        this.displayManager$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DisplayManager>(this){
            final /* synthetic */ CameraFragment this$0;

            @NotNull
            public final DisplayManager invoke() {
                Object object = this.this$0.requireContext().getSystemService("display");
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type android.hardware.display.DisplayManager");
                }
                return (DisplayManager)object;
            }
            {
                this.this$0 = cameraFragment;
                super(0);
            }
        }));
    }

    static {
        Companion = new Companion(null);
        PERMISSIONS_REQUIRED = new String[]{"android.permission.CAMERA"};
    }

    public static final /* synthetic */ int access$getDisplayId$p(CameraFragment $this) {
        return $this.displayId;
    }

    public static final /* synthetic */ void access$setDisplayId$p(CameraFragment $this, int n) {
        $this.displayId = n;
    }

    public static final /* synthetic */ void access$setupUseCases(CameraFragment $this) {
        $this.setupUseCases();
    }

    public static final /* synthetic */ ProcessCameraProvider access$getCameraProvider$p(CameraFragment $this) {
        return $this.cameraProvider;
    }

    public static final /* synthetic */ void access$setCameraProvider$p(CameraFragment $this, ProcessCameraProvider processCameraProvider) {
        $this.cameraProvider = processCameraProvider;
    }

    public static final /* synthetic */ boolean access$hasBackCamera(CameraFragment $this) {
        return $this.hasBackCamera();
    }

    public static final /* synthetic */ boolean access$hasFrontCamera(CameraFragment $this) {
        return $this.hasFrontCamera();
    }

    public static final /* synthetic */ void access$updateCameraSelector(CameraFragment $this) {
        $this.updateCameraSelector();
    }

    public static final /* synthetic */ void access$updateUseCasesRotation(CameraFragment $this, List useCases, int rotation) {
        $this.updateUseCasesRotation(useCases, rotation);
    }

    public static final /* synthetic */ List access$getUseCases$p(CameraFragment $this) {
        return $this.useCases;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            View view2 = this.getView();
            if (view2 == null) {
                return null;
            }
            view = view2.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    public /* synthetic */ void onDestroyView() {
        super.onDestroyView();
        this._$_clearFindViewByIdCache();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/dailystudio/devbricksx/camera/CameraFragment$Companion;", "", "()V", "PERMISSIONS_REQUIRED", "", "", "getPERMISSIONS_REQUIRED", "()[Ljava/lang/String;", "[Ljava/lang/String;", "RATIO_16_9_VALUE", "", "RATIO_4_3_VALUE", "devbricksx-camera_release"})
    public static final class Companion {
        @NotNull
        public final String[] getPERMISSIONS_REQUIRED() {
            return PERMISSIONS_REQUIRED;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

