/*
 * Decompiled with CFR 0.152.
 */
package com.dailystudio.devbricksx.audio;

import android.content.Context;
import android.media.MediaRecorder;
import android.os.Bundle;
import android.os.Environment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.dailystudio.devbricksx.audio.AbsAudioFragment;
import com.dailystudio.devbricksx.audio.R;
import com.dailystudio.devbricksx.development.Logger;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\b\u0016\u0018\u0000  2\u00020\u0001:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0014J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J&\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0016J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u001a\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0010\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u0004H\u0002J\b\u0010\u001e\u001a\u00020\u0015H\u0004J\b\u0010\u001f\u001a\u00020\u0015H\u0004R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/dailystudio/devbricksx/audio/AudioRecordFragment;", "Lcom/dailystudio/devbricksx/audio/AbsAudioFragment;", "()V", "recordButton", "Landroid/view/View;", "recorder", "Landroid/media/MediaRecorder;", "getMediaFileName", "", "getOutputDirectory", "Ljava/io/File;", "context", "Landroid/content/Context;", "onCreateView", "inflater", "Landroid/view/LayoutInflater;", "container", "Landroid/view/ViewGroup;", "savedInstanceState", "Landroid/os/Bundle;", "onPause", "", "onPermissionsDenied", "onPermissionsGranted", "newlyGranted", "", "onViewCreated", "view", "setupViews", "fragmentView", "startRecording", "stopRecording", "Companion", "devbricksx-audio_release"})
public class AudioRecordFragment
extends AbsAudioFragment {
    private View recordButton;
    private MediaRecorder recorder;
    private static final String DEFAULT_RECORDED_FILENAME_FORMAT = "yyyy-MM-dd-HH-mm-ss-SSS";
    public static final Companion Companion = new Companion(null);
    private HashMap _$_findViewCache;

    @Nullable
    public View onCreateView(@NotNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)inflater, (String)"inflater");
        return inflater.inflate(R.layout.fragment_recorder, container, false);
    }

    public void onViewCreated(@NotNull View view, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        super.onViewCreated(view, savedInstanceState);
        this.setupViews(view);
    }

    private final void setupViews(View fragmentView) {
        block0: {
            View view = this.recordButton = fragmentView.findViewById(R.id.record_button);
            if (view == null) break block0;
            view.setOnClickListener(new View.OnClickListener(this){
                final /* synthetic */ AudioRecordFragment this$0;

                public final void onClick(View view) {
                    this.this$0.startRecording();
                }
                {
                    this.this$0 = audioRecordFragment;
                }
            });
        }
    }

    public void onPause() {
        super.onPause();
        this.stopRecording();
    }

    /*
     * WARNING - void declaration
     */
    protected final void startRecording() {
        void $this$apply;
        MediaRecorder mediaRecorder = new MediaRecorder();
        boolean bl = false;
        boolean bl2 = false;
        MediaRecorder mediaRecorder2 = mediaRecorder;
        AudioRecordFragment audioRecordFragment = this;
        boolean bl3 = false;
        String fileName = this.getMediaFileName();
        $this$apply.setAudioSource(1);
        $this$apply.setOutputFormat(1);
        $this$apply.setOutputFile(fileName);
        $this$apply.setAudioEncoder(1);
        try {
            $this$apply.prepare();
        }
        catch (IOException e) {
            Logger.INSTANCE.error("recorder prepare() failed: " + e, new Object[0]);
        }
        $this$apply.start();
        Logger.INSTANCE.info("recording audio into file: [" + fileName + ']', new Object[0]);
        Unit unit = Unit.INSTANCE;
        audioRecordFragment.recorder = mediaRecorder;
    }

    protected final void stopRecording() {
        MediaRecorder mediaRecorder = this.recorder;
        if (mediaRecorder != null) {
            MediaRecorder mediaRecorder2 = mediaRecorder;
            boolean bl = false;
            boolean bl2 = false;
            MediaRecorder $this$apply = mediaRecorder2;
            boolean bl3 = false;
            $this$apply.stop();
            $this$apply.release();
        }
        this.recorder = null;
    }

    @NotNull
    protected String getMediaFileName() {
        Context context = this.requireContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"requireContext()");
        File outputDirectory = this.getOutputDirectory(context);
        String string = new File(outputDirectory, new SimpleDateFormat(DEFAULT_RECORDED_FILENAME_FORMAT, Locale.US).format(System.currentTimeMillis()) + ".3gp").toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"File(outputDirectory,\n  \u2026s()) + \".3gp\").toString()");
        return string;
    }

    @Nullable
    protected File getOutputDirectory(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return context.getExternalFilesDir(Environment.DIRECTORY_PICTURES);
    }

    public void onPermissionsGranted(boolean newlyGranted) {
        block0: {
            View view = this.recordButton;
            if (view == null) break block0;
            view.setEnabled(true);
        }
    }

    @Override
    public void onPermissionsDenied() {
        block0: {
            super.onPermissionsDenied();
            View view = this.recordButton;
            if (view == null) break block0;
            view.setEnabled(false);
        }
    }

    @Override
    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            View view2 = this.getView();
            if (view2 == null) {
                return null;
            }
            view = view2.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    @Override
    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Override
    public /* synthetic */ void onDestroyView() {
        super.onDestroyView();
        this._$_clearFindViewByIdCache();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/dailystudio/devbricksx/audio/AudioRecordFragment$Companion;", "", "()V", "DEFAULT_RECORDED_FILENAME_FORMAT", "", "devbricksx-audio_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

