/*
 * Decompiled with CFR 0.152.
 */
package com.dailystudio.devbricksx.audio;

import android.media.AudioRecord;
import android.os.Bundle;
import android.os.Process;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LifecycleOwnerKt;
import com.dailystudio.devbricksx.async.ManagedThread;
import com.dailystudio.devbricksx.audio.AbsAudioFragment;
import com.dailystudio.devbricksx.audio.AudioConfig;
import com.dailystudio.devbricksx.audio.AudioProcessFragment;
import com.dailystudio.devbricksx.audio.R;
import com.dailystudio.devbricksx.audio.visualizer.RawAudioDataVisualizer;
import com.dailystudio.devbricksx.development.Logger;
import java.util.HashMap;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0017\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f*\u0002\u0004\u000f\b&\u0018\u0000 )2\u00020\u0001:\u0001)B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0014J&\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u0007H\u0016J\u0018\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u00142\u0006\u0010#\u001a\u00020\tH&J\b\u0010$\u001a\u00020\u001eH\u0016J\u001a\u0010%\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\u00162\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\b\u0010'\u001a\u00020\u001eH\u0002J\b\u0010(\u001a\u00020\u001eH\u0002R\u0010\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/dailystudio/devbricksx/audio/AudioProcessFragment;", "Lcom/dailystudio/devbricksx/audio/AbsAudioFragment;", "()V", "processThread", "com/dailystudio/devbricksx/audio/AudioProcessFragment$processThread$1", "Lcom/dailystudio/devbricksx/audio/AudioProcessFragment$processThread$1;", "processingStarted", "", "recordingBuffer", "", "recordingBufferLock", "Ljava/util/concurrent/locks/ReentrantLock;", "recordingOffset", "", "recordingThread", "com/dailystudio/devbricksx/audio/AudioProcessFragment$recordingThread$1", "Lcom/dailystudio/devbricksx/audio/AudioProcessFragment$recordingThread$1;", "visualizer", "Lcom/dailystudio/devbricksx/audio/visualizer/RawAudioDataVisualizer;", "getAudioConfig", "Lcom/dailystudio/devbricksx/audio/AudioConfig;", "onCreateView", "Landroid/view/View;", "inflater", "Landroid/view/LayoutInflater;", "container", "Landroid/view/ViewGroup;", "savedInstanceState", "Landroid/os/Bundle;", "onPause", "", "onPermissionsGranted", "newlyGranted", "onProcessAudioData", "audioConfig", "audioData", "onResume", "onViewCreated", "view", "startProcessing", "stopProcessing", "Companion", "devbricksx-audio_release"})
public abstract class AudioProcessFragment
extends AbsAudioFragment {
    private short[] recordingBuffer;
    private int recordingOffset;
    private final ReentrantLock recordingBufferLock = new ReentrantLock();
    private boolean processingStarted;
    private RawAudioDataVisualizer visualizer;
    private recordingThread.1 recordingThread = new ManagedThread(this){
        final /* synthetic */ AudioProcessFragment this$0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runInBackground() {
            Process.setThreadPriority((int)-16);
            AudioConfig audioConfig = this.this$0.getAudioConfig();
            int bufferSize = AudioRecord.getMinBufferSize((int)audioConfig.getSampleRate(), (int)audioConfig.getChannelConfig(), (int)audioConfig.getAudioFormat());
            if (bufferSize == -1 || bufferSize == -2) {
                bufferSize = audioConfig.getSampleRate() * 2;
            }
            short[] audioBuffer = new short[bufferSize / 2];
            AudioRecord record = new AudioRecord(audioConfig.getAudioSource(), audioConfig.getSampleRate(), audioConfig.getChannelConfig(), audioConfig.getAudioFormat(), bufferSize);
            if (record.getState() != 1) {
                Logger.INSTANCE.error("audio record initialization failed: state = " + record.getState(), new Object[0]);
                return;
            }
            record.startRecording();
            while (this.isRunning()) {
                int numberRead = record.read(audioBuffer, 0, audioBuffer.length);
                int maxLength = AudioProcessFragment.access$getRecordingBuffer$p(this.this$0).length;
                int newRecordingOffset = AudioProcessFragment.access$getRecordingOffset$p(this.this$0) + numberRead;
                int n = 0;
                int n2 = newRecordingOffset - maxLength;
                boolean bl = false;
                int secondCopyLength = Math.max(n, n2);
                int firstCopyLength = numberRead - secondCopyLength;
                AudioProcessFragment.access$getRecordingBufferLock$p(this.this$0).lock();
                try {
                    System.arraycopy(audioBuffer, 0, AudioProcessFragment.access$getRecordingBuffer$p(this.this$0), AudioProcessFragment.access$getRecordingOffset$p(this.this$0), firstCopyLength);
                    System.arraycopy(audioBuffer, firstCopyLength, AudioProcessFragment.access$getRecordingBuffer$p(this.this$0), 0, secondCopyLength);
                    AudioProcessFragment.access$setRecordingOffset$p(this.this$0, newRecordingOffset % maxLength);
                }
                finally {
                    AudioProcessFragment.access$getRecordingBufferLock$p(this.this$0).unlock();
                }
            }
            Logger.INSTANCE.info("stop recording: record = " + record, new Object[0]);
            record.stop();
            record.release();
        }
        {
            this.this$0 = $outer;
        }
    };
    private processThread.1 processThread = new ManagedThread(this){
        final /* synthetic */ AudioProcessFragment this$0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runInBackground() {
            AudioConfig audioConfig = this.this$0.getAudioConfig();
            short[] inputBuffer = new short[audioConfig.getRecordingBufferLength()];
            while (this.isRunning()) {
                AudioProcessFragment.access$getRecordingBufferLock$p(this.this$0).lock();
                try {
                    int maxLength = AudioProcessFragment.access$getRecordingBuffer$p(this.this$0).length;
                    int firstCopyLength = maxLength - AudioProcessFragment.access$getRecordingOffset$p(this.this$0);
                    int secondCopyLength = AudioProcessFragment.access$getRecordingOffset$p(this.this$0);
                    System.arraycopy(AudioProcessFragment.access$getRecordingBuffer$p(this.this$0), AudioProcessFragment.access$getRecordingOffset$p(this.this$0), inputBuffer, 0, firstCopyLength);
                    System.arraycopy(AudioProcessFragment.access$getRecordingBuffer$p(this.this$0), 0, inputBuffer, firstCopyLength, secondCopyLength);
                }
                finally {
                    AudioProcessFragment.access$getRecordingBufferLock$p(this.this$0).unlock();
                }
                if (AudioProcessFragment.access$getVisualizer$p(this.this$0) != null) {
                    RawAudioDataVisualizer rawAudioDataVisualizer;
                    boolean bl = false;
                    boolean bl2 = false;
                    RawAudioDataVisualizer it = rawAudioDataVisualizer;
                    boolean bl3 = false;
                    BuildersKt.launch$default((CoroutineScope)((CoroutineScope)LifecycleOwnerKt.getLifecycleScope((LifecycleOwner)this.this$0)), (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(it, null, this, inputBuffer){
                        private CoroutineScope p$;
                        int label;
                        final /* synthetic */ RawAudioDataVisualizer $it;
                        final /* synthetic */ processThread.1 this$0;
                        final /* synthetic */ short[] $inputBuffer$inlined;
                        {
                            this.$it = rawAudioDataVisualizer;
                            this.this$0 = var3_3;
                            this.$inputBuffer$inlined = sArray;
                            super(2, continuation);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object $result) {
                            Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    CoroutineScope $this$launch = this.p$;
                                    this.$it.setAudioFrameData(this.$inputBuffer$inlined);
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                            Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                            Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                            CoroutineScope cfr_ignored_0 = (CoroutineScope)value;
                            function2.p$ = (CoroutineScope)value;
                            Function2<CoroutineScope, Continuation<? super Unit>, Object> function22 = function2;
                            return function22;
                        }

                        public final Object invoke(Object object, Object object2) {
                            return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)2, null);
                }
                this.this$0.onProcessAudioData(audioConfig, inputBuffer);
                try {
                    Thread.sleep(30L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        {
            this.this$0 = $outer;
        }
    };
    private static final int DEFAULT_SAMPLE_RATE = 16000;
    private static final int DEFAULT_SAMPLE_DURATION_MS = 1000;
    private static final long MINIMUM_TIME_BETWEEN_SAMPLES_MS = 30L;
    public static final Companion Companion = new Companion(null);
    private HashMap _$_findViewCache;

    @Nullable
    public View onCreateView(@NotNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkParameterIsNotNull((Object)inflater, (String)"inflater");
        return inflater.inflate(R.layout.fragment_audio_process, container, false);
    }

    public void onViewCreated(@NotNull View view, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        super.onViewCreated(view, savedInstanceState);
        this.visualizer = (RawAudioDataVisualizer)view.findViewById(R.id.visualizer);
    }

    public void onPermissionsGranted(boolean newlyGranted) {
        this.startProcessing();
    }

    public void onResume() {
        super.onResume();
        if (this.isPermissionsGranted()) {
            this.startProcessing();
        }
    }

    public void onPause() {
        super.onPause();
        this.stopProcessing();
    }

    @NotNull
    protected AudioConfig getAudioConfig() {
        return new AudioConfig(0, 16000, 1000, 16, 2);
    }

    private final void startProcessing() {
        if (this.processingStarted) {
            Logger.INSTANCE.warn("processing is already started. skip", new Object[0]);
            return;
        }
        AudioConfig audioConfig = this.getAudioConfig();
        this.recordingBufferLock.lock();
        this.recordingBuffer = new short[audioConfig.getRecordingBufferLength()];
        this.recordingOffset = 0;
        this.recordingBufferLock.unlock();
        this.recordingThread.start();
        this.processThread.start();
        this.processingStarted = true;
    }

    private final void stopProcessing() {
        if (!this.processingStarted) {
            Logger.INSTANCE.warn("processing is already stopped. skip", new Object[0]);
            return;
        }
        this.processingStarted = false;
        this.recordingThread.stop();
        this.processThread.stop();
    }

    public abstract void onProcessAudioData(@NotNull AudioConfig var1, @NotNull short[] var2);

    public static final /* synthetic */ short[] access$getRecordingBuffer$p(AudioProcessFragment $this) {
        if ($this.recordingBuffer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"recordingBuffer");
        }
        return $this.recordingBuffer;
    }

    public static final /* synthetic */ void access$setRecordingBuffer$p(AudioProcessFragment $this, short[] sArray) {
        $this.recordingBuffer = sArray;
    }

    public static final /* synthetic */ int access$getRecordingOffset$p(AudioProcessFragment $this) {
        return $this.recordingOffset;
    }

    public static final /* synthetic */ void access$setRecordingOffset$p(AudioProcessFragment $this, int n) {
        $this.recordingOffset = n;
    }

    public static final /* synthetic */ ReentrantLock access$getRecordingBufferLock$p(AudioProcessFragment $this) {
        return $this.recordingBufferLock;
    }

    public static final /* synthetic */ RawAudioDataVisualizer access$getVisualizer$p(AudioProcessFragment $this) {
        return $this.visualizer;
    }

    public static final /* synthetic */ void access$setVisualizer$p(AudioProcessFragment $this, RawAudioDataVisualizer rawAudioDataVisualizer) {
        $this.visualizer = rawAudioDataVisualizer;
    }

    @Override
    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            View view2 = this.getView();
            if (view2 == null) {
                return null;
            }
            view = view2.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    @Override
    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Override
    public /* synthetic */ void onDestroyView() {
        super.onDestroyView();
        this._$_clearFindViewByIdCache();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/dailystudio/devbricksx/audio/AudioProcessFragment$Companion;", "", "()V", "DEFAULT_SAMPLE_DURATION_MS", "", "DEFAULT_SAMPLE_RATE", "MINIMUM_TIME_BETWEEN_SAMPLES_MS", "", "devbricksx-audio_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

