/*
 * Decompiled with CFR 0.152.
 */
package com.dailystudio.devbricksx.audio.visualizer;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import com.dailystudio.devbricksx.audio.R;
import com.dailystudio.devbricksx.ui.AbsSurfaceView;
import com.dailystudio.devbricksx.utils.ResourcesCompatUtils;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0017\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B%\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB)\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u000e\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u000eR\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/dailystudio/devbricksx/audio/visualizer/RawAudioDataVisualizer;", "Lcom/dailystudio/devbricksx/ui/AbsSurfaceView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "defStyleRes", "(Landroid/content/Context;Landroid/util/AttributeSet;II)V", "barSpacingX", "barWidth", "frameData", "", "paint", "Landroid/graphics/Paint;", "drawingCanvas", "", "canvas", "Landroid/graphics/Canvas;", "setAudioFrameData", "data", "Companion", "devbricksx-audio_release"})
public final class RawAudioDataVisualizer
extends AbsSurfaceView {
    private short[] frameData;
    private int barWidth;
    private int barSpacingX;
    private Paint paint;
    public static final int DEFAULT_BAR_WIDTH = 25;
    public static final int DEFAULT_BAR_SPACING_X = 5;
    public static final int MAX_EFFECTIVE_AMP = 800;
    public static final int MIN_EFFECTIVE_AMP = 20;
    public static final Companion Companion = new Companion(null);
    private HashMap _$_findViewCache;

    public final void setAudioFrameData(@NotNull short[] data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        this.frameData = data;
    }

    /*
     * WARNING - void declaration
     */
    public void drawingCanvas(@NotNull Canvas canvas) {
        short[] sArray;
        int filterBufferSize2;
        int n;
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        int baseline = this.getHeight() / 2;
        float f = (float)this.getWidth() / (float)(this.barWidth + this.barSpacingX);
        boolean bl = false;
        int filteredCount = (int)Math.ceil(f);
        short[] rawData = this.frameData;
        if (rawData != null) {
            float f2 = (float)rawData.length / (float)filteredCount;
            n = 0;
            filterBufferSize2 = (int)Math.floor(f2);
            if (rawData.length % filteredCount != 0) {
                ++filteredCount;
            }
            short[] sArray2 = new short[filteredCount];
            n = 0;
            boolean bl2 = false;
            short[] $this$apply = sArray2;
            boolean bl3 = false;
            int average = 0;
            int count = 0;
            int n2 = 0;
            int n3 = rawData.length;
            while (n2 < n3) {
                void i;
                if (i != false && i % filterBufferSize2 == false) {
                    int newAverage = average / count;
                    boolean bl4 = false;
                    int filterAverage = Math.abs(newAverage) < 20 ? 1 : newAverage;
                    $this$apply[i / filterBufferSize2] = (short)filterAverage;
                    average = 0;
                    count = 0;
                } else {
                    average += rawData[i];
                    ++count;
                }
                ++i;
            }
            sArray = sArray2;
        } else {
            short[] filterBufferSize2 = new short[filteredCount];
            int n4 = 0;
            while (n4 < filteredCount) {
                short s;
                n = n4;
                int n5 = n4++;
                short[] sArray3 = filterBufferSize2;
                boolean bl5 = false;
                sArray3[n5] = s = 1;
            }
            sArray = filterBufferSize2;
        }
        short[] filtered = sArray;
        filterBufferSize2 = 0;
        int n6 = filtered.length;
        while (filterBufferSize2 < n6) {
            void i;
            short bit = filtered[i];
            int bW = this.barWidth + this.barSpacingX;
            float bH = (float)this.getHeight() * (float)bit / (float)800;
            float x = (float)i * (float)bW;
            canvas.drawLine(x, (float)baseline - bH / (float)2, x, (float)baseline + bH / (float)2, this.paint);
            ++i;
        }
    }

    @JvmOverloads
    public RawAudioDataVisualizer(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Paint paint;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.barWidth = 25;
        this.barSpacingX = 5;
        this.setFramesPerSecond(10);
        Paint paint2 = new Paint(1);
        RawAudioDataVisualizer rawAudioDataVisualizer = this;
        boolean bl = false;
        boolean bl2 = false;
        Paint $this$apply = paint2;
        boolean bl3 = false;
        Context context2 = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context");
        $this$apply.setColor(ResourcesCompatUtils.INSTANCE.getColor(context2, R.color.colorPrimary));
        $this$apply.setStrokeWidth((float)this.barWidth);
        rawAudioDataVisualizer.paint = paint = paint2;
    }

    public /* synthetic */ RawAudioDataVisualizer(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public RawAudioDataVisualizer(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public RawAudioDataVisualizer(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    @TargetApi(value=21)
    public RawAudioDataVisualizer(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        Paint paint;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr, defStyleRes);
        this.barWidth = 25;
        this.barSpacingX = 5;
        this.setFramesPerSecond(10);
        Paint paint2 = new Paint(1);
        RawAudioDataVisualizer rawAudioDataVisualizer = this;
        boolean bl = false;
        boolean bl2 = false;
        Paint $this$apply = paint2;
        boolean bl3 = false;
        Context context2 = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context");
        $this$apply.setColor(ResourcesCompatUtils.INSTANCE.getColor(context2, R.color.colorPrimary));
        $this$apply.setStrokeWidth((float)this.barWidth);
        rawAudioDataVisualizer.paint = paint = paint2;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/dailystudio/devbricksx/audio/visualizer/RawAudioDataVisualizer$Companion;", "", "()V", "DEFAULT_BAR_SPACING_X", "", "DEFAULT_BAR_WIDTH", "MAX_EFFECTIVE_AMP", "MIN_EFFECTIVE_AMP", "devbricksx-audio_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

