/*
 * Decompiled with CFR 0.152.
 */
package com.dailystudio.devbricksx.audio;

import android.media.AudioRecord;
import android.os.Bundle;
import android.os.Process;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.dailystudio.devbricksx.async.ManagedThread;
import com.dailystudio.devbricksx.audio.AudioFragment;
import com.dailystudio.devbricksx.audio.R;
import com.dailystudio.devbricksx.development.Logger;
import com.dailystudio.devbricksx.fragment.AbsPermissionsFragment;
import java.util.HashMap;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Y\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0017\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004*\u0001\n\b\u0016\u0018\u0000 !2\u00020\u0001:\u0001!B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\f\u001a\u00020\bH\u0016J\u0013\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016\u00a2\u0006\u0002\u0010\u0010J&\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001aH\u0016J\u0010\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u001aH\u0002J\b\u0010 \u001a\u00020\u001aH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006\""}, d2={"Lcom/dailystudio/devbricksx/audio/AudioFragment;", "Lcom/dailystudio/devbricksx/fragment/AbsPermissionsFragment;", "()V", "recordingBuffer", "", "recordingBufferLock", "Ljava/util/concurrent/locks/ReentrantLock;", "recordingOffset", "", "recordingThread", "com/dailystudio/devbricksx/audio/AudioFragment$recordingThread$1", "Lcom/dailystudio/devbricksx/audio/AudioFragment$recordingThread$1;", "getPermissionsPromptViewId", "getRequiredPermissions", "", "", "()[Ljava/lang/String;", "onCreateView", "Landroid/view/View;", "inflater", "Landroid/view/LayoutInflater;", "container", "Landroid/view/ViewGroup;", "savedInstanceState", "Landroid/os/Bundle;", "onPause", "", "onPermissionsDenied", "onPermissionsGranted", "newlyGranted", "", "startRecording", "stopRecording", "Companion", "devbricksx-audio_release"})
public class AudioFragment
extends AbsPermissionsFragment {
    private short[] recordingBuffer = new short[16000];
    private int recordingOffset;
    private final ReentrantLock recordingBufferLock = new ReentrantLock();
    private recordingThread.1 recordingThread = new ManagedThread(this){
        final /* synthetic */ AudioFragment this$0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runInBackground() {
            Process.setThreadPriority((int)-16);
            int bufferSize = AudioRecord.getMinBufferSize((int)16000, (int)16, (int)2);
            if (bufferSize == -1 || bufferSize == -2) {
                bufferSize = 32000;
            }
            short[] audioBuffer = new short[bufferSize / 2];
            AudioRecord record = new AudioRecord(0, 16000, 16, 2, bufferSize);
            if (record.getState() != 1) {
                Logger.INSTANCE.error("audio record initialization failed: state = " + record.getState(), new Object[0]);
                return;
            }
            record.startRecording();
            while (this.isRunning()) {
                int numberRead = record.read(audioBuffer, 0, audioBuffer.length);
                int maxLength = AudioFragment.access$getRecordingBuffer$p(this.this$0).length;
                int newRecordingOffset = AudioFragment.access$getRecordingOffset$p(this.this$0) + numberRead;
                int n = 0;
                int n2 = newRecordingOffset - maxLength;
                boolean bl = false;
                int secondCopyLength = Math.max(n, n2);
                int firstCopyLength = numberRead - secondCopyLength;
                AudioFragment.access$getRecordingBufferLock$p(this.this$0).lock();
                try {
                    System.arraycopy(audioBuffer, 0, AudioFragment.access$getRecordingBuffer$p(this.this$0), AudioFragment.access$getRecordingOffset$p(this.this$0), firstCopyLength);
                    System.arraycopy(audioBuffer, firstCopyLength, AudioFragment.access$getRecordingBuffer$p(this.this$0), 0, secondCopyLength);
                    AudioFragment.access$setRecordingOffset$p(this.this$0, newRecordingOffset % maxLength);
                }
                finally {
                    AudioFragment.access$getRecordingBufferLock$p(this.this$0).unlock();
                }
            }
            Logger.INSTANCE.info("stop recording: record = " + record, new Object[0]);
            record.stop();
            record.release();
        }
        {
            this.this$0 = $outer;
        }
    };
    @NotNull
    private static final String[] PERMISSIONS_REQUIRED;
    private static final int SAMPLE_RATE = 16000;
    private static final int SAMPLE_DURATION_MS = 1000;
    private static final int RECORDING_LENGTH = 16000;
    public static final Companion Companion;
    private HashMap _$_findViewCache;

    @Nullable
    public View onCreateView(@NotNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkParameterIsNotNull((Object)inflater, (String)"inflater");
        return inflater.inflate(R.layout.fragment_audio, container, false);
    }

    public int getPermissionsPromptViewId() {
        return R.id.permission_prompt;
    }

    @NotNull
    public String[] getRequiredPermissions() {
        return PERMISSIONS_REQUIRED;
    }

    public void onPermissionsDenied() {
    }

    public void onPermissionsGranted(boolean newlyGranted) {
        this.startRecording();
    }

    public void onPause() {
        super.onPause();
        this.stopRecording();
    }

    private final void startRecording() {
        this.recordingThread.start();
    }

    private final void stopRecording() {
        this.recordingThread.stop();
    }

    static {
        Companion = new Companion(null);
        PERMISSIONS_REQUIRED = new String[]{"android.permission.RECORD_AUDIO", "android.permission.MODIFY_AUDIO_SETTINGS"};
    }

    public static final /* synthetic */ short[] access$getRecordingBuffer$p(AudioFragment $this) {
        return $this.recordingBuffer;
    }

    public static final /* synthetic */ void access$setRecordingBuffer$p(AudioFragment $this, short[] sArray) {
        $this.recordingBuffer = sArray;
    }

    public static final /* synthetic */ int access$getRecordingOffset$p(AudioFragment $this) {
        return $this.recordingOffset;
    }

    public static final /* synthetic */ void access$setRecordingOffset$p(AudioFragment $this, int n) {
        $this.recordingOffset = n;
    }

    public static final /* synthetic */ ReentrantLock access$getRecordingBufferLock$p(AudioFragment $this) {
        return $this.recordingBufferLock;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            View view2 = this.getView();
            if (view2 == null) {
                return null;
            }
            view = view2.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    public /* synthetic */ void onDestroyView() {
        super.onDestroyView();
        this._$_clearFindViewByIdCache();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/dailystudio/devbricksx/audio/AudioFragment$Companion;", "", "()V", "PERMISSIONS_REQUIRED", "", "", "getPERMISSIONS_REQUIRED", "()[Ljava/lang/String;", "[Ljava/lang/String;", "RECORDING_LENGTH", "", "SAMPLE_DURATION_MS", "SAMPLE_RATE", "devbricksx-audio_release"})
    public static final class Companion {
        @NotNull
        public final String[] getPERMISSIONS_REQUIRED() {
            return PERMISSIONS_REQUIRED;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

