/*
 * Decompiled with CFR 0.152.
 */
package com.dailymotion.android.player.sdk;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Lcom/dailymotion/android/player/sdk/Utils;", "", "()V", "hasFireTV", "", "context", "Landroid/content/Context;", "hasLeanback", "sdk_release"})
public final class Utils {
    @NotNull
    public static final Utils INSTANCE = new Utils();

    private Utils() {
    }

    public final boolean hasFireTV(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PackageManager mgr = context.getPackageManager();
        return mgr.hasSystemFeature("amazon.hardware.fire_tv");
    }

    public final boolean hasLeanback(@NotNull Context context) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (Build.VERSION.SDK_INT >= 21) {
            PackageManager mgr = context.getPackageManager();
            bl = mgr.hasSystemFeature("android.software.leanback");
        } else {
            bl = false;
        }
        return bl;
    }
}

