/*
 * Decompiled with CFR 0.152.
 */
package com.dailymotion.android.player.sdk;

import android.content.Context;
import android.preference.PreferenceManager;
import android.webkit.CookieManager;
import java.net.URLEncoder;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J+\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lcom/dailymotion/android/player/sdk/TCF2Handler;", "", "()V", "getCookieDefaultMaxAge", "", "loadConsentString", "", "context", "Landroid/content/Context;", "consentString", "", "consentStringCookieMaxAge", "(Landroid/content/Context;Ljava/lang/String;Ljava/lang/Long;)Z", "sdk_release"})
public final class TCF2Handler {
    public final boolean loadConsentString(@NotNull Context context, @Nullable String consentString, @Nullable Long consentStringCookieMaxAge) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String savedConsentString = PreferenceManager.getDefaultSharedPreferences((Context)context).getString("IABTCF_TCString", consentString);
        if (savedConsentString == null) {
            Timber.Forest.e("Loaded consent string is null", new Object[0]);
            return false;
        }
        Long l = consentStringCookieMaxAge;
        long maxAge = l == null ? this.getCookieDefaultMaxAge() : l.longValue();
        String name = "dm-euconsent-v2";
        String url = ".dailymotion.com";
        try {
            String cookie = name + '=' + URLEncoder.encode(savedConsentString, "UTF-8") + "; max-age=" + maxAge + "; path=/; domain=" + url;
            CookieManager.getInstance().setCookie(url, cookie);
            bl = true;
        }
        catch (Exception e) {
            Timber.Forest.e((Throwable)e);
            bl = false;
        }
        return bl;
    }

    public static /* synthetic */ boolean loadConsentString$default(TCF2Handler tCF2Handler, Context context, String string, Long l, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            l = null;
        }
        return tCF2Handler.loadConsentString(context, string, l);
    }

    private final long getCookieDefaultMaxAge() {
        return TimeUnit.DAYS.toSeconds(180L);
    }
}

