/*
 * Decompiled with CFR 0.152.
 */
package com.dailymotion.android.player.sdk.iab;

import android.content.Context;
import android.view.View;
import com.dailymotion.android.player.sdk.PlayerWebView;
import com.dailymotion.android.player.sdk.events.AdBufferEndEvent;
import com.dailymotion.android.player.sdk.events.AdBufferStartEvent;
import com.dailymotion.android.player.sdk.events.AdClickEvent;
import com.dailymotion.android.player.sdk.events.AdEndEvent;
import com.dailymotion.android.player.sdk.events.AdLoadedEvent;
import com.dailymotion.android.player.sdk.events.AdPauseEvent;
import com.dailymotion.android.player.sdk.events.AdPlayEvent;
import com.dailymotion.android.player.sdk.events.AdStartEvent;
import com.dailymotion.android.player.sdk.events.AdTimeUpdateEvent;
import com.dailymotion.android.player.sdk.events.FullScreenChangeEvent;
import com.dailymotion.android.player.sdk.events.PlayerEvent;
import com.dailymotion.android.player.sdk.events.VolumeChangeEvent;
import com.dailymotion.android.player.sdk.iab.OmidJsLoader;
import com.dailymotion.android.player.sdk.iab.VerificationScriptData;
import com.iab.omid.library.dailymotion.Omid;
import com.iab.omid.library.dailymotion.adsession.AdEvents;
import com.iab.omid.library.dailymotion.adsession.AdSession;
import com.iab.omid.library.dailymotion.adsession.AdSessionConfiguration;
import com.iab.omid.library.dailymotion.adsession.AdSessionContext;
import com.iab.omid.library.dailymotion.adsession.CreativeType;
import com.iab.omid.library.dailymotion.adsession.ErrorType;
import com.iab.omid.library.dailymotion.adsession.ImpressionType;
import com.iab.omid.library.dailymotion.adsession.Owner;
import com.iab.omid.library.dailymotion.adsession.Partner;
import com.iab.omid.library.dailymotion.adsession.VerificationScriptResource;
import com.iab.omid.library.dailymotion.adsession.media.InteractionType;
import com.iab.omid.library.dailymotion.adsession.media.MediaEvents;
import com.iab.omid.library.dailymotion.adsession.media.PlayerState;
import com.iab.omid.library.dailymotion.adsession.media.Position;
import com.iab.omid.library.dailymotion.adsession.media.VastProperties;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002@AB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0004H\u0002J\r\u0010!\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b\"J\u0015\u0010#\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020%H\u0000\u00a2\u0006\u0002\b&J\u0015\u0010'\u001a\n (*\u0004\u0018\u00010\u00040\u0004H\u0000\u00a2\u0006\u0002\b)J(\u0010*\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020\u00042\n\u0010,\u001a\u00060-j\u0002`.2\n\b\u0002\u0010/\u001a\u0004\u0018\u00010\u0004H\u0002J\u0010\u00100\u001a\u00020\u001d2\u0006\u00101\u001a\u00020\u0004H\u0002J\u001d\u00102\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u00103\u001a\u000204H\u0000\u00a2\u0006\u0002\b5J\u0010\u00106\u001a\u00020\u001d2\u0006\u00107\u001a\u00020\u0016H\u0002J\u001d\u00108\u001a\b\u0012\u0004\u0012\u00020:092\b\u0010 \u001a\u0004\u0018\u00010\u0004H\u0000\u00a2\u0006\u0002\b;J\b\u0010<\u001a\u00020\u001dH\u0002J\u0010\u0010=\u001a\u00020\u001d2\b\u0010>\u001a\u0004\u0018\u00010\fJ\b\u0010?\u001a\u00020\u001dH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\u0017\u001a\u0004\u0018\u00010\u00162\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006B"}, d2={"Lcom/dailymotion/android/player/sdk/iab/OMHelper;", "", "()V", "PARTNER_NAME", "", "PARTNER_VERSION", "adDuration", "", "isAdPaused", "", "mVolume", "omErrorListener", "Lcom/dailymotion/android/player/sdk/iab/OMHelper$OMErrorListener;", "omidAdEvents", "Lcom/iab/omid/library/dailymotion/adsession/AdEvents;", "omidCurrentPosition", "Lcom/dailymotion/android/player/sdk/iab/OMHelper$Quartile;", "omidMediaEvents", "Lcom/iab/omid/library/dailymotion/adsession/media/MediaEvents;", "omidSession", "Lcom/iab/omid/library/dailymotion/adsession/AdSession;", "value", "Lcom/iab/omid/library/dailymotion/adsession/media/PlayerState;", "playerState", "getPlayerState", "()Lcom/iab/omid/library/dailymotion/adsession/media/PlayerState;", "setPlayerState", "(Lcom/iab/omid/library/dailymotion/adsession/media/PlayerState;)V", "createOmidSession", "", "playerWebView", "Lcom/dailymotion/android/player/sdk/PlayerWebView;", "payload", "endOmidSession", "endOmidSession$sdk_release", "ensureInitialized", "context", "Landroid/content/Context;", "ensureInitialized$sdk_release", "getVersion", "kotlin.jvm.PlatformType", "getVersion$sdk_release", "logError", "error", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "debug", "logOmidAction", "message", "onPlayerEvent", "playerEvent", "Lcom/dailymotion/android/player/sdk/events/PlayerEvent;", "onPlayerEvent$sdk_release", "onPlayerStateChanged", "state", "parseVerificationScriptData", "", "Lcom/dailymotion/android/player/sdk/iab/VerificationScriptData;", "parseVerificationScriptData$sdk_release", "sendVolumeEvent", "setOMErrorListener", "errorListener", "startOmidSession", "OMErrorListener", "Quartile", "sdk_release"})
public final class OMHelper {
    @NotNull
    public static final OMHelper INSTANCE = new OMHelper();
    @NotNull
    public static final String PARTNER_NAME = "Dailymotion";
    @NotNull
    public static final String PARTNER_VERSION = "0.2.8";
    @Nullable
    private static AdSession omidSession;
    @Nullable
    private static AdEvents omidAdEvents;
    @Nullable
    private static MediaEvents omidMediaEvents;
    @Nullable
    private static Quartile omidCurrentPosition;
    private static float adDuration;
    private static boolean isAdPaused;
    private static float mVolume;
    @Nullable
    private static OMErrorListener omErrorListener;
    @Nullable
    private static PlayerState playerState;

    private OMHelper() {
    }

    @Nullable
    public final PlayerState getPlayerState() {
        return playerState;
    }

    public final void setPlayerState(@Nullable PlayerState value) {
        if (value != playerState && value != null) {
            this.onPlayerStateChanged(value);
        }
        playerState = value;
    }

    public final void ensureInitialized$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!Omid.isActive()) {
            Omid.activate((Context)context.getApplicationContext());
        }
    }

    public final void onPlayerEvent$sdk_release(@NotNull PlayerWebView playerWebView, @NotNull PlayerEvent playerEvent) {
        block79: {
            PlayerEvent playerEvent2;
            block82: {
                block81: {
                    block80: {
                        Object object;
                        Intrinsics.checkNotNullParameter((Object)((Object)playerWebView), (String)"playerWebView");
                        Intrinsics.checkNotNullParameter((Object)playerEvent, (String)"playerEvent");
                        playerEvent2 = playerEvent;
                        if (!(playerEvent2 instanceof AdLoadedEvent)) break block80;
                        if (omidSession != null) {
                            this.endOmidSession$sdk_release();
                        }
                        this.createOmidSession(playerWebView, playerEvent.getPayload());
                        try {
                            AdEvents adEvents = omidAdEvents;
                            if (adEvents != null) {
                                object = adEvents;
                                AdEvents $this$onPlayerEvent_u24lambda_u2d0 = object;
                                boolean bl = false;
                                $this$onPlayerEvent_u24lambda_u2d0.impressionOccurred();
                                INSTANCE.logOmidAction("Impression occured");
                            }
                        }
                        catch (Exception e) {
                            AdSession adSession = omidSession;
                            if (adSession != null) {
                                adSession.error(ErrorType.GENERIC, e.getLocalizedMessage());
                            }
                            OMHelper.logError$default(this, "Error with adSession : Impression", e, null, 4, null);
                        }
                        try {
                            String string;
                            String string2;
                            object = ((AdLoadedEvent)playerEvent).getPosition();
                            if (object == null) {
                                string2 = null;
                            } else {
                                String bl = ((String)object).toUpperCase(Locale.ROOT);
                                Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
                                string2 = string = bl;
                            }
                            if (string2 == null) {
                                string = "";
                            }
                            object = Position.valueOf(string);
                        }
                        catch (Exception e) {
                            OMHelper.logError$default(this, "Incorrect Position", e, null, 4, null);
                            return;
                        }
                        Object position = object;
                        VastProperties properties = ((AdLoadedEvent)playerEvent).getSkipOffset() > 0.0f ? VastProperties.createVastPropertiesForSkippableMedia((float)((AdLoadedEvent)playerEvent).getSkipOffset(), (boolean)((AdLoadedEvent)playerEvent).getAutoPlay(), (Position)position) : VastProperties.createVastPropertiesForNonSkippableMedia((boolean)((AdLoadedEvent)playerEvent).getAutoPlay(), (Position)position);
                        try {
                            AdEvents adEvents = omidAdEvents;
                            if (adEvents != null) {
                                AdEvents bl;
                                AdEvents $this$onPlayerEvent_u24lambda_u2d1 = bl = adEvents;
                                boolean bl2 = false;
                                $this$onPlayerEvent_u24lambda_u2d1.loaded(properties);
                                INSTANCE.logOmidAction("Loaded " + properties.isAutoPlay() + '/' + properties.isSkippable() + '/' + properties.getPosition() + '/' + properties.getSkipOffset());
                            }
                            break block79;
                        }
                        catch (Exception e) {
                            AdSession adSession = omidSession;
                            if (adSession != null) {
                                adSession.error(ErrorType.GENERIC, e.getLocalizedMessage());
                            }
                            OMHelper.logError$default(this, "Error with adSession : Load Properties", e, null, 4, null);
                        }
                        break block79;
                    }
                    if (!(playerEvent2 instanceof AdStartEvent)) break block81;
                    Float f = Float.valueOf(((AdStartEvent)playerEvent).getAdDuration());
                    float it = ((Number)f).floatValue();
                    boolean bl = false;
                    Float f2 = !(it == 0.0f) ? f : null;
                    adDuration = f2 == null ? 1.0f : f2.floatValue();
                    isAdPaused = false;
                    this.startOmidSession();
                    this.sendVolumeEvent();
                    break block79;
                }
                if (!(playerEvent2 instanceof AdEndEvent)) break block82;
                try {
                    block83: {
                        String position = ((AdEndEvent)playerEvent).getReason();
                        if (position == null) break block83;
                        int n = -1;
                        switch (position.hashCode()) {
                            case -1607610636: {
                                if (position.equals("AD_SKIPPED")) {
                                    n = 1;
                                }
                                break;
                            }
                            case -1344407151: {
                                if (position.equals("AD_STOPPED")) {
                                    n = 2;
                                }
                                break;
                            }
                            case 325279436: {
                                if (position.equals("AD_ERROR")) {
                                    n = 3;
                                }
                                break;
                            }
                        }
                        switch (n) {
                            case 2: {
                                MediaEvents it;
                                MediaEvents mediaEvents = omidMediaEvents;
                                if (mediaEvents == null) break;
                                MediaEvents $this$onPlayerEvent_u24lambda_u2d3 = it = mediaEvents;
                                boolean bl = false;
                                $this$onPlayerEvent_u24lambda_u2d3.complete();
                                INSTANCE.logOmidAction("Complete");
                                break;
                            }
                            case 1: {
                                MediaEvents it;
                                MediaEvents mediaEvents = omidMediaEvents;
                                if (mediaEvents == null) break;
                                MediaEvents $this$onPlayerEvent_u24lambda_u2d4 = it = mediaEvents;
                                boolean bl = false;
                                $this$onPlayerEvent_u24lambda_u2d4.skipped();
                                INSTANCE.logOmidAction("Skipped");
                                break;
                            }
                            case 3: {
                                AdSession adSession = omidSession;
                                if (adSession != null) {
                                    String string = ((AdEndEvent)playerEvent).getError();
                                    if (string == null) {
                                        string = "AD_ERROR";
                                    }
                                    adSession.error(ErrorType.VIDEO, string);
                                }
                                OMHelper.logError$default(this, "Error with adSession : AD_ERROR", new Exception("Received an AD_ERROR"), null, 4, null);
                            }
                        }
                    }
                    this.endOmidSession$sdk_release();
                }
                catch (Exception e) {
                    AdSession adSession = omidSession;
                    if (adSession != null) {
                        adSession.error(ErrorType.GENERIC, e.getLocalizedMessage());
                    }
                    OMHelper.logError$default(this, "Error with adSession : AdEndEvent", e, null, 4, null);
                }
                break block79;
            }
            if (playerEvent2 instanceof AdPauseEvent) {
                isAdPaused = true;
                try {
                    MediaEvents mediaEvents = omidMediaEvents;
                    if (mediaEvents != null) {
                        MediaEvents mediaEvents2;
                        MediaEvents $this$onPlayerEvent_u24lambda_u2d5 = mediaEvents2 = mediaEvents;
                        boolean bl = false;
                        $this$onPlayerEvent_u24lambda_u2d5.pause();
                        INSTANCE.logOmidAction("pause");
                    }
                }
                catch (Exception e) {
                    AdSession adSession = omidSession;
                    if (adSession != null) {
                        adSession.error(ErrorType.GENERIC, e.getLocalizedMessage());
                    }
                    OMHelper.logError$default(this, "Error with adSession : AdPauseEvent", e, null, 4, null);
                }
            } else if (playerEvent2 instanceof AdPlayEvent) {
                if (isAdPaused) {
                    isAdPaused = false;
                    try {
                        MediaEvents mediaEvents = omidMediaEvents;
                        if (mediaEvents != null) {
                            MediaEvents mediaEvents3;
                            MediaEvents $this$onPlayerEvent_u24lambda_u2d6 = mediaEvents3 = mediaEvents;
                            boolean bl = false;
                            $this$onPlayerEvent_u24lambda_u2d6.resume();
                            INSTANCE.logOmidAction("resume");
                        }
                    }
                    catch (Exception e) {
                        AdSession adSession = omidSession;
                        if (adSession != null) {
                            adSession.error(ErrorType.GENERIC, e.getLocalizedMessage());
                        }
                        OMHelper.logError$default(this, "Error with adSession : AdPlayEvent", e, null, 4, null);
                    }
                }
            } else if (playerEvent2 instanceof AdBufferStartEvent) {
                try {
                    MediaEvents mediaEvents = omidMediaEvents;
                    if (mediaEvents != null) {
                        MediaEvents mediaEvents4;
                        MediaEvents $this$onPlayerEvent_u24lambda_u2d7 = mediaEvents4 = mediaEvents;
                        boolean bl = false;
                        $this$onPlayerEvent_u24lambda_u2d7.bufferStart();
                        INSTANCE.logOmidAction("bufferStart");
                    }
                }
                catch (Exception e) {
                    AdSession adSession = omidSession;
                    if (adSession != null) {
                        adSession.error(ErrorType.GENERIC, e.getLocalizedMessage());
                    }
                    OMHelper.logError$default(this, "Error with adSession : AdBufferStartTime", e, null, 4, null);
                }
            } else if (playerEvent2 instanceof AdBufferEndEvent) {
                try {
                    MediaEvents mediaEvents = omidMediaEvents;
                    if (mediaEvents != null) {
                        MediaEvents mediaEvents5;
                        MediaEvents $this$onPlayerEvent_u24lambda_u2d8 = mediaEvents5 = mediaEvents;
                        boolean bl = false;
                        $this$onPlayerEvent_u24lambda_u2d8.bufferFinish();
                        INSTANCE.logOmidAction("bufferEnd");
                    }
                }
                catch (Exception e) {
                    AdSession adSession = omidSession;
                    if (adSession != null) {
                        adSession.error(ErrorType.GENERIC, e.getLocalizedMessage());
                    }
                    OMHelper.logError$default(this, "Error with adSession : AdBufferEndEvent", e, null, 4, null);
                }
            } else if (playerEvent2 instanceof AdClickEvent) {
                try {
                    MediaEvents mediaEvents = omidMediaEvents;
                    if (mediaEvents != null) {
                        MediaEvents mediaEvents6;
                        MediaEvents $this$onPlayerEvent_u24lambda_u2d9 = mediaEvents6 = mediaEvents;
                        boolean bl = false;
                        $this$onPlayerEvent_u24lambda_u2d9.adUserInteraction(InteractionType.CLICK);
                        INSTANCE.logOmidAction("adUserInteraction Click");
                    }
                }
                catch (Exception e) {
                    AdSession adSession = omidSession;
                    if (adSession != null) {
                        adSession.error(ErrorType.GENERIC, e.getLocalizedMessage());
                    }
                    OMHelper.logError$default(this, "Error with adSession : AdClickEvent", e, null, 4, null);
                }
            } else if (playerEvent2 instanceof VolumeChangeEvent) {
                mVolume = ((VolumeChangeEvent)playerEvent).isMuted() ? 0.0f : 1.0f;
                this.sendVolumeEvent();
            } else if (playerEvent2 instanceof FullScreenChangeEvent) {
                if (playerState == null) {
                    this.onPlayerStateChanged(((FullScreenChangeEvent)playerEvent).getFullscreen() ? PlayerState.FULLSCREEN : PlayerState.NORMAL);
                }
            } else if (playerEvent2 instanceof AdTimeUpdateEvent) {
                double d;
                String string = ((AdTimeUpdateEvent)playerEvent).getTime();
                if (string == null) {
                    d = 0.0;
                } else {
                    Double d2 = StringsKt.toDoubleOrNull((String)string);
                    d = d2 == null ? 0.0 : d2;
                }
                double progress = d / (double)adDuration;
                Quartile quartile = omidCurrentPosition;
                Quartile quartile2 = quartile == null ? null : quartile.getNextStep();
                if (quartile2 == null) {
                    return;
                }
                Quartile nextPosition = quartile2;
                if (progress > (double)nextPosition.getProgress()) {
                    omidCurrentPosition = nextPosition;
                    try {
                        MediaEvents mediaEvents = omidMediaEvents;
                        if (mediaEvents != null) {
                            MediaEvents it = mediaEvents;
                            boolean bl = false;
                            Quartile quartile3 = omidCurrentPosition;
                            if (quartile3 != null) {
                                Function1<MediaEvents, Unit> function1 = quartile3.getAction();
                                if (function1 != null) {
                                    function1.invoke((Object)it);
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        AdSession adSession = omidSession;
                        if (adSession != null) {
                            adSession.error(ErrorType.GENERIC, e.getLocalizedMessage());
                        }
                        OMHelper.logError$default(this, "Error with adSession : AdTimeUpdateEvent", e, null, 4, null);
                    }
                }
            }
        }
    }

    private final void sendVolumeEvent() {
        try {
            MediaEvents mediaEvents = omidMediaEvents;
            if (mediaEvents != null) {
                MediaEvents mediaEvents2;
                MediaEvents $this$sendVolumeEvent_u24lambda_u2d11 = mediaEvents2 = mediaEvents;
                boolean bl = false;
                $this$sendVolumeEvent_u24lambda_u2d11.volumeChange(mVolume);
                INSTANCE.logOmidAction(Intrinsics.stringPlus((String)"volumeChange ", (Object)Float.valueOf(mVolume)));
            }
        }
        catch (Exception e) {
            AdSession adSession = omidSession;
            if (adSession != null) {
                adSession.error(ErrorType.GENERIC, e.getLocalizedMessage());
            }
            OMHelper.logError$default(this, "Error with adSession : VolumeChangeEvent", e, null, 4, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void createOmidSession(PlayerWebView playerWebView, String payload) {
        AdSessionConfiguration adSessionConfiguration;
        Partner e2;
        Iterable $this$map$iv;
        List<VerificationScriptData> verificationScriptsList = this.parseVerificationScriptData$sdk_release(payload);
        try {
            void $this$mapTo$iv$iv;
            $this$map$iv = verificationScriptsList;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                VerificationScriptData verificationScriptData = (VerificationScriptData)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(VerificationScriptResource.createVerificationScriptResourceWithParameters((String)it.getVendorKey(), (URL)new URL(it.getUrl()), (String)it.getParameters()));
            }
            $this$map$iv = (List)destination$iv$iv;
        }
        catch (Exception e2) {
            this.logError("Error while creating verificationScriptResourceList with payload", e2, payload);
            return;
        }
        Iterable verificationScriptResourceList = $this$map$iv;
        try {
            e2 = Partner.createPartner((String)PARTNER_NAME, (String)PARTNER_VERSION);
        }
        catch (IllegalArgumentException e3) {
            OMHelper.logError$default(this, "Error while creating partner", e3, null, 4, null);
            return;
        }
        Partner partner = e2;
        Context e3 = playerWebView.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)e3, (String)"playerWebView.context");
        AdSessionContext adSessionContext = AdSessionContext.createNativeAdSessionContext((Partner)partner, (String)OmidJsLoader.INSTANCE.getOmidJs(e3), (List)verificationScriptResourceList, null, null);
        try {
            adSessionConfiguration = AdSessionConfiguration.createAdSessionConfiguration((CreativeType)CreativeType.VIDEO, (ImpressionType)ImpressionType.ONE_PIXEL, (Owner)Owner.NATIVE, (Owner)Owner.NATIVE, (boolean)true);
        }
        catch (IllegalArgumentException e4) {
            OMHelper.logError$default(this, "Error while creating adSessionConfiguration", e4, null, 4, null);
            return;
        }
        AdSessionConfiguration adSessionConfiguration2 = adSessionConfiguration;
        AdSession adSession = omidSession = AdSession.createAdSession((AdSessionConfiguration)adSessionConfiguration2, (AdSessionContext)adSessionContext);
        if (adSession != null) {
            adSession.registerAdView((View)playerWebView);
        }
        omidAdEvents = AdEvents.createAdEvents((AdSession)omidSession);
        omidMediaEvents = MediaEvents.createMediaEvents((AdSession)omidSession);
        omidCurrentPosition = Quartile.INIT;
    }

    public final void endOmidSession$sdk_release() {
        AdSession adSession = omidSession;
        if (adSession != null) {
            AdSession adSession2;
            AdSession $this$endOmidSession_u24lambda_u2d13 = adSession2 = adSession;
            boolean bl = false;
            $this$endOmidSession_u24lambda_u2d13.finish();
            INSTANCE.logOmidAction("Session End");
        }
        omidSession = null;
        omidAdEvents = null;
        omidMediaEvents = null;
        omidCurrentPosition = null;
        adDuration = 1.0f;
        isAdPaused = false;
    }

    private final void startOmidSession() {
        AdSession adSession = omidSession;
        if (adSession != null) {
            AdSession adSession2;
            AdSession $this$startOmidSession_u24lambda_u2d14 = adSession2 = adSession;
            boolean bl = false;
            $this$startOmidSession_u24lambda_u2d14.start();
            INSTANCE.logOmidAction("Session Start");
        }
        PlayerState playerState = OMHelper.playerState;
        if (playerState != null) {
            PlayerState it = playerState;
            boolean bl = false;
            INSTANCE.onPlayerStateChanged(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<VerificationScriptData> parseVerificationScriptData$sdk_release(@Nullable String payload) {
        List list;
        String string = payload;
        if (string == null) {
            list = null;
        } else {
            Object object = new String[]{"&"};
            List list2 = StringsKt.split$default((CharSequence)string, (String[])object, (boolean)false, (int)0, (int)6, null);
            if (list2 == null) {
                list = null;
            } else {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Object $this$filterKeys$iv;
                void $this$groupByTo$iv$iv;
                void $this$groupBy$iv;
                Object object2 = list2;
                boolean $i$f$groupBy22 = false;
                void var8_8 = $this$groupBy$iv;
                Map destination$iv$iv = new LinkedHashMap();
                boolean $i$f$groupByTo = false;
                for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                    Object object3;
                    String it = (String)element$iv$iv;
                    boolean bl = false;
                    Matcher m = Pattern.compile("verificationScripts\\[([0-9]*)]\\[(.*)]=(.*)").matcher(it);
                    String key$iv$iv = m.matches() ? m.group(1) : null;
                    Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                    boolean $i$f$getOrPut = false;
                    Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                    if (value$iv$iv$iv == null) {
                        boolean bl2 = false;
                        List answer$iv$iv$iv = new ArrayList();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        object3 = answer$iv$iv$iv;
                    } else {
                        object3 = value$iv$iv$iv;
                    }
                    List list$iv$iv = (List)object3;
                    list$iv$iv.add(element$iv$iv);
                }
                Object $i$f$groupBy22 = object = destination$iv$iv;
                boolean $i$f$filterKeys = false;
                LinkedHashMap result$iv = new LinkedHashMap();
                for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
                    String it = (String)entry$iv.getKey();
                    boolean bl = false;
                    if (!(it != null)) continue;
                    result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                }
                $this$filterKeys$iv = object2 = (Map)result$iv;
                boolean $i$f$map = false;
                result$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList($this$map$iv.size());
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Object object4;
                    Object v8;
                    String string2;
                    Object object5;
                    Object object6;
                    String string3;
                    Object object72;
                    Collection collection;
                    block20: {
                        Object object8;
                        Object e;
                        void group;
                        block19: {
                            Object object9;
                            Object object10;
                            block18: {
                                Map.Entry item$iv$iv;
                                Map.Entry bl = item$iv$iv = iterator.next();
                                collection = destination$iv$iv2;
                                boolean bl3 = false;
                                for (Object object72 : (Iterable)group.getValue()) {
                                    String it = (String)object72;
                                    boolean bl4 = false;
                                    if (!StringsKt.contains$default((CharSequence)it, (CharSequence)("verificationScripts[" + group.getKey() + "][vendor]"), (boolean)false, (int)2, null)) continue;
                                    object10 = object72;
                                    break block18;
                                }
                                object10 = null;
                            }
                            string3 = (String)object10;
                            if (string3 == null) {
                                object9 = "";
                            } else {
                                object6 = new String[]{"="};
                                List list3 = StringsKt.split$default((CharSequence)string3, (String[])object6, (boolean)false, (int)2, (int)2, null);
                                object9 = list3 == null ? "" : ((object6 = (String)list3.get(1)) == null ? "" : object6);
                            }
                            object5 = object9;
                            object72 = ((Iterable)group.getValue()).iterator();
                            while (object72.hasNext()) {
                                Object e2 = object72.next();
                                String it = (String)e2;
                                boolean bl = false;
                                if (!StringsKt.contains$default((CharSequence)it, (CharSequence)("verificationScripts[" + group.getKey() + "][resource]"), (boolean)false, (int)2, null)) continue;
                                e = e2;
                                break block19;
                            }
                            e = null;
                        }
                        string2 = (String)e;
                        if (string2 == null) {
                            object8 = "";
                        } else {
                            Object object11 = new String[]{"="};
                            List list4 = StringsKt.split$default((CharSequence)string2, (String[])object11, (boolean)false, (int)2, (int)2, null);
                            object8 = list4 == null ? "" : ((object11 = (String)list4.get(1)) == null ? "" : object11);
                        }
                        string3 = object8;
                        for (Object e3 : (Iterable)group.getValue()) {
                            String it = (String)e3;
                            boolean bl = false;
                            if (!StringsKt.contains$default((CharSequence)it, (CharSequence)("verificationScripts[" + group.getKey() + "][parameters]"), (boolean)false, (int)2, null)) continue;
                            v8 = e3;
                            break block20;
                        }
                        v8 = null;
                    }
                    object6 = v8;
                    if (object6 == null) {
                        object4 = "";
                    } else {
                        object72 = new String[]{"="};
                        List list5 = StringsKt.split$default((CharSequence)((CharSequence)object6), (String[])object72, (boolean)false, (int)2, (int)2, null);
                        object4 = list5 == null ? "" : ((object72 = (String)list5.get(1)) == null ? "" : object72);
                    }
                    string2 = object4;
                    collection.add(new VerificationScriptData(string3, (String)object5, string2));
                }
                list = (List)destination$iv$iv2;
            }
        }
        List list6 = list;
        return list6 == null ? CollectionsKt.emptyList() : list6;
    }

    private final void onPlayerStateChanged(PlayerState state) {
        try {
            MediaEvents mediaEvents = omidMediaEvents;
            if (mediaEvents != null) {
                MediaEvents mediaEvents2;
                MediaEvents $this$onPlayerStateChanged_u24lambda_u2d22 = mediaEvents2 = mediaEvents;
                boolean bl = false;
                $this$onPlayerStateChanged_u24lambda_u2d22.playerStateChange(state);
                INSTANCE.logOmidAction(Intrinsics.stringPlus((String)"PlayerState => ", (Object)state));
            }
        }
        catch (Exception e) {
            AdSession adSession = omidSession;
            if (adSession != null) {
                adSession.error(ErrorType.GENERIC, e.getLocalizedMessage());
            }
            OMHelper.logError$default(this, "Error with adSession : PlayerState", e, null, 4, null);
        }
    }

    private final void logError(String error, Exception exception, String debug) {
        Timber.Forest.e((Throwable)exception, Intrinsics.stringPlus((String)"OMSDK: ERROR : ", (Object)error), new Object[0]);
        OMErrorListener oMErrorListener = omErrorListener;
        if (oMErrorListener != null) {
            oMErrorListener.onOMSDKError(error, exception, debug);
        }
    }

    static /* synthetic */ void logError$default(OMHelper oMHelper, String string, Exception exception, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        oMHelper.logError(string, exception, string2);
    }

    private final void logOmidAction(String message) {
        Timber.Forest.d(Intrinsics.stringPlus((String)"OMSDK: ", (Object)message), new Object[0]);
    }

    public final String getVersion$sdk_release() {
        return Omid.getVersion();
    }

    public final void setOMErrorListener(@Nullable OMErrorListener errorListener) {
        omErrorListener = errorListener;
    }

    static {
        adDuration = 1.0f;
        mVolume = 1.0f;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\r\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B3\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u0012\u0016\b\u0002\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\tR\u001f\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014\u00a8\u0006\u0015"}, d2={"Lcom/dailymotion/android/player/sdk/iab/OMHelper$Quartile;", "", "progress", "", "nextStep", "action", "Lkotlin/Function1;", "Lcom/iab/omid/library/dailymotion/adsession/media/MediaEvents;", "", "(Ljava/lang/String;IFLcom/dailymotion/android/player/sdk/iab/OMHelper$Quartile;Lkotlin/jvm/functions/Function1;)V", "getAction", "()Lkotlin/jvm/functions/Function1;", "getNextStep", "()Lcom/dailymotion/android/player/sdk/iab/OMHelper$Quartile;", "getProgress", "()F", "Q3", "Q2", "Q1", "START", "INIT", "sdk_release"})
    private static final class Quartile
    extends Enum<Quartile> {
        private final float progress;
        @Nullable
        private final Quartile nextStep;
        @Nullable
        private final Function1<MediaEvents, Unit> action;
        public static final /* enum */ Quartile Q3 = new Quartile(0.75f, null, (Function1<? super MediaEvents, Unit>)((Function1)1.INSTANCE));
        public static final /* enum */ Quartile Q2 = new Quartile(0.5f, Q3, (Function1<? super MediaEvents, Unit>)((Function1)2.INSTANCE));
        public static final /* enum */ Quartile Q1 = new Quartile(0.25f, Q2, (Function1<? super MediaEvents, Unit>)((Function1)3.INSTANCE));
        public static final /* enum */ Quartile START = new Quartile(0.0f, Q1, (Function1<? super MediaEvents, Unit>)((Function1)4.INSTANCE));
        public static final /* enum */ Quartile INIT = new Quartile("INIT", 4, 0.0f, START, null, 4, null);
        private static final /* synthetic */ Quartile[] $VALUES;

        private Quartile(float progress, Quartile nextStep, Function1<? super MediaEvents, Unit> action) {
            this.progress = progress;
            this.nextStep = nextStep;
            this.action = action;
        }

        /* synthetic */ Quartile(String string, int n, float f, Quartile quartile, Function1 function1, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                quartile = null;
            }
            if ((n2 & 4) != 0) {
                function1 = null;
            }
            this(f, quartile, (Function1<? super MediaEvents, Unit>)function1);
        }

        public final float getProgress() {
            return this.progress;
        }

        @Nullable
        public final Quartile getNextStep() {
            return this.nextStep;
        }

        @Nullable
        public final Function1<MediaEvents, Unit> getAction() {
            return this.action;
        }

        public static Quartile[] values() {
            return (Quartile[])$VALUES.clone();
        }

        public static Quartile valueOf(String value) {
            return Enum.valueOf(Quartile.class, value);
        }

        static {
            $VALUES = quartileArray = new Quartile[]{Quartile.Q3, Quartile.Q2, Quartile.Q1, Quartile.START, Quartile.INIT};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J&\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0005H&\u00a8\u0006\n"}, d2={"Lcom/dailymotion/android/player/sdk/iab/OMHelper$OMErrorListener;", "", "onOMSDKError", "", "description", "", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "debug", "sdk_release"})
    public static interface OMErrorListener {
        public void onOMSDKError(@NotNull String var1, @NotNull Exception var2, @Nullable String var3);
    }
}

