/*
 * Decompiled with CFR 0.152.
 */
package com.dailymotion.android.player.sdk.iab;

import android.content.Context;
import android.view.View;
import com.dailymotion.android.player.sdk.PlayerWebView;
import com.dailymotion.android.player.sdk.events.AdBufferEndEvent;
import com.dailymotion.android.player.sdk.events.AdBufferStartEvent;
import com.dailymotion.android.player.sdk.events.AdClickEvent;
import com.dailymotion.android.player.sdk.events.AdEndEvent;
import com.dailymotion.android.player.sdk.events.AdLoadedEvent;
import com.dailymotion.android.player.sdk.events.AdPauseEvent;
import com.dailymotion.android.player.sdk.events.AdPlayEvent;
import com.dailymotion.android.player.sdk.events.AdStartEvent;
import com.dailymotion.android.player.sdk.events.AdTimeUpdateEvent;
import com.dailymotion.android.player.sdk.events.FullScreenChangeEvent;
import com.dailymotion.android.player.sdk.events.PlayerEvent;
import com.dailymotion.android.player.sdk.events.VolumeChangeEvent;
import com.dailymotion.android.player.sdk.iab.OmidJsLoader;
import com.dailymotion.android.player.sdk.iab.VerificationScriptData;
import com.iab.omid.library.dailymotion.Omid;
import com.iab.omid.library.dailymotion.adsession.AdEvents;
import com.iab.omid.library.dailymotion.adsession.AdSession;
import com.iab.omid.library.dailymotion.adsession.AdSessionConfiguration;
import com.iab.omid.library.dailymotion.adsession.AdSessionContext;
import com.iab.omid.library.dailymotion.adsession.CreativeType;
import com.iab.omid.library.dailymotion.adsession.ErrorType;
import com.iab.omid.library.dailymotion.adsession.ImpressionType;
import com.iab.omid.library.dailymotion.adsession.Owner;
import com.iab.omid.library.dailymotion.adsession.Partner;
import com.iab.omid.library.dailymotion.adsession.VerificationScriptResource;
import com.iab.omid.library.dailymotion.adsession.media.InteractionType;
import com.iab.omid.library.dailymotion.adsession.media.MediaEvents;
import com.iab.omid.library.dailymotion.adsession.media.PlayerState;
import com.iab.omid.library.dailymotion.adsession.media.Position;
import com.iab.omid.library.dailymotion.adsession.media.VastProperties;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002>?B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0004H\u0002J\r\u0010 \u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b!J\u0015\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$H\u0000\u00a2\u0006\u0002\b%J\u0015\u0010&\u001a\n '*\u0004\u0018\u00010\u00040\u0004H\u0000\u00a2\u0006\u0002\b(J(\u0010)\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020\u00042\n\u0010+\u001a\u00060,j\u0002`-2\n\b\u0002\u0010.\u001a\u0004\u0018\u00010\u0004H\u0002J\u0010\u0010/\u001a\u00020\u001c2\u0006\u00100\u001a\u00020\u0004H\u0002J\u001d\u00101\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u00102\u001a\u000203H\u0000\u00a2\u0006\u0002\b4J\u0010\u00105\u001a\u00020\u001c2\u0006\u00106\u001a\u00020\u0015H\u0002J\u001d\u00107\u001a\b\u0012\u0004\u0012\u000209082\b\u0010\u001f\u001a\u0004\u0018\u00010\u0004H\u0000\u00a2\u0006\u0002\b:J\u0010\u0010;\u001a\u00020\u001c2\b\u0010<\u001a\u0004\u0018\u00010\u000bJ\b\u0010=\u001a\u00020\u001cH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\u0016\u001a\u0004\u0018\u00010\u00152\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006@"}, d2={"Lcom/dailymotion/android/player/sdk/iab/OMHelper;", "", "()V", "PARTNER_NAME", "", "PARTNER_VERSION", "adDuration", "", "isAdPaused", "", "omErrorListener", "Lcom/dailymotion/android/player/sdk/iab/OMHelper$OMErrorListener;", "omidAdEvents", "Lcom/iab/omid/library/dailymotion/adsession/AdEvents;", "omidCurrentPosition", "Lcom/dailymotion/android/player/sdk/iab/OMHelper$Quartile;", "omidMediaEvents", "Lcom/iab/omid/library/dailymotion/adsession/media/MediaEvents;", "omidSession", "Lcom/iab/omid/library/dailymotion/adsession/AdSession;", "value", "Lcom/iab/omid/library/dailymotion/adsession/media/PlayerState;", "playerState", "getPlayerState", "()Lcom/iab/omid/library/dailymotion/adsession/media/PlayerState;", "setPlayerState", "(Lcom/iab/omid/library/dailymotion/adsession/media/PlayerState;)V", "createOmidSession", "", "playerWebView", "Lcom/dailymotion/android/player/sdk/PlayerWebView;", "payload", "endOmidSession", "endOmidSession$sdk_release", "ensureInitialized", "context", "Landroid/content/Context;", "ensureInitialized$sdk_release", "getVersion", "kotlin.jvm.PlatformType", "getVersion$sdk_release", "logError", "error", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "debug", "logOmidAction", "message", "onPlayerEvent", "playerEvent", "Lcom/dailymotion/android/player/sdk/events/PlayerEvent;", "onPlayerEvent$sdk_release", "onPlayerStateChanged", "state", "parseVerificationScriptData", "", "Lcom/dailymotion/android/player/sdk/iab/VerificationScriptData;", "parseVerificationScriptData$sdk_release", "setOMErrorListener", "errorListener", "startOmidSession", "OMErrorListener", "Quartile", "sdk_release"})
public final class OMHelper {
    @NotNull
    public static final OMHelper INSTANCE = new OMHelper();
    @NotNull
    public static final String PARTNER_NAME = "Dailymotion";
    @NotNull
    public static final String PARTNER_VERSION = "0.2.8";
    @Nullable
    private static AdSession omidSession;
    @Nullable
    private static AdEvents omidAdEvents;
    @Nullable
    private static MediaEvents omidMediaEvents;
    @Nullable
    private static Quartile omidCurrentPosition;
    private static float adDuration;
    private static boolean isAdPaused;
    @Nullable
    private static OMErrorListener omErrorListener;
    @Nullable
    private static PlayerState playerState;

    private OMHelper() {
    }

    @Nullable
    public final PlayerState getPlayerState() {
        return playerState;
    }

    public final void setPlayerState(@Nullable PlayerState value) {
        if (value != playerState && value != null) {
            this.onPlayerStateChanged(value);
        }
        playerState = value;
    }

    public final void ensureInitialized$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!Omid.isActive()) {
            Omid.activate((Context)context.getApplicationContext());
        }
    }

    public final void onPlayerEvent$sdk_release(@NotNull PlayerWebView playerWebView, @NotNull PlayerEvent playerEvent) {
        block79: {
            PlayerEvent playerEvent2;
            block82: {
                block81: {
                    block80: {
                        boolean bl;
                        boolean bl2;
                        Object object;
                        Intrinsics.checkNotNullParameter((Object)((Object)playerWebView), (String)"playerWebView");
                        Intrinsics.checkNotNullParameter((Object)playerEvent, (String)"playerEvent");
                        playerEvent2 = playerEvent;
                        if (!(playerEvent2 instanceof AdLoadedEvent)) break block80;
                        if (omidSession != null) {
                            this.endOmidSession$sdk_release();
                        }
                        this.createOmidSession(playerWebView, playerEvent.getPayload());
                        try {
                            AdEvents adEvents = omidAdEvents;
                            if (adEvents != null) {
                                object = adEvents;
                                boolean bl3 = false;
                                bl2 = false;
                                Object $this$onPlayerEvent_u24lambda_u2d0 = object;
                                bl = false;
                                $this$onPlayerEvent_u24lambda_u2d0.impressionOccurred();
                                INSTANCE.logOmidAction("Impression occured");
                            }
                        }
                        catch (Exception e) {
                            object = omidSession;
                            if (object != null) {
                                object.error(ErrorType.GENERIC, e.getLocalizedMessage());
                            }
                            OMHelper.logError$default(this, "Error with adSession : Impression", e, null, 4, null);
                        }
                        try {
                            String string;
                            object = ((AdLoadedEvent)playerEvent).getPosition();
                            if (object == null) {
                                string = null;
                            } else {
                                Object object2 = object;
                                bl2 = false;
                                String string2 = ((String)object2).toUpperCase(Locale.ROOT);
                                string = string2;
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026.toUpperCase(Locale.ROOT)");
                            }
                            object = string;
                            boolean bl4 = false;
                            Object object3 = object;
                            if (object3 == null) {
                                object3 = "";
                            }
                            object = Position.valueOf((String)object3);
                        }
                        catch (Exception e) {
                            OMHelper.logError$default(this, "Incorrect Position", e, null, 4, null);
                            return;
                        }
                        Object position = object;
                        VastProperties properties = ((AdLoadedEvent)playerEvent).getSkipOffset() > 0.0f ? VastProperties.createVastPropertiesForSkippableMedia((float)((AdLoadedEvent)playerEvent).getSkipOffset(), (boolean)((AdLoadedEvent)playerEvent).getAutoPlay(), (Position)position) : VastProperties.createVastPropertiesForNonSkippableMedia((boolean)((AdLoadedEvent)playerEvent).getAutoPlay(), (Position)position);
                        try {
                            AdEvents e = omidAdEvents;
                            if (e != null) {
                                AdEvents adEvents = e;
                                boolean $this$onPlayerEvent_u24lambda_u2d0 = false;
                                bl = false;
                                AdEvents $this$onPlayerEvent_u24lambda_u2d1 = adEvents;
                                boolean bl5 = false;
                                $this$onPlayerEvent_u24lambda_u2d1.loaded(properties);
                                INSTANCE.logOmidAction("Loaded " + properties.isAutoPlay() + '/' + properties.isSkippable() + '/' + properties.getPosition() + '/' + properties.getSkipOffset());
                            }
                            break block79;
                        }
                        catch (Exception e2) {
                            AdSession adSession = omidSession;
                            if (adSession != null) {
                                adSession.error(ErrorType.GENERIC, e2.getLocalizedMessage());
                            }
                            OMHelper.logError$default(this, "Error with adSession : Load Properties", e2, null, 4, null);
                        }
                        break block79;
                    }
                    if (!(playerEvent2 instanceof AdStartEvent)) break block81;
                    Float f = Float.valueOf(((AdStartEvent)playerEvent).getAdDuration());
                    boolean e2 = false;
                    boolean bl = false;
                    float it = ((Number)f).floatValue();
                    boolean bl6 = false;
                    Float position = !(it == 0.0f) ? f : null;
                    adDuration = position == null ? 1.0f : position.floatValue();
                    isAdPaused = false;
                    this.startOmidSession();
                    break block79;
                }
                if (!(playerEvent2 instanceof AdEndEvent)) break block82;
                try {
                    block83: {
                        String position = ((AdEndEvent)playerEvent).getReason();
                        if (position == null) break block83;
                        int n = -1;
                        switch (position.hashCode()) {
                            case -1607610636: {
                                if (position.equals("AD_SKIPPED")) {
                                    n = 1;
                                }
                                break;
                            }
                            case -1344407151: {
                                if (position.equals("AD_STOPPED")) {
                                    n = 2;
                                }
                                break;
                            }
                            case 325279436: {
                                if (position.equals("AD_ERROR")) {
                                    n = 3;
                                }
                                break;
                            }
                        }
                        switch (n) {
                            case 2: {
                                MediaEvents mediaEvents = omidMediaEvents;
                                if (mediaEvents == null) break;
                                MediaEvents e2 = mediaEvents;
                                boolean bl = false;
                                boolean it = false;
                                MediaEvents $this$onPlayerEvent_u24lambda_u2d3 = e2;
                                boolean bl7 = false;
                                $this$onPlayerEvent_u24lambda_u2d3.complete();
                                INSTANCE.logOmidAction("Complete");
                                break;
                            }
                            case 1: {
                                MediaEvents mediaEvents = omidMediaEvents;
                                if (mediaEvents == null) break;
                                MediaEvents e2 = mediaEvents;
                                boolean bl = false;
                                boolean it = false;
                                MediaEvents $this$onPlayerEvent_u24lambda_u2d4 = e2;
                                boolean bl8 = false;
                                $this$onPlayerEvent_u24lambda_u2d4.skipped();
                                INSTANCE.logOmidAction("Skipped");
                                break;
                            }
                            case 3: {
                                AdSession adSession = omidSession;
                                if (adSession != null) {
                                    String e2 = ((AdEndEvent)playerEvent).getError();
                                    adSession.error(ErrorType.VIDEO, e2 == null ? "AD_ERROR" : e2);
                                }
                                OMHelper.logError$default(this, "Error with adSession : AD_ERROR", new Exception("Received an AD_ERROR"), null, 4, null);
                            }
                        }
                    }
                    this.endOmidSession$sdk_release();
                }
                catch (Exception e) {
                    AdSession adSession = omidSession;
                    if (adSession != null) {
                        adSession.error(ErrorType.GENERIC, e.getLocalizedMessage());
                    }
                    OMHelper.logError$default(this, "Error with adSession : AdEndEvent", e, null, 4, null);
                }
                break block79;
            }
            if (playerEvent2 instanceof AdPauseEvent) {
                isAdPaused = true;
                try {
                    MediaEvents e = omidMediaEvents;
                    if (e != null) {
                        MediaEvents mediaEvents = e;
                        boolean e2 = false;
                        boolean bl = false;
                        MediaEvents $this$onPlayerEvent_u24lambda_u2d5 = mediaEvents;
                        boolean bl9 = false;
                        $this$onPlayerEvent_u24lambda_u2d5.pause();
                        INSTANCE.logOmidAction("pause");
                    }
                }
                catch (Exception e) {
                    AdSession adSession = omidSession;
                    if (adSession != null) {
                        adSession.error(ErrorType.GENERIC, e.getLocalizedMessage());
                    }
                    OMHelper.logError$default(this, "Error with adSession : AdPauseEvent", e, null, 4, null);
                }
            } else if (playerEvent2 instanceof AdPlayEvent) {
                if (isAdPaused) {
                    isAdPaused = false;
                    try {
                        MediaEvents e = omidMediaEvents;
                        if (e != null) {
                            MediaEvents mediaEvents = e;
                            boolean e2 = false;
                            boolean bl = false;
                            MediaEvents $this$onPlayerEvent_u24lambda_u2d6 = mediaEvents;
                            boolean bl10 = false;
                            $this$onPlayerEvent_u24lambda_u2d6.resume();
                            INSTANCE.logOmidAction("resume");
                        }
                    }
                    catch (Exception e) {
                        AdSession adSession = omidSession;
                        if (adSession != null) {
                            adSession.error(ErrorType.GENERIC, e.getLocalizedMessage());
                        }
                        OMHelper.logError$default(this, "Error with adSession : AdPlayEvent", e, null, 4, null);
                    }
                }
            } else if (playerEvent2 instanceof AdBufferStartEvent) {
                try {
                    MediaEvents e = omidMediaEvents;
                    if (e != null) {
                        MediaEvents mediaEvents = e;
                        boolean e2 = false;
                        boolean bl = false;
                        MediaEvents $this$onPlayerEvent_u24lambda_u2d7 = mediaEvents;
                        boolean bl11 = false;
                        $this$onPlayerEvent_u24lambda_u2d7.bufferStart();
                        INSTANCE.logOmidAction("bufferStart");
                    }
                }
                catch (Exception e) {
                    AdSession adSession = omidSession;
                    if (adSession != null) {
                        adSession.error(ErrorType.GENERIC, e.getLocalizedMessage());
                    }
                    OMHelper.logError$default(this, "Error with adSession : AdBufferStartTime", e, null, 4, null);
                }
            } else if (playerEvent2 instanceof AdBufferEndEvent) {
                try {
                    MediaEvents e = omidMediaEvents;
                    if (e != null) {
                        MediaEvents mediaEvents = e;
                        boolean e2 = false;
                        boolean bl = false;
                        MediaEvents $this$onPlayerEvent_u24lambda_u2d8 = mediaEvents;
                        boolean bl12 = false;
                        $this$onPlayerEvent_u24lambda_u2d8.bufferFinish();
                        INSTANCE.logOmidAction("bufferEnd");
                    }
                }
                catch (Exception e) {
                    AdSession adSession = omidSession;
                    if (adSession != null) {
                        adSession.error(ErrorType.GENERIC, e.getLocalizedMessage());
                    }
                    OMHelper.logError$default(this, "Error with adSession : AdBufferEndEvent", e, null, 4, null);
                }
            } else if (playerEvent2 instanceof AdClickEvent) {
                try {
                    MediaEvents e = omidMediaEvents;
                    if (e != null) {
                        MediaEvents mediaEvents = e;
                        boolean e2 = false;
                        boolean bl = false;
                        MediaEvents $this$onPlayerEvent_u24lambda_u2d9 = mediaEvents;
                        boolean bl13 = false;
                        $this$onPlayerEvent_u24lambda_u2d9.adUserInteraction(InteractionType.CLICK);
                        INSTANCE.logOmidAction("adUserInteraction Click");
                    }
                }
                catch (Exception e) {
                    AdSession adSession = omidSession;
                    if (adSession != null) {
                        adSession.error(ErrorType.GENERIC, e.getLocalizedMessage());
                    }
                    OMHelper.logError$default(this, "Error with adSession : AdClickEvent", e, null, 4, null);
                }
            } else if (playerEvent2 instanceof VolumeChangeEvent) {
                try {
                    MediaEvents e = omidMediaEvents;
                    if (e != null) {
                        MediaEvents mediaEvents = e;
                        boolean e2 = false;
                        boolean bl = false;
                        MediaEvents $this$onPlayerEvent_u24lambda_u2d10 = mediaEvents;
                        boolean bl14 = false;
                        $this$onPlayerEvent_u24lambda_u2d10.volumeChange(((VolumeChangeEvent)playerEvent).isMuted() ? 0.0f : 1.0f);
                        INSTANCE.logOmidAction(Intrinsics.stringPlus((String)"volumeChange ", (Object)Float.valueOf(((VolumeChangeEvent)playerEvent).isMuted() ? 0.0f : 1.0f)));
                    }
                }
                catch (Exception e) {
                    AdSession adSession = omidSession;
                    if (adSession != null) {
                        adSession.error(ErrorType.GENERIC, e.getLocalizedMessage());
                    }
                    OMHelper.logError$default(this, "Error with adSession : VolumeChangeEvent", e, null, 4, null);
                }
            } else if (playerEvent2 instanceof FullScreenChangeEvent) {
                if (playerState == null) {
                    this.onPlayerStateChanged(((FullScreenChangeEvent)playerEvent).getFullscreen() ? PlayerState.FULLSCREEN : PlayerState.NORMAL);
                }
            } else if (playerEvent2 instanceof AdTimeUpdateEvent) {
                Object object;
                String e2 = ((AdTimeUpdateEvent)playerEvent).getTime();
                double progress = (e2 == null ? 0.0 : ((object = StringsKt.toDoubleOrNull((String)e2)) == null ? 0.0 : (Double)object)) / (double)adDuration;
                Object object4 = omidCurrentPosition;
                Object object5 = object = object4 == null ? null : object4.getNextStep();
                if (object == null) {
                    return;
                }
                Object nextPosition = object;
                if (progress > (double)((Quartile)((Object)nextPosition)).getProgress()) {
                    omidCurrentPosition = nextPosition;
                    try {
                        object = omidMediaEvents;
                        if (object != null) {
                            Function1<MediaEvents, Unit> function1;
                            object4 = object;
                            boolean bl = false;
                            boolean bl15 = false;
                            Object it = object4;
                            boolean bl16 = false;
                            Quartile quartile = omidCurrentPosition;
                            if (quartile != null && (function1 = quartile.getAction()) != null) {
                                function1.invoke(it);
                            }
                        }
                    }
                    catch (Exception e) {
                        object4 = omidSession;
                        if (object4 != null) {
                            object4.error(ErrorType.GENERIC, e.getLocalizedMessage());
                        }
                        OMHelper.logError$default(this, "Error with adSession : AdTimeUpdateEvent", e, null, 4, null);
                    }
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void createOmidSession(PlayerWebView playerWebView, String payload) {
        AdSessionConfiguration adSessionConfiguration;
        Partner e2;
        Iterable $this$map$iv;
        List<VerificationScriptData> verificationScriptsList = this.parseVerificationScriptData$sdk_release(payload);
        try {
            void $this$mapTo$iv$iv;
            $this$map$iv = verificationScriptsList;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                VerificationScriptData verificationScriptData = (VerificationScriptData)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                VerificationScriptResource verificationScriptResource = VerificationScriptResource.createVerificationScriptResourceWithParameters((String)it.getVendorKey(), (URL)new URL(it.getUrl()), (String)it.getParameters());
                collection.add(verificationScriptResource);
            }
            $this$map$iv = (List)destination$iv$iv;
        }
        catch (Exception e2) {
            this.logError("Error while creating verificationScriptResourceList with payload", e2, payload);
            return;
        }
        Iterable verificationScriptResourceList = $this$map$iv;
        try {
            e2 = Partner.createPartner((String)PARTNER_NAME, (String)PARTNER_VERSION);
        }
        catch (IllegalArgumentException e3) {
            OMHelper.logError$default(this, "Error while creating partner", e3, null, 4, null);
            return;
        }
        Partner partner = e2;
        Context e3 = playerWebView.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)e3, (String)"playerWebView.context");
        AdSessionContext adSessionContext = AdSessionContext.createNativeAdSessionContext((Partner)partner, (String)OmidJsLoader.INSTANCE.getOmidJs(e3), (List)verificationScriptResourceList, null, null);
        try {
            adSessionConfiguration = AdSessionConfiguration.createAdSessionConfiguration((CreativeType)CreativeType.VIDEO, (ImpressionType)ImpressionType.ONE_PIXEL, (Owner)Owner.NATIVE, (Owner)Owner.NATIVE, (boolean)true);
        }
        catch (IllegalArgumentException e4) {
            OMHelper.logError$default(this, "Error while creating adSessionConfiguration", e4, null, 4, null);
            return;
        }
        AdSessionConfiguration adSessionConfiguration2 = adSessionConfiguration;
        omidSession = AdSession.createAdSession((AdSessionConfiguration)adSessionConfiguration2, (AdSessionContext)adSessionContext);
        adSessionConfiguration = omidSession;
        if (adSessionConfiguration != null) {
            adSessionConfiguration.registerAdView((View)playerWebView);
        }
        omidAdEvents = AdEvents.createAdEvents((AdSession)omidSession);
        omidMediaEvents = MediaEvents.createMediaEvents((AdSession)omidSession);
        omidCurrentPosition = Quartile.INIT;
    }

    public final void endOmidSession$sdk_release() {
        AdSession adSession = omidSession;
        if (adSession != null) {
            AdSession adSession2 = adSession;
            boolean bl = false;
            boolean bl2 = false;
            AdSession $this$endOmidSession_u24lambda_u2d13 = adSession2;
            boolean bl3 = false;
            $this$endOmidSession_u24lambda_u2d13.finish();
            INSTANCE.logOmidAction("Session End");
        }
        omidSession = null;
        omidAdEvents = null;
        omidMediaEvents = null;
        omidCurrentPosition = null;
        adDuration = 1.0f;
        isAdPaused = false;
    }

    private final void startOmidSession() {
        boolean bl;
        boolean bl2;
        AdSession adSession;
        AdSession adSession2 = omidSession;
        if (adSession2 != null) {
            adSession = adSession2;
            bl2 = false;
            bl = false;
            AdSession $this$startOmidSession_u24lambda_u2d14 = adSession;
            boolean bl3 = false;
            $this$startOmidSession_u24lambda_u2d14.start();
            INSTANCE.logOmidAction("Session Start");
        }
        adSession2 = playerState;
        if (adSession2 != null) {
            adSession = adSession2;
            bl2 = false;
            bl = false;
            AdSession it = adSession;
            boolean bl4 = false;
            INSTANCE.onPlayerStateChanged((PlayerState)it);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<VerificationScriptData> parseVerificationScriptData$sdk_release(@Nullable String payload) {
        List list;
        String string = payload;
        if (string == null) {
            list = null;
        } else {
            Object object = new String[]{"&"};
            List list2 = StringsKt.split$default((CharSequence)string, (String[])object, (boolean)false, (int)0, (int)6, null);
            if (list2 == null) {
                list = null;
            } else {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Object $this$filterKeys$iv;
                Object key$iv$iv;
                void $this$groupByTo$iv$iv;
                void $this$groupBy$iv;
                Object object2 = list2;
                boolean $i$f$groupBy22 = false;
                void var8_8 = $this$groupBy$iv;
                Map destination$iv$iv = new LinkedHashMap();
                boolean $i$f$groupByTo22 = false;
                for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                    Object object3;
                    String it = (String)element$iv$iv;
                    boolean bl = false;
                    Matcher m = Pattern.compile("verificationScripts\\[([0-9]*)]\\[(.*)]=(.*)").matcher(it);
                    key$iv$iv = m.matches() ? m.group(1) : null;
                    Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                    boolean $i$f$getOrPut = false;
                    Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                    if (value$iv$iv$iv == null) {
                        boolean bl2 = false;
                        List answer$iv$iv$iv = new ArrayList();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        object3 = answer$iv$iv$iv;
                    } else {
                        object3 = value$iv$iv$iv;
                    }
                    List list$iv$iv = (List)object3;
                    list$iv$iv.add(element$iv$iv);
                }
                Object $i$f$groupBy22 = object = destination$iv$iv;
                boolean $i$f$filterKeys = false;
                LinkedHashMap result$iv = new LinkedHashMap();
                void $i$f$groupByTo22 = $this$filterKeys$iv;
                boolean bl = false;
                for (Map.Entry entry$iv : $i$f$groupByTo22.entrySet()) {
                    String it = (String)entry$iv.getKey();
                    boolean bl3 = false;
                    if (!(it != null)) continue;
                    result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                }
                $this$filterKeys$iv = object2 = (Map)result$iv;
                boolean $i$f$map = false;
                result$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList($this$map$iv.size());
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv;
                boolean bl4 = false;
                for (Map.Entry item$iv$iv : iterator.entrySet()) {
                    Object object4;
                    Object v4;
                    Object object5;
                    Object object6;
                    String string2;
                    Iterable iterable;
                    Object object7;
                    Collection collection;
                    block14: {
                        Object object8;
                        Object object9;
                        Object object10;
                        void group;
                        block13: {
                            Object object11;
                            Object object12;
                            Object object132;
                            block12: {
                                key$iv$iv = item$iv$iv;
                                collection = destination$iv$iv2;
                                boolean bl5 = false;
                                object7 = (Iterable)group.getValue();
                                boolean bl6 = false;
                                iterable = object7;
                                boolean bl7 = false;
                                for (Object object132 : iterable) {
                                    String it = (String)object132;
                                    boolean bl8 = false;
                                    if (!StringsKt.contains$default((CharSequence)it, (CharSequence)("verificationScripts[" + group.getKey() + "][vendor]"), (boolean)false, (int)2, null)) continue;
                                    object12 = object132;
                                    break block12;
                                }
                                object12 = null;
                            }
                            string2 = (String)object12;
                            object6 = string2 == null ? "" : ((object7 = StringsKt.split$default((CharSequence)string2, (String[])(object11 = new String[]{"="}), (boolean)false, (int)2, (int)2, null)) == null ? "" : ((object11 = (String)object7.get(1)) == null ? "" : object11));
                            object5 = (Iterable)group.getValue();
                            boolean bl9 = false;
                            Iterable iterable2 = object5;
                            boolean bl10 = false;
                            object132 = iterable2.iterator();
                            while (object132.hasNext()) {
                                object10 = object132.next();
                                String it = (String)object10;
                                boolean bl11 = false;
                                if (!StringsKt.contains$default((CharSequence)it, (CharSequence)("verificationScripts[" + group.getKey() + "][resource]"), (boolean)false, (int)2, null)) continue;
                                object9 = object10;
                                break block13;
                            }
                            object9 = null;
                        }
                        object7 = (String)object9;
                        string2 = object7 == null ? "" : ((object5 = StringsKt.split$default((CharSequence)((CharSequence)object7), (String[])(object8 = new String[]{"="}), (boolean)false, (int)2, (int)2, null)) == null ? "" : ((object8 = (String)object5.get(1)) == null ? "" : object8));
                        iterable = (Iterable)group.getValue();
                        boolean bl12 = false;
                        Iterable iterable3 = iterable;
                        boolean bl13 = false;
                        object10 = iterable3.iterator();
                        while (object10.hasNext()) {
                            Object e = object10.next();
                            String it = (String)e;
                            boolean bl14 = false;
                            if (!StringsKt.contains$default((CharSequence)it, (CharSequence)("verificationScripts[" + group.getKey() + "][parameters]"), (boolean)false, (int)2, null)) continue;
                            v4 = e;
                            break block14;
                        }
                        v4 = null;
                    }
                    object5 = v4;
                    object7 = object5 == null ? "" : ((iterable = StringsKt.split$default((CharSequence)((CharSequence)object5), (String[])(object4 = new String[]{"="}), (boolean)false, (int)2, (int)2, null)) == null ? "" : ((object4 = (String)iterable.get(1)) == null ? "" : object4));
                    VerificationScriptData verificationScriptData = new VerificationScriptData(string2, (String)object6, (String)object7);
                    collection.add(verificationScriptData);
                }
                list = (List)destination$iv$iv2;
            }
        }
        List list3 = list;
        return list3 == null ? CollectionsKt.emptyList() : list3;
    }

    private final void onPlayerStateChanged(PlayerState state) {
        try {
            MediaEvents mediaEvents = omidMediaEvents;
            if (mediaEvents != null) {
                MediaEvents mediaEvents2 = mediaEvents;
                boolean bl = false;
                boolean bl2 = false;
                MediaEvents $this$onPlayerStateChanged_u24lambda_u2d22 = mediaEvents2;
                boolean bl3 = false;
                $this$onPlayerStateChanged_u24lambda_u2d22.playerStateChange(state);
                INSTANCE.logOmidAction(Intrinsics.stringPlus((String)"PlayerState => ", (Object)state));
            }
        }
        catch (Exception e) {
            AdSession adSession = omidSession;
            if (adSession != null) {
                adSession.error(ErrorType.GENERIC, e.getLocalizedMessage());
            }
            OMHelper.logError$default(this, "Error with adSession : PlayerState", e, null, 4, null);
        }
    }

    private final void logError(String error, Exception exception, String debug) {
        Timber.e((Throwable)exception, (String)Intrinsics.stringPlus((String)"OMSDK: ERROR : ", (Object)error), (Object[])new Object[0]);
        OMErrorListener oMErrorListener = omErrorListener;
        if (oMErrorListener != null) {
            oMErrorListener.onOMSDKError(error, exception, debug);
        }
    }

    static /* synthetic */ void logError$default(OMHelper oMHelper, String string, Exception exception, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        oMHelper.logError(string, exception, string2);
    }

    private final void logOmidAction(String message) {
        Timber.d((String)Intrinsics.stringPlus((String)"OMSDK: ", (Object)message), (Object[])new Object[0]);
    }

    public final String getVersion$sdk_release() {
        return Omid.getVersion();
    }

    public final void setOMErrorListener(@Nullable OMErrorListener errorListener) {
        omErrorListener = errorListener;
    }

    static {
        adDuration = 1.0f;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\r\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B3\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u0012\u0016\b\u0002\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\tR\u001f\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014\u00a8\u0006\u0015"}, d2={"Lcom/dailymotion/android/player/sdk/iab/OMHelper$Quartile;", "", "progress", "", "nextStep", "action", "Lkotlin/Function1;", "Lcom/iab/omid/library/dailymotion/adsession/media/MediaEvents;", "", "(Ljava/lang/String;IFLcom/dailymotion/android/player/sdk/iab/OMHelper$Quartile;Lkotlin/jvm/functions/Function1;)V", "getAction", "()Lkotlin/jvm/functions/Function1;", "getNextStep", "()Lcom/dailymotion/android/player/sdk/iab/OMHelper$Quartile;", "getProgress", "()F", "Q3", "Q2", "Q1", "START", "INIT", "sdk_release"})
    private static final class Quartile
    extends Enum<Quartile> {
        private final float progress;
        @Nullable
        private final Quartile nextStep;
        @Nullable
        private final Function1<MediaEvents, Unit> action;
        public static final /* enum */ Quartile Q3 = new Quartile(0.75f, null, (Function1<? super MediaEvents, Unit>)((Function1)1.INSTANCE));
        public static final /* enum */ Quartile Q2 = new Quartile(0.5f, Q3, (Function1<? super MediaEvents, Unit>)((Function1)2.INSTANCE));
        public static final /* enum */ Quartile Q1 = new Quartile(0.25f, Q2, (Function1<? super MediaEvents, Unit>)((Function1)3.INSTANCE));
        public static final /* enum */ Quartile START = new Quartile(0.0f, Q1, (Function1<? super MediaEvents, Unit>)((Function1)4.INSTANCE));
        public static final /* enum */ Quartile INIT = new Quartile("INIT", 4, 0.0f, START, null, 4, null);
        private static final /* synthetic */ Quartile[] $VALUES;

        private Quartile(float progress, Quartile nextStep, Function1<? super MediaEvents, Unit> action) {
            this.progress = progress;
            this.nextStep = nextStep;
            this.action = action;
        }

        /* synthetic */ Quartile(String string, int n, float f, Quartile quartile, Function1 function1, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                quartile = null;
            }
            if ((n2 & 4) != 0) {
                function1 = null;
            }
            this(f, quartile, (Function1<? super MediaEvents, Unit>)function1);
        }

        public final float getProgress() {
            return this.progress;
        }

        @Nullable
        public final Quartile getNextStep() {
            return this.nextStep;
        }

        @Nullable
        public final Function1<MediaEvents, Unit> getAction() {
            return this.action;
        }

        public static Quartile[] values() {
            return (Quartile[])$VALUES.clone();
        }

        public static Quartile valueOf(String value) {
            return Enum.valueOf(Quartile.class, value);
        }

        static {
            $VALUES = quartileArray = new Quartile[]{Quartile.Q3, Quartile.Q2, Quartile.Q1, Quartile.START, Quartile.INIT};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J&\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0005H&\u00a8\u0006\n"}, d2={"Lcom/dailymotion/android/player/sdk/iab/OMHelper$OMErrorListener;", "", "onOMSDKError", "", "description", "", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "debug", "sdk_release"})
    public static interface OMErrorListener {
        public void onOMSDKError(@NotNull String var1, @NotNull Exception var2, @Nullable String var3);
    }
}

