/*
 * Decompiled with CFR 0.152.
 */
package org.ayo.view.status;

import android.content.Context;
import android.view.View;
import java.util.HashMap;
import java.util.Map;
import org.ayo.view.status.DefaultStatusProvider;
import org.ayo.view.status.StatusProvider;

public class StatusUIManager {
    private Context context;
    private View contentView;
    private Map<String, StatusProvider> map = new HashMap<String, StatusProvider>();
    private StatusProvider currentStatusProvider;
    public DefaultStatusProvider.DefaultErrorStatusView.OnRetryClickListener onRetryClickListener;

    public StatusUIManager(Context context, View contentView) {
        this.context = context;
        this.contentView = contentView;
    }

    public void addStatusProvider(StatusProvider p) {
        this.map.put(p.getStatus(), p);
    }

    private void show(String status) {
        StatusProvider p;
        if (this.currentStatusProvider != null) {
            this.currentStatusProvider.hideStatusView();
        }
        if ((p = this.map.get(status)) != null) {
            p.showStatusView();
            this.currentStatusProvider = p;
        }
    }

    public void showContentView() {
        if (this.currentStatusProvider != null) {
            this.currentStatusProvider.hideStatusView();
            this.currentStatusProvider.showContentView();
        }
    }

    public void showLoading() {
        this.addStatusProvider(new DefaultStatusProvider.DefaultLoadingStatusView(this.context, "loading", this.contentView));
        this.show("loading");
    }

    public void showEmpty() {
        this.addStatusProvider(new DefaultStatusProvider.DefaultEmptyStatusView(this.context, "empty", this.contentView));
        this.show("empty");
    }

    public void showError() {
        this.addStatusProvider(new DefaultStatusProvider.DefaultErrorStatusView(this.context, "local-error", this.contentView, this.onRetryClickListener));
        this.show("local-error");
    }

    public void setOnRetryClickListener(DefaultStatusProvider.DefaultErrorStatusView.OnRetryClickListener onRetryClickListener) {
        this.onRetryClickListener = onRetryClickListener;
    }
}

