/*
 * Decompiled with CFR 0.152.
 */
package org.ayo.view.status;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.FrameLayout;

public abstract class StatusProvider {
    protected View statusView;
    protected Context mContext;
    protected FrameLayout container;
    protected View contentView;
    protected String status;

    public StatusProvider(Context context, String status, View contentView) {
        this.mContext = context;
        this.status = status;
        this.contentView = contentView;
        if (contentView == null) {
            throw new RuntimeException("contentView\u4e0d\u80fd\u4e3anull");
        }
        ViewParent p = this.contentView.getParent();
        if (!(p instanceof FrameLayout)) {
            throw new RuntimeException(contentView.getClass().getName() + "\u5fc5\u987b\u4f5c\u4e3aFrameLayout\u7684\u5b50\u5143\u7d20");
        }
        this.container = (FrameLayout)p;
    }

    public String getStatus() {
        return this.status;
    }

    public abstract View getStatusView();

    public void showStatusView() {
        if (this.statusView == null) {
            this.statusView = this.getStatusView();
            FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-1, -1);
            this.container.addView(this.statusView, (ViewGroup.LayoutParams)lp);
        }
        this.statusView.setVisibility(0);
        this.statusView.bringToFront();
    }

    public void hideStatusView() {
        if (this.statusView != null) {
            this.statusView.setVisibility(8);
        }
    }

    public void showContentView() {
        this.contentView.setVisibility(0);
        this.contentView.bringToFront();
    }
}

