/*
 * Decompiled with CFR 0.152.
 */
package com.dahuatech.icc.oauth.utils;

import com.dahuatech.hutool.http.Method;
import com.dahuatech.hutool.json.JSONUtil;
import com.dahuatech.icc.exception.ClientException;
import com.dahuatech.icc.oauth.http.IccClient;
import com.dahuatech.icc.oauth.http.IccResponse;
import com.dahuatech.icc.oauth.http.IccTokenResponse;
import com.dahuatech.icc.oauth.model.v202010.GeneralRequest;
import com.dahuatech.icc.oauth.model.v202010.OauthConfigUserPwdInfo;
import com.dahuatech.icc.util.CollectionUtil;
import java.util.Map;

public class HttpUtils {
    public static <T extends IccResponse> T execute(String url, Object jsonData, Map formParams, Map<String, String> headers, Method method, OauthConfigUserPwdInfo config, Class<T> responseClass) throws ClientException {
        IccClient iClient = new IccClient(config);
        GeneralRequest generalRequest = new GeneralRequest(config.getHttpConfigInfo(), url, method);
        if (jsonData != null) {
            generalRequest.body(JSONUtil.toJsonStr((Object)jsonData));
        }
        if (formParams != null) {
            generalRequest.form(formParams);
        }
        if (!CollectionUtil.isEmpty(headers)) {
            generalRequest.setHeader(headers);
        }
        return iClient.doAction(generalRequest, responseClass);
    }

    public static <T extends IccResponse> T executeJson(String url, Object jsonData, Map<String, String> headers, Method method, OauthConfigUserPwdInfo config, Class<T> responseClass) throws ClientException {
        return HttpUtils.execute(url, jsonData, null, headers, method, config, responseClass);
    }

    public static <T extends IccResponse> T executeForm(String url, Map<String, Object> formParams, Map<String, String> headers, Method method, OauthConfigUserPwdInfo config, Class<T> responseClass) throws ClientException {
        return HttpUtils.execute(url, null, formParams, headers, method, config, responseClass);
    }

    public static IccTokenResponse.IccToken getToken(OauthConfigUserPwdInfo config) throws ClientException {
        IccClient iClient = new IccClient(config);
        return iClient.getAccessToken();
    }
}

