/*
 * Decompiled with CFR 0.152.
 */
package com.dahuatech.icc.oauth.http;

import com.dahuatech.hutool.core.util.StrUtil;
import com.dahuatech.hutool.http.HttpResponse;
import com.dahuatech.hutool.json.JSONUtil;
import com.dahuatech.hutool.log.Log;
import com.dahuatech.hutool.log.LogFactory;
import com.dahuatech.icc.exception.ClientException;
import com.dahuatech.icc.exception.ServerException;
import com.dahuatech.icc.oauth.handle.InitVersionProcessor;
import com.dahuatech.icc.oauth.handle.LoadHttpConfigInfo;
import com.dahuatech.icc.oauth.handle.TokenHandlerProcessor;
import com.dahuatech.icc.oauth.http.AbstractIClient;
import com.dahuatech.icc.oauth.http.IccHttpHttpRequest;
import com.dahuatech.icc.oauth.http.IccResponse;
import com.dahuatech.icc.oauth.http.IccTokenResponse;
import com.dahuatech.icc.oauth.model.v202010.OauthConfigBaseInfo;
import com.dahuatech.icc.oauth.profile.GrantType;
import com.dahuatech.icc.oauth.profile.IccProfile;
import com.dahuatech.icc.oauth.unmarshaller.JsonUnmashaller;
import com.dahuatech.icc.oauth.unmarshaller.Unmarshaller;
import com.dahuatech.icc.oauth.utils.LogUtils;

public class IccClient
extends AbstractIClient {
    private static final Log logger = LogFactory.get();
    private TokenHandlerProcessor tokenHandleSingle;
    private Unmarshaller unmarshaller;
    private OauthConfigBaseInfo oauthConfigBaseInfo;

    public IccClient() throws ClientException {
        LoadHttpConfigInfo.getInstance().loadIccSdkProperties();
        this.tokenHandleSingle = TokenHandlerProcessor.getInstance();
        this.unmarshaller = new JsonUnmashaller();
        this.oauthConfigBaseInfo = LoadHttpConfigInfo.getInstance().getOauthConfigBaseInfo();
    }

    public IccClient(OauthConfigBaseInfo oauthConfigBaseInfo) throws ClientException {
        this.oauthConfigBaseInfo = oauthConfigBaseInfo;
        this.tokenHandleSingle = TokenHandlerProcessor.getInstance();
        this.unmarshaller = new JsonUnmashaller();
        InitVersionProcessor.getInstance().initSystemVersion(oauthConfigBaseInfo.getHttpConfigInfo());
    }

    @Override
    public String doAction(IccHttpHttpRequest request) throws ClientException, ServerException {
        IccHttpHttpRequest iccHttpRequest = this.signRequest(request);
        String httpResult = iccHttpRequest.execute();
        logger.debug("response httpResult =[{}]", new Object[]{httpResult});
        return httpResult;
    }

    @Override
    public <T extends IccResponse> T doAction(IccHttpHttpRequest request, Class<T> tClass) throws ClientException, ServerException {
        IccHttpHttpRequest iccHttpRequest = this.signRequest(request);
        String uuid = request.getRequestUniqueCode();
        LogUtils.printIn(logger, request);
        HttpResponse httpResult = iccHttpRequest.executeResponse();
        String result = httpResult.body();
        LogUtils.printOut(logger, uuid, result);
        T t = this.unmarshal(tClass, result);
        ((IccResponse)t).setResult(result);
        if (!((IccResponse)t).isSuccess() && ("27001000".equals(((IccResponse)t).getCode()) || "27001007".equals(((IccResponse)t).getCode()))) {
            TokenHandlerProcessor.getInstance().clearExpiredToken(this.oauthConfigBaseInfo);
        }
        return t;
    }

    @Override
    public synchronized IccTokenResponse.IccToken getAccessToken(GrantType grantType) {
        IccTokenResponse.IccToken token = this.tokenHandleSingle.getTokenCache(this.oauthConfigBaseInfo);
        if (token != null) {
            return token;
        }
        token = this.tokenHandleSingle.oauth(this.oauthConfigBaseInfo);
        return token;
    }

    @Override
    public IccTokenResponse.IccToken getAccessToken() {
        IccTokenResponse.IccToken token = this.tokenHandleSingle.getTokenCache(this.oauthConfigBaseInfo);
        if (token != null) {
            return token;
        }
        token = this.tokenHandleSingle.oauth(this.oauthConfigBaseInfo);
        return token;
    }

    @Override
    IccHttpHttpRequest signRequest(IccHttpHttpRequest request) {
        if (request.isNeedAuth()) {
            IccTokenResponse.IccToken token = this.getAccessToken();
            request.header("Authorization", "bearer " + (token != null ? token.getAccess_token() : ""));
            if (GrantType.password == this.oauthConfigBaseInfo.getGrantType()) {
                request.header("User-Id", token != null ? token.getUserId() : IccProfile.CONFIG_CLIENT_USERID);
            }
            if (GrantType.client_credentials == this.oauthConfigBaseInfo.getGrantType() && IccProfile.CONFIG_CLIENT_USERID_ENABLE) {
                request.header("User-Id", IccProfile.CONFIG_CLIENT_USERID);
            }
        }
        if (request.getBodyParameters().size() > 0 && StrUtil.isBlank((CharSequence)request.getBody())) {
            request.body(JSONUtil.toJsonStr(request.getBodyParameters()));
        }
        return request;
    }

    @Override
    public <T extends IccResponse> T unmarshal(Class<T> clasz, String content) throws ClientException {
        return this.unmarshaller.unmarshal(clasz, content);
    }

    public OauthConfigBaseInfo getOauthConfigBaseInfo() {
        return this.oauthConfigBaseInfo;
    }
}

