/*
 * Decompiled with CFR 0.152.
 */
package com.dahuatech.icc.oauth.http;

import com.dahuatech.hutool.core.util.StrUtil;
import com.dahuatech.hutool.http.HttpResponse;
import com.dahuatech.hutool.json.JSONUtil;
import com.dahuatech.hutool.log.Log;
import com.dahuatech.hutool.log.LogFactory;
import com.dahuatech.icc.exception.ClientException;
import com.dahuatech.icc.exception.ServerException;
import com.dahuatech.icc.oauth.handle.TokenHandleSingle;
import com.dahuatech.icc.oauth.http.AbstractIClient;
import com.dahuatech.icc.oauth.http.IccHttpHttpRequest;
import com.dahuatech.icc.oauth.http.IccResponse;
import com.dahuatech.icc.oauth.http.IccTokenResponse;
import com.dahuatech.icc.oauth.profile.GrantType;
import com.dahuatech.icc.oauth.profile.IccProfile;
import com.dahuatech.icc.oauth.unmarshaller.JsonUnmashaller;
import com.dahuatech.icc.oauth.unmarshaller.Unmarshaller;
import com.dahuatech.icc.oauth.utils.LogUtils;

public class DefaultClient
extends AbstractIClient {
    private static final Log logger = LogFactory.get();
    private TokenHandleSingle tokenHandleSingle;
    private Unmarshaller unmarshaller;
    private boolean isPrintLogInfo = true;

    public DefaultClient() throws ClientException {
        IccProfile.getInstance().init();
        this.tokenHandleSingle = TokenHandleSingle.getInstance();
        this.unmarshaller = new JsonUnmashaller();
    }

    public DefaultClient(String host, String clientId, String clientSecret) throws ClientException {
        throw new ClientException("GrantType type [client_credentials]  not support");
    }

    public DefaultClient(String host, String username, String password, String pwdClientId, String pwdClientSecret) throws ClientException {
        this.init(host, username, password, pwdClientId, pwdClientSecret);
    }

    private void init(String host, String clientId, String clientSecret) throws ClientException {
        this.init(host, null, null, clientId, clientSecret, GrantType.client_credentials);
    }

    private void init(String host, String username, String password, String pwdClientId, String pwdClientSecret) throws ClientException {
        this.init(host, username, password, pwdClientId, pwdClientSecret, GrantType.password);
    }

    private void init(String host, String username, String password, String pwdClientId, String pwdClientSecret, GrantType grantType) throws ClientException {
        if (IccProfile.inited && IccProfile.host != null && !IccProfile.host.equals(host)) {
            TokenHandleSingle.getInstance().getTokenMap().clear();
        }
        IccProfile.host = host;
        IccProfile.grantType = grantType;
        switch (grantType) {
            case password: {
                IccProfile.pwdClientSecret = pwdClientSecret;
                IccProfile.pwdClientId = pwdClientId;
                break;
            }
            case client_credentials: {
                IccProfile.clientId = pwdClientId;
                IccProfile.clientSecret = pwdClientSecret;
                break;
            }
        }
        IccProfile.password = password;
        IccProfile.username = username;
        IccProfile.inited = Boolean.FALSE;
        IccProfile.getInstance().init();
        this.tokenHandleSingle = TokenHandleSingle.getInstance();
        this.unmarshaller = new JsonUnmashaller();
    }

    @Override
    public String doAction(IccHttpHttpRequest request) throws ClientException, ServerException {
        IccHttpHttpRequest iccHttpRequest = this.signRequest(request);
        String httpResult = iccHttpRequest.execute();
        logger.debug("response httpResult =[{}]", new Object[]{httpResult});
        return httpResult;
    }

    @Override
    public <T extends IccResponse> T doAction(IccHttpHttpRequest request, Class<T> tClass) throws ClientException, ServerException {
        IccHttpHttpRequest iccHttpRequest = this.signRequest(request);
        String uuid = request.getRequestUniqueCode();
        LogUtils.printIn(logger, request);
        HttpResponse httpResult = iccHttpRequest.executeResponse();
        String result = httpResult.body();
        LogUtils.printOut(logger, uuid, result);
        T t = this.unmarshal(tClass, result);
        ((IccResponse)t).setResult(result);
        if (!((IccResponse)t).isSuccess() && ("27001000".equals(((IccResponse)t).getCode()) || "27001007".equals(((IccResponse)t).getCode()))) {
            TokenHandleSingle.getInstance().clearExpiredToken();
            return t;
        }
        return t;
    }

    @Override
    public synchronized IccTokenResponse.IccToken getAccessToken(GrantType grantType) {
        IccTokenResponse.IccToken token = this.tokenHandleSingle.getTokenCache(grantType.name());
        if (token != null) {
            return token;
        }
        token = this.tokenHandleSingle.refreshToken(grantType);
        return token;
    }

    @Override
    public IccTokenResponse.IccToken getAccessToken() {
        return this.getAccessToken(IccProfile.grantType);
    }

    @Override
    IccHttpHttpRequest signRequest(IccHttpHttpRequest request) {
        if (request.isNeedAuth()) {
            IccTokenResponse.IccToken token = this.getAccessToken(IccProfile.grantType);
            request.header("Authorization", "bearer " + (token != null ? token.getAccess_token() : ""));
            if (IccProfile.grantType.equals((Object)GrantType.password)) {
                request.header("User-Id", token != null ? token.getUserId() : IccProfile.CONFIG_CLIENT_USERID);
            }
            if (IccProfile.grantType.equals((Object)GrantType.client_credentials) && IccProfile.CONFIG_CLIENT_USERID_ENABLE) {
                request.header("User-Id", IccProfile.CONFIG_CLIENT_USERID);
            }
        }
        if (request.getBodyParameters().size() > 0 && StrUtil.isBlank((CharSequence)request.getBody())) {
            request.body(JSONUtil.toJsonStr(request.getBodyParameters()));
        }
        return request;
    }

    @Override
    public <T extends IccResponse> T unmarshal(Class<T> clasz, String content) throws ClientException {
        return this.unmarshaller.unmarshal(clasz, content);
    }

    public boolean isPrintLogInfo() {
        return this.isPrintLogInfo;
    }

    public void setPrintLogInfo(boolean printLogInfo) {
        this.isPrintLogInfo = printLogInfo;
    }
}

