/*
 * Decompiled with CFR 0.152.
 */
package com.dahuatech.icc.oauth.handle;

import com.dahuatech.hutool.core.date.DateUtil;
import com.dahuatech.hutool.core.thread.NamedThreadFactory;
import com.dahuatech.hutool.http.Method;
import com.dahuatech.hutool.json.JSONUtil;
import com.dahuatech.hutool.log.Log;
import com.dahuatech.hutool.log.LogFactory;
import com.dahuatech.icc.exception.ClientException;
import com.dahuatech.icc.exception.ServerException;
import com.dahuatech.icc.oauth.constant.OauthConstant;
import com.dahuatech.icc.oauth.http.DefaultClient;
import com.dahuatech.icc.oauth.http.IccHttpHttpRequest;
import com.dahuatech.icc.oauth.http.IccTokenResponse;
import com.dahuatech.icc.oauth.model.v202010.BrmKeepAliveRequest;
import com.dahuatech.icc.oauth.model.v202010.BrmKeepAliveResponse;
import com.dahuatech.icc.oauth.model.v202010.OauthPublicKeyResponse;
import com.dahuatech.icc.oauth.model.v202010.OauthRefreshTokenRequest;
import com.dahuatech.icc.oauth.model.v202010.OauthRefreshTokenResponse;
import com.dahuatech.icc.oauth.profile.GrantType;
import com.dahuatech.icc.oauth.profile.IccProfile;
import com.dahuatech.icc.oauth.utils.LogUtils;
import com.dahuatech.icc.util.BeanUtil;
import com.dahuatech.icc.util.SignUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class TokenHandleSingle {
    private static final Log logger = LogFactory.get();
    private static final AtomicBoolean TOKEN_INITED = new AtomicBoolean(Boolean.FALSE);
    private static final long FRESH_TOKEN_INTERVAL = 30000L;
    private final ScheduledExecutorService REFRESH_TOKEN_SCHEDULED = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("Icc-Refresh-Token-Old", true));
    private final Map<String, IccTokenResponse.IccToken> tokenMap = new ConcurrentHashMap<String, IccTokenResponse.IccToken>();

    public Map<String, IccTokenResponse.IccToken> getTokenMap() {
        return this.tokenMap;
    }

    private TokenHandleSingle() {
        this.REFRESH_TOKEN_SCHEDULED.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    TokenHandleSingle.this.refreshTokenAndKeepAlive();
                }
                catch (Throwable t) {
                    logger.error("Unexpected error occur at token refresh, cause: " + t.getMessage(), new Object[]{t});
                }
            }
        }, 30000L, 30000L, TimeUnit.MILLISECONDS);
    }

    public static synchronized TokenHandleSingle getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public synchronized IccTokenResponse.IccToken refreshToken(GrantType grantType) {
        IccTokenResponse.IccToken token = null;
        try {
            switch (grantType) {
                case password: {
                    token = this.password();
                    break;
                }
                case client_credentials: {
                    token = this.clientCredentials();
                    break;
                }
            }
        }
        catch (ClientException e) {
            logger.error("get token failure", new Object[0]);
        }
        if (!TOKEN_INITED.get() && token != null) {
            TOKEN_INITED.set(Boolean.TRUE);
        }
        return token;
    }

    private IccTokenResponse.IccToken password() throws ClientException, ServerException {
        IccHttpHttpRequest pubRequest = new IccHttpHttpRequest(OauthConstant.url("/evo-apigw/evo-oauth/%s/oauth/public-key"), Method.GET);
        String pubBody = pubRequest.execute();
        LogUtils.printOut(logger, pubRequest.getRequestUniqueCode(), pubBody);
        OauthPublicKeyResponse keyResp = (OauthPublicKeyResponse)BeanUtil.toBean((String)pubBody, OauthPublicKeyResponse.class);
        if (keyResp.getData() == null) {
            logger.error("get public key faiure [{}]", new Object[]{"/evo-apigw/evo-oauth/%s/oauth/public-key"});
            throw new ServerException("get public key faiure");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("grant_type", "password");
        map.put("username", IccProfile.username);
        map.put("password", SignUtil.encryptRSANew((String)IccProfile.password, (String)keyResp.getData().getPublicKey()));
        map.put("client_id", IccProfile.pwdClientId);
        map.put("client_secret", IccProfile.pwdClientSecret);
        map.put("public_key", keyResp.getData().getPublicKey());
        IccHttpHttpRequest pr = new IccHttpHttpRequest(OauthConstant.url("/evo-apigw/evo-oauth/%s/oauth/extend/token"), Method.POST, JSONUtil.toJsonStr(map));
        LogUtils.printIn(logger, pr);
        String prBody = pr.execute();
        LogUtils.printOut(logger, pr.getRequestUniqueCode(), prBody);
        IccTokenResponse token = (IccTokenResponse)BeanUtil.toBean((String)prBody, IccTokenResponse.class);
        if (token == null || !token.isSuccess()) {
            logger.error(" auth failure [{}] reason [{}]", new Object[]{OauthConstant.url("/evo-apigw/evo-oauth/%s/oauth/extend/token"), token == null ? "" : token.getErrMsg()});
            throw new ClientException("GrantType [password] username=[" + IccProfile.username + "],password=[" + IccProfile.password + "] get access_token failure");
        }
        IccTokenResponse.IccToken iccToken = token.getData();
        iccToken.setTtl(System.currentTimeMillis() + iccToken.getExpires_in() * 1000L);
        iccToken.setExpireDate(DateUtil.formatBetween((long)iccToken.getTtl()));
        iccToken.setExpireDate(DateUtil.formatBetween((long)iccToken.getTtl()));
        this.tokenMap.put(this.enGrantKeyName(GrantType.password.name()), iccToken);
        return iccToken;
    }

    private IccTokenResponse.IccToken clientCredentials() throws ClientException, ServerException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("grant_type", "client_credentials");
        map.put("client_id", IccProfile.clientId);
        map.put("client_secret", IccProfile.clientSecret);
        IccHttpHttpRequest cr = new IccHttpHttpRequest(OauthConstant.url("/evo-apigw/evo-oauth/oauth/token"), Method.POST);
        LogUtils.printIn(logger, cr);
        cr.form(map);
        String crBody = cr.execute();
        LogUtils.printOut(logger, cr.getRequestUniqueCode(), crBody);
        IccTokenResponse token = (IccTokenResponse)BeanUtil.toBean((String)crBody, IccTokenResponse.class);
        if (token == null || !token.isSuccess()) {
            logger.error("client auth failure [{}] reason [{}]", new Object[]{OauthConstant.url("/evo-apigw/evo-oauth/oauth/token"), token == null ? "" : token.getErrMsg()});
            throw new ClientException("client auth failure" + (token == null ? "" : token.getErrMsg()));
        }
        IccTokenResponse.IccToken iccToken = token.getData();
        iccToken.setTtl(System.currentTimeMillis() + iccToken.getExpires_in() * 1000L);
        this.tokenMap.put(this.enGrantKeyName(GrantType.client_credentials.name()), iccToken);
        return iccToken;
    }

    public IccTokenResponse.IccToken getTokenCache(String grantType) {
        if (this.REFRESH_TOKEN_SCHEDULED.isShutdown() || this.REFRESH_TOKEN_SCHEDULED.isTerminated()) {
            logger.warn("\u5b9a\u65f6\u4efb\u52a1\u8fdb\u7a0b\u5f02\u5e38\u5173\u95ed\uff0c\u91cd\u65b0\u52a0\u8f7d", new Object[0]);
            this.REFRESH_TOKEN_SCHEDULED.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    try {
                        TokenHandleSingle.this.refreshTokenAndKeepAlive();
                    }
                    catch (Throwable t) {
                        logger.error("Unexpected error occur at token refresh, cause: " + t.getMessage(), new Object[]{t});
                    }
                }
            }, 30000L, 30000L, TimeUnit.MILLISECONDS);
        }
        String key = this.enGrantKeyName(grantType);
        IccTokenResponse.IccToken token = this.tokenMap.get(this.enGrantKeyName(grantType));
        Long currentTime = System.currentTimeMillis();
        if (token != null && token.getTtl() < currentTime) {
            logger.warn("[{}]\u7684token\u5df2\u8fc7\u671f\uff0c\u6e05\u7406token\u4fe1\u606f\uff1a{}", new Object[]{key, JSONUtil.toJsonStr((Object)token)});
            this.clearExpiredToken();
            return null;
        }
        return this.tokenMap.get(this.enGrantKeyName(grantType));
    }

    public IccTokenResponse.IccToken refreshToken(GrantType grantType, String refreshToken) {
        try {
            DefaultClient iClient = new DefaultClient();
            OauthRefreshTokenRequest refreshTokenRequest = new OauthRefreshTokenRequest();
            if (grantType.equals((Object)GrantType.password)) {
                refreshTokenRequest.setClient_id(IccProfile.pwdClientId);
                refreshTokenRequest.setClient_secret(IccProfile.pwdClientSecret);
                refreshTokenRequest.setGrant_type(GrantType.refresh_token.name());
                refreshTokenRequest.setRefresh_token(refreshToken);
                OauthRefreshTokenResponse refreshTokenResponse = iClient.doAction(refreshTokenRequest, refreshTokenRequest.getResponseClass());
                if (refreshTokenResponse.isSuccess()) {
                    OauthRefreshTokenResponse.IccReFreshToken freshToken = refreshTokenResponse.getData();
                    IccTokenResponse.IccToken iccToken = new IccTokenResponse.IccToken();
                    iccToken.setTtl(System.currentTimeMillis() + freshToken.getExpires_in() * 1000L);
                    iccToken.setAccess_token(freshToken.getAccess_token());
                    iccToken.setExpires_in(freshToken.getExpires_in());
                    iccToken.setMagicId(freshToken.getMagicId());
                    iccToken.setUserId(freshToken.getUserId());
                    iccToken.setToken_type(freshToken.getToken_type());
                    iccToken.setRefresh_token(freshToken.getRefresh_token());
                    iccToken.setScope(freshToken.getScope());
                    return iccToken;
                }
            }
            if (grantType.equals((Object)GrantType.client_credentials)) {
                return this.clientCredentials();
            }
        }
        catch (ClientException e) {
            logger.error("fresh token error , grantType=[{}],freshToken=[{}]", new Object[]{grantType.name(), refreshToken});
        }
        return null;
    }

    private void refreshTokenAndKeepAlive() {
        if (TOKEN_INITED.get() && this.tokenMap.size() > 0) {
            for (Map.Entry<String, IccTokenResponse.IccToken> entry : this.tokenMap.entrySet()) {
                GrantType grantType;
                IccTokenResponse.IccToken token = entry.getValue();
                Long currentTime = System.currentTimeMillis();
                if (token.getTtl() - currentTime > 120000L || (token = this.refreshToken(grantType = this.deGrantType(entry.getKey()), token.getRefresh_token())) == null) continue;
                this.tokenMap.put(entry.getKey(), token);
                logger.debug("refresh token success, [{}],token=[{}]", new Object[]{entry.getKey(), token});
            }
            this.keepalive();
        }
    }

    private void keepalive() {
        try {
            DefaultClient iClient = new DefaultClient();
            if (IccProfile.inited) {
                for (Map.Entry<String, IccTokenResponse.IccToken> entry : this.tokenMap.entrySet()) {
                    if (GrantType.client_credentials == this.deGrantType(entry.getKey())) continue;
                    IccTokenResponse.IccToken token = entry.getValue();
                    BrmKeepAliveRequest request = new BrmKeepAliveRequest();
                    request.setMagicId(token.getMagicId());
                    request.setClientType(OauthConstant.ClientType.WEB.getClientType());
                    BrmKeepAliveResponse brmKeepAliveResponse = iClient.doAction(request, request.getResponseClass());
                    if (brmKeepAliveResponse.isSuccess()) {
                        logger.debug("evo-brm [{}] keeplive success", new Object[]{entry.getKey()});
                        continue;
                    }
                    if (!"27001007".equalsIgnoreCase(brmKeepAliveResponse.getCode())) continue;
                    logger.info("[{}] token invalid , get new token", new Object[]{entry.getKey()});
                    this.tokenMap.remove(entry.getKey());
                    this.refreshToken(this.deGrantType(entry.getKey()));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("keepalive error = {}", new Object[]{e});
        }
    }

    private String enGrantKeyName(String grantType) {
        return grantType + ":" + IccProfile.host;
    }

    private GrantType deGrantType(String grantKeyName) {
        return GrantType.valueOf(grantKeyName.substring(0, grantKeyName.indexOf(":")));
    }

    public void clearExpiredToken() {
        this.tokenMap.clear();
    }

    private static class SingletonHolder {
        private static final TokenHandleSingle INSTANCE = new TokenHandleSingle();

        private SingletonHolder() {
        }
    }
}

