/*
 * Decompiled with CFR 0.152.
 */
package com.dahuatech.hutool.crypto.asymmetric;

import com.dahuatech.hutool.core.util.CharsetUtil;
import com.dahuatech.hutool.crypto.CryptoException;
import com.dahuatech.hutool.crypto.SecureUtil;
import com.dahuatech.hutool.crypto.asymmetric.AsymmetricAlgorithm;
import com.dahuatech.hutool.crypto.asymmetric.AsymmetricCrypto;
import com.dahuatech.hutool.crypto.asymmetric.KeyType;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAKey;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;

public class RSA
extends AsymmetricCrypto {
    private static final AsymmetricAlgorithm ALGORITHM_RSA = AsymmetricAlgorithm.RSA_ECB_PKCS1;

    public RSA() {
        super(ALGORITHM_RSA);
    }

    public RSA(String rsaAlgorithm) {
        super(rsaAlgorithm);
    }

    public RSA(String privateKeyStr, String publicKeyStr) {
        super(ALGORITHM_RSA, privateKeyStr, publicKeyStr);
    }

    public RSA(String rsaAlgorithm, String privateKeyStr, String publicKeyStr) {
        super(rsaAlgorithm, privateKeyStr, publicKeyStr);
    }

    public RSA(byte[] privateKey, byte[] publicKey) {
        super(ALGORITHM_RSA, privateKey, publicKey);
    }

    public RSA(BigInteger modulus, BigInteger privateExponent, BigInteger publicExponent) {
        this(RSA.generatePrivateKey(modulus, privateExponent), RSA.generatePublicKey(modulus, publicExponent));
    }

    public RSA(PrivateKey privateKey, PublicKey publicKey) {
        super(ALGORITHM_RSA, privateKey, publicKey);
    }

    public RSA(String rsaAlgorithm, PrivateKey privateKey, PublicKey publicKey) {
        super(rsaAlgorithm, privateKey, publicKey);
    }

    public static PrivateKey generatePrivateKey(BigInteger modulus, BigInteger privateExponent) {
        return SecureUtil.generatePrivateKey(ALGORITHM_RSA.getValue(), new RSAPrivateKeySpec(modulus, privateExponent));
    }

    public static PublicKey generatePublicKey(BigInteger modulus, BigInteger publicExponent) {
        return SecureUtil.generatePublicKey(ALGORITHM_RSA.getValue(), new RSAPublicKeySpec(modulus, publicExponent));
    }

    @Deprecated
    public String encryptStr(String data, KeyType keyType) {
        return this.encryptBcd(data, keyType, CharsetUtil.CHARSET_UTF_8);
    }

    @Deprecated
    public String encryptStr(String data, KeyType keyType, Charset charset) {
        return this.encryptBcd(data, keyType, charset);
    }

    @Override
    public byte[] encrypt(byte[] data, KeyType keyType) {
        if (this.encryptBlockSize < 0) {
            this.encryptBlockSize = ((RSAKey)((Object)this.getKeyByType(keyType))).getModulus().bitLength() / 8 - 11;
        }
        return super.encrypt(data, keyType);
    }

    @Override
    public byte[] decrypt(byte[] bytes, KeyType keyType) {
        if (this.decryptBlockSize < 0) {
            this.decryptBlockSize = ((RSAKey)((Object)this.getKeyByType(keyType))).getModulus().bitLength() / 8;
        }
        return super.decrypt(bytes, keyType);
    }

    @Override
    protected void initCipher() {
        try {
            super.initCipher();
        }
        catch (CryptoException e) {
            Throwable cause = e.getCause();
            if (cause instanceof NoSuchAlgorithmException) {
                this.algorithm = AsymmetricAlgorithm.RSA.getValue();
                super.initCipher();
            }
            throw e;
        }
    }
}

