/*
 * Decompiled with CFR 0.152.
 */
package com.dahuatech.hutool.core.lang;

import com.dahuatech.hutool.core.lang.Assert;
import com.dahuatech.hutool.core.util.ArrayUtil;
import com.dahuatech.hutool.core.util.ClassUtil;
import com.dahuatech.hutool.core.util.ReflectUtil;
import com.dahuatech.hutool.core.util.StrUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class Singleton {
    private static Map<String, Object> pool = new ConcurrentHashMap<String, Object>();

    private Singleton() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T> T get(Class<T> clazz, Object ... params) {
        Assert.notNull(clazz, "Class must be not null !", new Object[0]);
        String key = Singleton.buildKey(clazz.getName(), params);
        Object obj = pool.get(key);
        if (null != obj) return (T)obj;
        Class<Singleton> clazz2 = Singleton.class;
        synchronized (Singleton.class) {
            obj = pool.get(key);
            if (null != obj) return (T)obj;
            obj = ReflectUtil.newInstance(clazz, params);
            pool.put(key, obj);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return (T)obj;
        }
    }

    public static <T> T get(String className, Object ... params) {
        Assert.notBlank(className, "Class name must be not blank !", new Object[0]);
        Class clazz = ClassUtil.loadClass(className);
        return Singleton.get(clazz, params);
    }

    public static void put(Object obj) {
        Assert.notNull(obj, "Bean object must be not null !", new Object[0]);
        pool.put(obj.getClass().getName(), obj);
    }

    public static void remove(Class<?> clazz) {
        if (null != clazz) {
            pool.remove(clazz.getName());
        }
    }

    public static void destroy() {
        pool.clear();
    }

    private static String buildKey(String className, Object ... params) {
        if (ArrayUtil.isEmpty(params)) {
            return className;
        }
        return StrUtil.format((CharSequence)"{}#{}", className, ArrayUtil.join(params, (CharSequence)"_"));
    }
}

