package com.dada.smart.user.log;

import android.arch.persistence.room.Database;
import android.arch.persistence.room.Room;
import android.arch.persistence.room.RoomDatabase;
import android.content.Context;


/**
 * Created by tomkeyzhang on 16/5/18.
 */

@Database(entities = {Log.class}, version = 1)
public abstract class LogDatabase extends RoomDatabase {
    public abstract LogDao logDao();
//    public abstract EventDao eventDao();

    private static LogDatabase INSTANCE;

    public static LogDatabase getDatabase(Context context) {
        if (INSTANCE == null) {
            synchronized (LogDatabase.class) {
                if (INSTANCE == null) {
                    INSTANCE = Room.databaseBuilder(context.getApplicationContext(),
                            LogDatabase.class, "smart_log_db")
                            .build();
                }
            }
        }
        return INSTANCE;
    }
}
