/*
 * Decompiled with CFR 0.152.
 */
package com.dada.smart.user.event;

import android.text.TextUtils;
import android.util.SparseBooleanArray;
import com.dada.smart.common.expression.Expressions;
import com.dada.smart.user.event.ViewTreeChild;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class Event {
    public static final long TYPE_CLICK = 1L;
    public static final long TYPE_PV_START = 2L;
    public static final long TYPE_PV_END = 3L;
    public static final long TYPE_VIEW_SHOW = 4L;
    public static final long TYPE_APP_START = -1L;
    private long id;
    private long typeId;
    private String viewIdName;
    private String viewClassName;
    private List<ViewTreeChild> viewTreeChildren = new ArrayList<ViewTreeChild>();
    private boolean inMainWindow = true;
    private String expressions;
    private SparseBooleanArray positions;

    public static Event fromJson(JSONObject object) throws JSONException {
        Event event = new Event();
        event.id = object.getLong("id");
        event.typeId = object.getLong("typeId");
        event.expressions = object.optString("expressions");
        event.parsePosition();
        String widgetIdentifier = object.getString("widgetIdentifier");
        event.parseWidgetIdentifier(widgetIdentifier);
        return event;
    }

    private void parsePosition() {
        if (!TextUtils.isEmpty((CharSequence)this.expressions)) {
            this.positions = Expressions.findPosition((String)this.expressions);
        }
    }

    public boolean hasPos(int posKey) {
        return this.positions != null && this.positions.get(posKey);
    }

    private void parseWidgetIdentifier(String widgetIdentifier) {
        String[] ss;
        boolean noId = false;
        if (widgetIdentifier.contains("@") && (ss = widgetIdentifier.split("@")).length >= 2) {
            String[] typeContent;
            String pre = ss[0];
            if (pre.contains(",") && (typeContent = pre.split(",")).length >= 2) {
                this.inMainWindow = TextUtils.equals((CharSequence)typeContent[0], (CharSequence)"1");
                noId = TextUtils.equals((CharSequence)typeContent[1], (CharSequence)"2");
            }
            widgetIdentifier = ss[1];
        }
        if (noId || widgetIdentifier.contains(";")) {
            String[] viewTrees = widgetIdentifier.split(";");
            if (viewTrees.length > 0) {
                for (String viewTree : viewTrees) {
                    String[] viewTressDesc = viewTree.split(",");
                    if (viewTressDesc.length != 3) continue;
                    ViewTreeChild child = new ViewTreeChild();
                    child.className = viewTressDesc[0];
                    try {
                        child.brothersCount = Integer.parseInt(viewTressDesc[1]);
                        child.index = Integer.parseInt(viewTressDesc[2]);
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                    this.viewTreeChildren.add(child);
                }
            }
        } else {
            String[] array = widgetIdentifier.split(",");
            if (array.length >= 2) {
                this.viewClassName = array[0];
                this.viewIdName = array[1];
            }
        }
    }

    public boolean isInMainWindow() {
        return this.inMainWindow;
    }

    public long getId() {
        return this.id;
    }

    public long getTypeId() {
        return this.typeId;
    }

    public String getViewIdName() {
        return this.viewIdName;
    }

    public String getViewClassName() {
        return this.viewClassName;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setTypeId(long typeId) {
        this.typeId = typeId;
    }

    public void setViewIdName(String viewIdName) {
        this.viewIdName = viewIdName;
    }

    public void setViewClassName(String viewClassName) {
        this.viewClassName = viewClassName;
    }

    public String getExpressions() {
        return this.expressions;
    }

    public List<ViewTreeChild> getViewTreeChildren() {
        return this.viewTreeChildren;
    }

    public boolean isIdMatcher() {
        return this.viewTreeChildren.isEmpty();
    }

    public boolean isActivityEvent() {
        return 2L == this.typeId || 3L == this.typeId;
    }

    public boolean isViewEvent() {
        return 1L == this.typeId || 4L == this.typeId;
    }

    public String toString() {
        return "id:" + this.id + " typeId:" + this.typeId + " viewIdPath:" + this.viewIdName + " viewClassName:" + this.viewClassName + " expressions:" + this.expressions;
    }

    public boolean checkAllTreeViewVerified() {
        if (this.viewTreeChildren.isEmpty()) {
            return false;
        }
        for (ViewTreeChild child : this.viewTreeChildren) {
            if (child.isPassVerify()) continue;
            return false;
        }
        for (ViewTreeChild child : this.viewTreeChildren) {
            child.setPassVerify(false);
        }
        return true;
    }
}

