/*
 * Decompiled with CFR 0.152.
 */
package com.dada.smart.user;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import com.dada.smart.common.ActivityMonitor;
import com.dada.smart.common.Utils;
import com.dada.smart.common.expression.Expressions;
import com.dada.smart.common.expression.Extra;
import com.dada.smart.common.expression.Result;
import com.dada.smart.user.event.Event;
import com.dada.smart.user.event.EventLogRepository;
import com.dada.smart.user.event.ViewEvent;
import com.dada.smart.user.event.ViewEventListener;
import com.dada.smart.user.http.CacheHttpClient;
import com.dada.smart.user.http.Client;
import com.dada.smart.user.log.LogDatabase;
import com.dada.smart.user.visitor.ActivityVisitor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class ViewMonitor
extends ActivityMonitor {
    private Map<Activity, ActivityVisitor> activityVisitorMap;
    private EventLogRepository eventLogRepository;
    private ViewEventListener listener;
    private long appId;
    private SharedPreferences preferences;

    public ViewMonitor(Context context, long appId, String server, Client client, EventLogRepository.RequestParam requestParam, boolean debug) {
        super(context, debug);
        this.appId = appId;
        this.preferences = context.getSharedPreferences("app_start.pref", 0);
        this.eventLogRepository = new EventLogRepository.Builder(server).logDao(LogDatabase.getDatabase(context).logDao()).client(client).requestParam(requestParam).build();
        this.listener = new EventListener();
        this.activityVisitorMap = new HashMap<Activity, ActivityVisitor>();
    }

    public ViewMonitor(Context context, long appId, String server, EventLogRepository.RequestParam requestParam, boolean debug) {
        this(context, appId, server, new CacheHttpClient(context.getSharedPreferences("manager.pref", 0)), requestParam, debug);
    }

    public void update() {
        this.eventLogRepository.fetchConfig(this.appId);
        this.eventLogRepository.sendAppStartEventIfNeed(this.preferences, System.currentTimeMillis(), this.appId);
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        super.onActivityCreated(activity, savedInstanceState);
        String activityName = Utils.canonicalName((Object)activity);
        if (this.eventLogRepository.hasEvent(activityName)) {
            ActivityVisitor activityVisitor = new ActivityVisitor(activity, this.eventLogRepository.getEvents(activityName), this.eventLogRepository.getPvEvents(activityName), this.listener, this.getResourceIds());
            activityVisitor.onCreate();
            this.activityVisitorMap.put(activity, activityVisitor);
        }
    }

    public void onActivityStopped(Activity activity) {
        super.onActivityStopped(activity);
        if (this.eventLogRepository.hasEvent(Utils.canonicalName((Object)activity))) {
            this.eventLogRepository.sendEvents(this.appId);
        }
    }

    public void onActivityDestroyed(Activity activity) {
        super.onActivityDestroyed(activity);
        if (this.activityVisitorMap.containsKey(activity)) {
            this.activityVisitorMap.get(activity).onDestroy();
            this.activityVisitorMap.remove(activity);
        }
    }

    public void onEvent(ViewEvent viewEvent) {
        Event event = viewEvent.getEvent();
        List results = Expressions.fetchResult((Object)this.uiThreadObject().get(), (String)event.getExpressions(), (Extra)viewEvent);
        JSONObject object = new JSONObject();
        for (Result result : results) {
            if (result.isTypeEqual()) {
                if (result.isLeftEqualsValue()) continue;
                return;
            }
            if (!result.isTypeAssign()) continue;
            try {
                object.put(result.getLeft(), (Object)result.getValue());
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        this.eventLogRepository.onEvent(event.getId(), event.getTypeId(), this.getLastPageClass(), object.toString());
    }

    private class EventListener
    implements ViewEventListener {
        private EventListener() {
        }

        @Override
        public void onEvent(ViewEvent event) {
            ViewMonitor.this.onEvent(event);
        }
    }
}

