/*
 * Decompiled with CFR 0.152.
 */
package com.dada.smart.user.visitor;

import android.app.Activity;
import android.support.annotation.NonNull;
import com.dada.smart.common.ResourceIds;
import com.dada.smart.common.Utils;
import com.dada.smart.user.event.Event;
import com.dada.smart.user.event.Events;
import com.dada.smart.user.event.ViewEvent;
import com.dada.smart.user.event.ViewEventListener;
import com.dada.smart.user.visitor.ViewVisitor;
import java.util.List;

public class ActivityVisitor {
    private ViewEventListener listener;
    private List<Event> pvEvents;
    private ViewVisitor viewVisitor;

    public ActivityVisitor(@NonNull Activity activity, @NonNull Events viewEvents, @NonNull List<Event> pvEvents, @NonNull ViewEventListener listener, @NonNull ResourceIds resourceIds) {
        this.listener = listener;
        this.pvEvents = pvEvents;
        if (viewEvents != null) {
            this.viewVisitor = new ViewVisitor(activity, resourceIds, viewEvents, listener);
        }
    }

    public void onCreate() {
        this.triggerPvEventIfSet(2L);
        if (this.viewVisitor != null) {
            this.viewVisitor.onCreate();
        }
    }

    public void onDestroy() {
        this.triggerPvEventIfSet(3L);
        if (this.viewVisitor != null) {
            this.viewVisitor.onDestroy();
            this.viewVisitor = null;
        }
    }

    private void triggerPvEventIfSet(long typeId) {
        if (!Utils.isEmpty(this.pvEvents)) {
            for (Event event : this.pvEvents) {
                if (event.getTypeId() != typeId) continue;
                this.listener.onEvent(new ViewEvent(event, null));
            }
        }
    }
}

