/*
 * Decompiled with CFR 0.152.
 */
package com.dada.smart.user.event;

import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import com.dada.smart.common.Utils;
import com.dada.smart.user.event.Event;
import com.dada.smart.user.event.Events;
import com.dada.smart.user.http.Client;
import com.dada.smart.user.log.Log;
import com.dada.smart.user.log.LogDao;
import com.dada.smart.user.util.DataUtil;
import com.orhanobut.logger.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class EventLogRepository {
    private final int CODE_OK = 0;
    private final String PREF_APP_START_TIME = "app_start_time";
    private Executor singleExecutor;
    private Executor commonExecutor;
    private Client client;
    private LogDao logDao;
    private String server;
    private Map<String, Events> eventMap;
    private Map<String, List<Event>> pvEventMap;
    private RequestParam requestParam;

    private EventLogRepository(String server) {
        this.server = server;
        this.eventMap = new HashMap<String, Events>();
        this.pvEventMap = new HashMap<String, List<Event>>();
    }

    public void onEvent(final long eventId, final long typeId, final String refPageName, final String extra) {
        this.singleExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EventLogRepository.this.logDao.insert(new Log(eventId, System.currentTimeMillis(), typeId, refPageName, extra));
                    Logger.v((String)("onEvent:" + typeId + "-" + eventId + "-" + extra), (Object[])new Object[0]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void sendAppStartEventIfNeed(SharedPreferences preferences, long currentMills, long appId) {
        long appFirstStartMillis = preferences.getLong("app_start_time", 0L);
        if (!DataUtil.isTheSameDay(appFirstStartMillis, currentMills)) {
            this.onEvent(0L, -1L, "", "");
            this.sendEvents(appId);
            preferences.edit().putLong("app_start_time", currentMills).apply();
        }
    }

    public void sendEvents(final long appId) {
        this.singleExecutor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                EventLogRepository eventLogRepository = EventLogRepository.this;
                synchronized (eventLogRepository) {
                    try {
                        List<Log> logs = EventLogRepository.this.logDao.get(20);
                        if (logs.isEmpty()) {
                            return;
                        }
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        if (EventLogRepository.this.requestParam != null) {
                            map.putAll(EventLogRepository.this.requestParam.params());
                        }
                        map.put("appId", appId);
                        map.put("events", EventLogRepository.this.convertLog(logs));
                        String url = EventLogRepository.this.server + "/event/log/upload";
                        Client.Call call = EventLogRepository.this.client.makeCall(Client.Method.POST, url, map);
                        JSONObject object = new JSONObject(call.execute());
                        if (0L == object.optLong("code")) {
                            EventLogRepository.this.logDao.delete(logs);
                            Logger.v((String)("delete logs:" + logs.size()), (Object[])new Object[0]);
                        }
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    catch (RuntimeException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    public void fetchConfig(final long appId) {
        this.commonExecutor.execute(new Runnable(){

            @Override
            public void run() {
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("appId", appId);
                param.put("sdk", "1.0.13");
                String url = EventLogRepository.this.server + "/event/config/list";
                Client.Call call = EventLogRepository.this.client.makeCall(Client.Method.GET, url, param);
                EventLogRepository.this.fetchActivityEvents(call.cache());
                EventLogRepository.this.fetchActivityEvents(call.execute());
            }
        });
    }

    public Events getEvents(String activityName) {
        return this.eventMap.get(activityName);
    }

    public List<Event> getPvEvents(String activityName) {
        return this.pvEventMap.get(activityName);
    }

    public boolean hasEvent(String activityName) {
        return this.eventMap.containsKey(activityName) || this.pvEventMap.containsKey(activityName);
    }

    private JSONArray convertLog(List<Log> logs) throws JSONException {
        JSONArray array = new JSONArray();
        for (int i = 0; i < logs.size(); ++i) {
            JSONObject object = new JSONObject();
            Log log = logs.get(i);
            object.put("id", log.getEventId());
            object.put("typeId", log.getEventTypeId());
            object.put("refPageIdentifier", (Object)log.getRefPageIdentifier());
            object.put("createTime", log.getTriggerTime());
            object.put("extra", (Object)log.getExtra());
            array.put((Object)object);
        }
        return array;
    }

    private void fetchActivityEvents(String result) {
        if (Utils.isEmpty((String)result)) {
            return;
        }
        try {
            JSONObject object = new JSONObject(result);
            if (0L == object.optLong("code", -1L)) {
                JSONArray array = object.getJSONArray("body");
                for (int i = 0; i < array.length(); ++i) {
                    JSONObject activity = array.getJSONObject(i);
                    String pageIdentifier = activity.optString("pageIdentifier");
                    JSONArray eventArray = activity.getJSONArray("events");
                    ArrayList<Event> events = new ArrayList<Event>();
                    ArrayList<Event> pvEvents = new ArrayList<Event>();
                    boolean inMainWindow = true;
                    for (int j = 0; j < eventArray.length(); ++j) {
                        Event event = Event.fromJson(eventArray.getJSONObject(j));
                        if (event.isActivityEvent()) {
                            pvEvents.add(event);
                            continue;
                        }
                        if (!event.isViewEvent()) continue;
                        if (inMainWindow) {
                            inMainWindow = event.isInMainWindow();
                        }
                        events.add(event);
                    }
                    if (!events.isEmpty()) {
                        this.eventMap.put(pageIdentifier, new Events(inMainWindow, events));
                    }
                    if (pvEvents.isEmpty()) continue;
                    this.pvEventMap.put(pageIdentifier, pvEvents);
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @VisibleForTesting
    public Map<String, Events> getEventMap() {
        return this.eventMap;
    }

    @VisibleForTesting
    public Map<String, List<Event>> getPvEventMap() {
        return this.pvEventMap;
    }

    public static class Builder {
        private EventLogRepository repository;

        public Builder(@NonNull String server) {
            this.repository = new EventLogRepository(server);
        }

        public Builder client(Client client) {
            this.repository.client = client;
            return this;
        }

        public Builder logDao(LogDao logDao) {
            this.repository.logDao = logDao;
            return this;
        }

        public Builder requestParam(RequestParam requestParam) {
            this.repository.requestParam = requestParam;
            return this;
        }

        public Builder singleExecutor(Executor executor) {
            this.repository.singleExecutor = executor;
            return this;
        }

        public Builder commonExecutor(Executor executor) {
            this.repository.commonExecutor = executor;
            return this;
        }

        public EventLogRepository build() {
            if (this.repository.singleExecutor == null) {
                this.repository.singleExecutor = Executors.newSingleThreadExecutor();
            }
            if (this.repository.commonExecutor == null) {
                this.repository.commonExecutor = new ThreadPoolExecutor(2, 20, 20L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(64), new ThreadPoolExecutor.DiscardOldestPolicy());
            }
            if (this.repository.client == null) {
                throw new RuntimeException("client must be set!");
            }
            if (this.repository.logDao == null) {
                throw new RuntimeException("logDao must be set!");
            }
            return this.repository;
        }
    }

    public static interface RequestParam {
        public Map<String, Object> params();
    }
}

