/*
 * Decompiled with CFR 0.152.
 */
package com.dada.smart.common;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public final class ReflectUtils {
    private final Class<?> type;
    private final Object object;

    private ReflectUtils(Class<?> type) {
        this(type, type);
    }

    private ReflectUtils(Class<?> type, Object object) {
        this.type = type;
        this.object = object;
    }

    public static ReflectUtils reflect(String className) throws ReflectException {
        return ReflectUtils.reflect(ReflectUtils.forName(className));
    }

    public static ReflectUtils reflect(String className, ClassLoader classLoader) throws ReflectException {
        return ReflectUtils.reflect(ReflectUtils.forName(className, classLoader));
    }

    public static ReflectUtils reflect(Class<?> clazz) throws ReflectException {
        return new ReflectUtils(clazz);
    }

    public static ReflectUtils reflect(Object object) throws ReflectException {
        return new ReflectUtils(object == null ? Object.class : object.getClass(), object);
    }

    private static Class<?> forName(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new ReflectException(e);
        }
    }

    private static Class<?> forName(String name, ClassLoader classLoader) {
        try {
            return Class.forName(name, true, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new ReflectException(e);
        }
    }

    public ReflectUtils newInstance() {
        return this.newInstance(new Object[0]);
    }

    public ReflectUtils newInstance(Object ... args) {
        Class<?>[] types = this.getArgsType(args);
        try {
            Constructor<?> constructor = this.type().getDeclaredConstructor(types);
            return this.newInstance(constructor, args);
        }
        catch (NoSuchMethodException e) {
            ArrayList list = new ArrayList();
            for (Constructor<?> constructor : this.type().getDeclaredConstructors()) {
                if (!this.match(constructor.getParameterTypes(), types)) continue;
                list.add(constructor);
            }
            if (list.isEmpty()) {
                throw new ReflectException(e);
            }
            this.sortConstructors(list);
            return this.newInstance((Constructor)list.get(0), args);
        }
    }

    private Class<?>[] getArgsType(Object ... args) {
        if (args == null) {
            return new Class[0];
        }
        Class[] result = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            Object value = args[i];
            result[i] = value == null ? NULL.class : value.getClass();
        }
        return result;
    }

    private void sortConstructors(List<Constructor<?>> list) {
        Collections.sort(list, new Comparator<Constructor<?>>(){

            @Override
            public int compare(Constructor<?> o1, Constructor<?> o2) {
                Class<?>[] types1 = o1.getParameterTypes();
                Class<?>[] types2 = o2.getParameterTypes();
                int len = types1.length;
                for (int i = 0; i < len; ++i) {
                    if (types1[i].equals(types2[i])) continue;
                    if (ReflectUtils.this.wrapper(types1[i]).isAssignableFrom(ReflectUtils.this.wrapper(types2[i]))) {
                        return 1;
                    }
                    return -1;
                }
                return 0;
            }
        });
    }

    private ReflectUtils newInstance(Constructor<?> constructor, Object ... args) {
        try {
            return new ReflectUtils(constructor.getDeclaringClass(), this.accessible(constructor).newInstance(args));
        }
        catch (Exception e) {
            throw new ReflectException(e);
        }
    }

    public ReflectUtils field(String name) {
        try {
            Field field = this.getField(name);
            return new ReflectUtils(field.getType(), field.get(this.object));
        }
        catch (IllegalAccessException e) {
            throw new ReflectException(e);
        }
    }

    public ReflectUtils field(String name, Object value) {
        try {
            Field field = this.getField(name);
            field.set(this.object, this.unwrap(value));
            return this;
        }
        catch (Exception e) {
            throw new ReflectException(e);
        }
    }

    private Field getField(String name) throws IllegalAccessException {
        Field field = this.getAccessibleField(name);
        if ((field.getModifiers() & 0x10) == 16) {
            try {
                Field modifiersField = Field.class.getDeclaredField("modifiers");
                modifiersField.setAccessible(true);
                modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        return field;
    }

    private Field getAccessibleField(String name) {
        Class<?> type = this.type();
        try {
            return this.accessible(type.getField(name));
        }
        catch (NoSuchFieldException e) {
            while (true) {
                try {
                    return this.accessible(type.getDeclaredField(name));
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    if ((type = type.getSuperclass()) != null) continue;
                    throw new ReflectException(e);
                }
                break;
            }
        }
    }

    private Object unwrap(Object object) {
        if (object instanceof ReflectUtils) {
            return ((ReflectUtils)object).get();
        }
        return object;
    }

    public ReflectUtils method(String name) throws ReflectException {
        return this.method(name, new Object[0]);
    }

    public ReflectUtils method(String name, Object ... args) throws ReflectException {
        Class<?>[] types = this.getArgsType(args);
        try {
            Method method = this.exactMethod(name, types);
            return this.method(method, this.object, args);
        }
        catch (NoSuchMethodException e) {
            try {
                Method method = this.similarMethod(name, types);
                return this.method(method, this.object, args);
            }
            catch (NoSuchMethodException e1) {
                throw new ReflectException(e1);
            }
        }
    }

    private ReflectUtils method(Method method, Object obj, Object ... args) {
        try {
            this.accessible(method);
            if (method.getReturnType() == Void.TYPE) {
                method.invoke(obj, args);
                return ReflectUtils.reflect(obj);
            }
            return ReflectUtils.reflect(method.invoke(obj, args));
        }
        catch (Exception e) {
            throw new ReflectException(e);
        }
    }

    private Method exactMethod(String name, Class<?>[] types) throws NoSuchMethodException {
        Class<?> type = this.type();
        try {
            return type.getMethod(name, types);
        }
        catch (NoSuchMethodException e) {
            while (true) {
                try {
                    return type.getDeclaredMethod(name, types);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    if ((type = type.getSuperclass()) != null) continue;
                    throw new NoSuchMethodException();
                }
                break;
            }
        }
    }

    private Method similarMethod(String name, Class<?>[] types) throws NoSuchMethodException {
        Class<?> type = this.type();
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method method : type.getMethods()) {
            if (!this.isSimilarSignature(method, name, types)) continue;
            methods.add(method);
        }
        if (!methods.isEmpty()) {
            this.sortMethods(methods);
            return (Method)methods.get(0);
        }
        do {
            for (Method method : type.getDeclaredMethods()) {
                if (!this.isSimilarSignature(method, name, types)) continue;
                methods.add(method);
            }
            if (methods.isEmpty()) continue;
            this.sortMethods(methods);
            return (Method)methods.get(0);
        } while ((type = type.getSuperclass()) != null);
        throw new NoSuchMethodException("No similar method " + name + " with params " + Arrays.toString(types) + " could be found on type " + this.type() + ".");
    }

    private void sortMethods(List<Method> methods) {
        Collections.sort(methods, new Comparator<Method>(){

            @Override
            public int compare(Method o1, Method o2) {
                Class<?>[] types1 = o1.getParameterTypes();
                Class<?>[] types2 = o2.getParameterTypes();
                int len = types1.length;
                for (int i = 0; i < len; ++i) {
                    if (types1[i].equals(types2[i])) continue;
                    if (ReflectUtils.this.wrapper(types1[i]).isAssignableFrom(ReflectUtils.this.wrapper(types2[i]))) {
                        return 1;
                    }
                    return -1;
                }
                return 0;
            }
        });
    }

    private boolean isSimilarSignature(Method possiblyMatchingMethod, String desiredMethodName, Class<?>[] desiredParamTypes) {
        return possiblyMatchingMethod.getName().equals(desiredMethodName) && this.match(possiblyMatchingMethod.getParameterTypes(), desiredParamTypes);
    }

    private boolean match(Class<?>[] declaredTypes, Class<?>[] actualTypes) {
        if (declaredTypes.length == actualTypes.length) {
            for (int i = 0; i < actualTypes.length; ++i) {
                if (actualTypes[i] == NULL.class || this.wrapper(declaredTypes[i]).isAssignableFrom(this.wrapper(actualTypes[i]))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private <T extends AccessibleObject> T accessible(T accessible) {
        Member member;
        if (accessible == null) {
            return null;
        }
        if (accessible instanceof Member && Modifier.isPublic((member = (Member)((Object)accessible)).getModifiers()) && Modifier.isPublic(member.getDeclaringClass().getModifiers())) {
            return accessible;
        }
        if (!accessible.isAccessible()) {
            accessible.setAccessible(true);
        }
        return accessible;
    }

    public <P> P proxy(Class<P> proxyType) {
        final boolean isMap = this.object instanceof Map;
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) {
                String name = method.getName();
                try {
                    return ReflectUtils.reflect(ReflectUtils.this.object).method(name, args).get();
                }
                catch (ReflectException e) {
                    if (isMap) {
                        int length;
                        Map map = (Map)ReflectUtils.this.object;
                        int n = length = args == null ? 0 : args.length;
                        if (length == 0 && name.startsWith("get")) {
                            return map.get(ReflectUtils.property(name.substring(3)));
                        }
                        if (length == 0 && name.startsWith("is")) {
                            return map.get(ReflectUtils.property(name.substring(2)));
                        }
                        if (length == 1 && name.startsWith("set")) {
                            map.put(ReflectUtils.property(name.substring(3)), args[0]);
                            return null;
                        }
                    }
                    throw e;
                }
            }
        };
        return (P)Proxy.newProxyInstance(proxyType.getClassLoader(), new Class[]{proxyType}, handler);
    }

    private static String property(String string) {
        int length = string.length();
        if (length == 0) {
            return "";
        }
        if (length == 1) {
            return string.toLowerCase();
        }
        return string.substring(0, 1).toLowerCase() + string.substring(1);
    }

    private Class<?> type() {
        return this.type;
    }

    private Class<?> wrapper(Class<?> type) {
        if (type == null) {
            return null;
        }
        if (type.isPrimitive()) {
            if (Boolean.TYPE == type) {
                return Boolean.class;
            }
            if (Integer.TYPE == type) {
                return Integer.class;
            }
            if (Long.TYPE == type) {
                return Long.class;
            }
            if (Short.TYPE == type) {
                return Short.class;
            }
            if (Byte.TYPE == type) {
                return Byte.class;
            }
            if (Double.TYPE == type) {
                return Double.class;
            }
            if (Float.TYPE == type) {
                return Float.class;
            }
            if (Character.TYPE == type) {
                return Character.class;
            }
            if (Void.TYPE == type) {
                return Void.class;
            }
        }
        return type;
    }

    public <T> T get() {
        return (T)this.object;
    }

    public int hashCode() {
        return this.object.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof ReflectUtils && this.object.equals(((ReflectUtils)obj).get());
    }

    public String toString() {
        return this.object.toString();
    }

    public static class ReflectException
    extends RuntimeException {
        private static final long serialVersionUID = 858774075258496016L;

        public ReflectException(String message) {
            super(message);
        }

        public ReflectException(String message, Throwable cause) {
            super(message, cause);
        }

        public ReflectException(Throwable cause) {
            super(cause);
        }
    }

    private static class NULL {
        private NULL() {
        }
    }
}

