package com.dada.smart.common.expression;

import java.util.regex.Pattern;

public class Result {
    private static final Pattern varNamePattern = Pattern.compile("\\p{Lower}\\w*");
    private static final String UNKNOWN = "unknown";
    public static final String TYPE_ASSIGN = "assign";
    public static final String TYPE_EQUAL = "equal";

    private String expression;
    String left = UNKNOWN;
    String right = UNKNOWN;
    String type = UNKNOWN;
    String value;
    private String baseClassName;
    boolean success = false;

    Result(String expression) {
        this.expression = expression;
        try {
            String[] array;
            if (expression.contains("==")) {
                array = expression.split("==");
                type = TYPE_EQUAL;
            } else {
                array = expression.split("=");
                type = TYPE_ASSIGN;
                if (!varNamePattern.matcher(array[0]).matches()) {
                    value = "左侧变量名称不合法";
                    return;
                }
            }
            this.left = array[0];
            this.right = array[1];
            //enable=<android.support.v4.app.NotificationManagerCompat>from(this).areNotificationsEnabled()
            if (right.startsWith("<") && right.contains(">")) {
                array = right.replaceFirst("<", "").split(">");
                baseClassName = array[0];
                right = array[1];
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isParseOk() {
        return !UNKNOWN.equals(left) && !UNKNOWN.equals(right) && !UNKNOWN.equals(type);
    }

    public String getBaseClassName() {
        String clzz = baseClassName;
        baseClassName = null;
        return clzz;
    }

    public boolean isSuccess() {
        return success;
    }

    public String getLeft() {
        return left;
    }

    public void setLeft(String left) {
        this.left = left;
    }

    public String getRight() {
        return right;
    }

    public void setRight(String right) {
        this.right = right;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getExpression() {
        return expression;
    }

    public boolean isLeftEqualsValue() {
        return left != null && value != null && TYPE_EQUAL.equals(type) && left.equals(value);
    }

    public boolean isTypeEqual() {
        return TYPE_EQUAL.equals(type);
    }

    public boolean isTypeAssign() {
        return TYPE_ASSIGN.equals(type);
    }

    @Override
    public String toString() {
        return expression + "," + value;
    }
}

