package com.dada.smart.common;


import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/**
 * 线程池的管理类
 * Created by lakers on 17/9/22.
 */

public class ThreadPoolManager {
    private static Executor poolExecutor;

    //单列对象
    public static Executor getSingleThreadPollExecutor() {
        if (poolExecutor == null) {
            synchronized (ThreadPoolManager.class) {
                if (poolExecutor == null) {
                    //单线程只给2容量等待队列
                    poolExecutor = new ThreadPoolExecutor(1, 1, 0, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1), new ThreadPoolExecutor.DiscardOldestPolicy());
                }
            }
        }
        return poolExecutor;
    }

}