package com.dada.smart.common;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;

import com.orhanobut.logger.Logger;

import java.util.Stack;

/**
 * Created by tomkeyzhang on 15/5/18.
 */

public abstract class ActivityMonitor implements Application.ActivityLifecycleCallbacks {
    private UIThreadObject<Activity> uiThreadObject;
    private Stack<String> classes = new Stack<>();
    private ResourceIds mResourceIds;
    private Context context;
    private boolean debug;

    public ActivityMonitor(Context context, boolean debug) {
        this.debug = debug;
        this.context = context.getApplicationContext();
        this.mResourceIds = new ResourceReader.Ids(context.getPackageName(), context);
        this.uiThreadObject = new UIThreadObject<>();
        Application app = (Application) this.context;
        app.registerActivityLifecycleCallbacks(this);
    }

    public boolean isDebug() {
        return debug;
    }


    public ResourceIds getResourceIds() {
        return mResourceIds;
    }

    public Context getContext() {
        return context;
    }

    protected UIThreadObject<Activity> uiThreadObject() {
        return uiThreadObject;
    }

    @Override
    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        uiThreadObject.set(activity);
    }

    public String getLastPageClass() {
        return classes.size() == 2 ? classes.get(0) : "";
    }

    @Override
    public void onActivityStarted(Activity activity) {
    }

    @Override
    public void onActivityResumed(Activity activity) {
        uiThreadObject.set(activity);
        //todo 如果name不相等就说明是新的一个页面，需要测试一下
        String name = Utils.canonicalName(activity);
        if (classes.isEmpty() || !name.equals(classes.peek())) {
            classes.push(name);
        }
        if (classes.size() > 2)
            classes.remove(0);
        Logger.v("current="+name+","+classes.toString()+",lastPage="+getLastPageClass());
    }

    @Override
    public void onActivityPaused(Activity activity) {
        uiThreadObject.set(null);
    }

    @Override
    public void onActivityStopped(Activity activity) {
    }

    @Override
    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    @Override
    public void onActivityDestroyed(Activity activity) {

    }
}
